/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.common.type.EnumType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeWithName;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.sql.analyzer.FieldId;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.DefaultExpressionTraversalVisitor;
import com.facebook.presto.sql.tree.DereferenceExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.QualifiedName;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import io.airlift.slice.Slices;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public final class ExpressionTreeUtils {
    private ExpressionTreeUtils() {
    }

    static List<FunctionCall> extractAggregateFunctions(Map<NodeRef<FunctionCall>, FunctionHandle> functionHandles, Iterable<? extends Node> nodes, FunctionAndTypeManager functionAndTypeManager) {
        return ExpressionTreeUtils.extractExpressions(nodes, FunctionCall.class, ExpressionTreeUtils.isAggregationPredicate(functionHandles, functionAndTypeManager));
    }

    static List<FunctionCall> extractWindowFunctions(Iterable<? extends Node> nodes) {
        return ExpressionTreeUtils.extractExpressions(nodes, FunctionCall.class, ExpressionTreeUtils::isWindowFunction);
    }

    static List<FunctionCall> extractExternalFunctions(Map<NodeRef<FunctionCall>, FunctionHandle> functionHandles, Iterable<? extends Node> nodes, FunctionAndTypeManager functionAndTypeManager) {
        return ExpressionTreeUtils.extractExpressions(nodes, FunctionCall.class, ExpressionTreeUtils.isExternalFunctionPredicate(functionHandles, functionAndTypeManager));
    }

    public static <T extends Expression> List<T> extractExpressions(Iterable<? extends Node> nodes, Class<T> clazz) {
        return ExpressionTreeUtils.extractExpressions(nodes, clazz, Predicates.alwaysTrue());
    }

    private static Predicate<FunctionCall> isAggregationPredicate(Map<NodeRef<FunctionCall>, FunctionHandle> functionHandles, FunctionAndTypeManager functionAndTypeManager) {
        return functionCall -> (functionAndTypeManager.getFunctionMetadata((FunctionHandle)functionHandles.get(NodeRef.of((Node)functionCall))).getFunctionKind() == FunctionKind.AGGREGATE || functionCall.getFilter().isPresent()) && !functionCall.getWindow().isPresent() || functionCall.getOrderBy().isPresent();
    }

    private static boolean isWindowFunction(FunctionCall functionCall) {
        return functionCall.getWindow().isPresent();
    }

    private static Predicate<FunctionCall> isExternalFunctionPredicate(Map<NodeRef<FunctionCall>, FunctionHandle> functionHandles, FunctionAndTypeManager functionAndTypeManager) {
        return functionCall -> functionAndTypeManager.getFunctionMetadata((FunctionHandle)functionHandles.get(NodeRef.of((Node)functionCall))).getImplementationType().isExternal();
    }

    private static <T extends Expression> List<T> extractExpressions(Iterable<? extends Node> nodes, Class<T> clazz, Predicate<T> predicate) {
        Objects.requireNonNull(nodes, "nodes is null");
        Objects.requireNonNull(clazz, "clazz is null");
        Objects.requireNonNull(predicate, "predicate is null");
        return (List)ImmutableList.copyOf(nodes).stream().flatMap(node -> ExpressionTreeUtils.linearizeNodes(node).stream()).filter(clazz::isInstance).map(clazz::cast).filter(predicate).collect(ImmutableList.toImmutableList());
    }

    private static List<Node> linearizeNodes(Node node) {
        final ImmutableList.Builder nodes = ImmutableList.builder();
        new DefaultExpressionTraversalVisitor<Node, Void>(){

            public Node process(Node node, Void context) {
                Node result = (Node)super.process(node, (Object)context);
                nodes.add((Object)node);
                return result;
            }
        }.process(node, null);
        return nodes.build();
    }

    public static boolean isEqualComparisonExpression(Expression expression) {
        return expression instanceof ComparisonExpression && ((ComparisonExpression)expression).getOperator() == ComparisonExpression.Operator.EQUAL;
    }

    static Optional<TypeWithName> tryResolveEnumLiteralType(QualifiedName qualifiedName, FunctionAndTypeManager functionAndTypeManager) {
        Optional prefix = qualifiedName.getPrefix();
        if (!prefix.isPresent()) {
            return Optional.empty();
        }
        try {
            Type baseType = functionAndTypeManager.getType(TypeSignature.parseTypeSignature((String)((QualifiedName)prefix.get()).toString()));
            if (baseType instanceof TypeWithName && ((TypeWithName)baseType).getType() instanceof EnumType && ((EnumType)((TypeWithName)baseType).getType()).getEnumMap().containsKey(qualifiedName.getSuffix().toUpperCase(Locale.ENGLISH))) {
                return Optional.of((TypeWithName)baseType);
            }
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
        return Optional.empty();
    }

    public static Optional<Object> tryResolveEnumLiteral(DereferenceExpression node, Type nodeType) {
        QualifiedName qualifiedName = DereferenceExpression.getQualifiedName((DereferenceExpression)node);
        if (!(nodeType instanceof TypeWithName) || !(((TypeWithName)nodeType).getType() instanceof EnumType) || qualifiedName == null) {
            return Optional.empty();
        }
        EnumType enumType = (EnumType)((TypeWithName)nodeType).getType();
        String enumKey = qualifiedName.getSuffix().toUpperCase(Locale.ENGLISH);
        Preconditions.checkArgument((boolean)enumType.getEnumMap().containsKey(enumKey), (Object)String.format("No key '%s' in enum '%s'", enumKey, nodeType.getDisplayName()));
        Object enumValue = enumType.getEnumMap().get(enumKey);
        return enumValue instanceof String ? Optional.of(Slices.utf8Slice((String)((String)enumValue))) : Optional.of(enumValue);
    }

    public static FieldId checkAndGetColumnReferenceField(Expression expression, Multimap<NodeRef<Expression>, FieldId> columnReferences) {
        Preconditions.checkState((boolean)columnReferences.containsKey((Object)NodeRef.of((Node)expression)), (Object)"Missing field reference for expression");
        Preconditions.checkState((columnReferences.get((Object)NodeRef.of((Node)expression)).size() == 1 ? 1 : 0) != 0, (Object)"Multiple field references for expression");
        return (FieldId)columnReferences.get((Object)NodeRef.of((Node)expression)).iterator().next();
    }
}

