/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.bytecode.instruction.LabelNode;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.sql.gen.BytecodeGeneratorContext;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.SpecialFormBytecodeGenerator;
import com.facebook.presto.sql.gen.SqlTypeBytecodeExpression;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;

public class DereferenceCodeGenerator
implements SpecialFormBytecodeGenerator {
    @Override
    public BytecodeNode generateExpression(BytecodeGeneratorContext generator, Type returnType, List<RowExpression> arguments, Optional<Variable> outputBlockVariable) {
        Preconditions.checkArgument((arguments.size() == 2 ? 1 : 0) != 0);
        CallSiteBinder callSiteBinder = generator.getCallSiteBinder();
        ImmutableList.Builder nestedDerefernces = ImmutableList.builder();
        RowExpression nestedObject = arguments.get(0);
        int leafFieldIndex = ((Number)((ConstantExpression)arguments.get(1)).getValue()).intValue();
        while (nestedObject instanceof SpecialFormExpression && ((SpecialFormExpression)nestedObject).getForm() == SpecialFormExpression.Form.DEREFERENCE) {
            nestedDerefernces.add((Object)nestedObject);
            nestedObject = (RowExpression)((SpecialFormExpression)nestedObject).getArguments().get(0);
        }
        BytecodeBlock block = new BytecodeBlock().comment("DEREFERENCE").setDescription("DEREFERENCE");
        Variable rowBlock = generator.getScope().createTempVariable(Block.class);
        Variable wasNull = generator.wasNull();
        LabelNode end = new LabelNode("end");
        LabelNode returnNull = new LabelNode("returnNull");
        block.putVariable(wasNull, false).append(generator.generate(nestedObject, Optional.empty())).putVariable(rowBlock).comment("If the object is null return null").append((BytecodeNode)wasNull).ifTrueGoto(returnNull);
        for (RowExpression rowExpression : nestedDerefernces.build().reverse()) {
            SpecialFormExpression nestedDerefernce = (SpecialFormExpression)rowExpression;
            int fieldIndex = ((Number)((ConstantExpression)nestedDerefernce.getArguments().get(1)).getValue()).intValue();
            block.append((BytecodeNode)rowBlock).push(fieldIndex).invokeInterface(Block.class, "isNull", Boolean.TYPE, new Class[]{Integer.TYPE}).comment("If the deref result is null return null").ifTrueGoto(returnNull).append((BytecodeNode)SqlTypeBytecodeExpression.constantType(callSiteBinder, nestedDerefernce.getType()).getValue((BytecodeExpression)rowBlock, BytecodeExpressions.constantInt((int)fieldIndex))).putVariable(rowBlock);
        }
        block.append((BytecodeNode)rowBlock).push(((Number)((ConstantExpression)arguments.get(1)).getValue()).intValue()).invokeInterface(Block.class, "isNull", Boolean.TYPE, new Class[]{Integer.TYPE}).ifTrueGoto(returnNull);
        BytecodeExpression value = SqlTypeBytecodeExpression.constantType(callSiteBinder, returnType).getValue((BytecodeExpression)rowBlock, BytecodeExpressions.constantInt((int)leafFieldIndex));
        block.append((BytecodeNode)wasNull).ifTrueGoto(returnNull).append((BytecodeNode)value).gotoLabel(end);
        Class javaType = returnType.getJavaType();
        block.visitLabel(returnNull).pushJavaDefault(javaType).comment("if the field is null, push null to stack").putVariable(wasNull, true);
        block.visitLabel(end);
        outputBlockVariable.ifPresent(output -> block.append(SpecialFormBytecodeGenerator.generateWrite(generator, returnType, output)));
        return block;
    }
}

