/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.Scope;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.bytecode.instruction.Constant;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.function.SqlFunctionId;
import com.facebook.presto.spi.function.SqlInvokedFunction;
import com.facebook.presto.spi.function.SqlInvokedScalarFunctionImplementation;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.InputReferenceExpression;
import com.facebook.presto.spi.relation.LambdaDefinitionExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.gen.AndCodeGenerator;
import com.facebook.presto.sql.gen.BindCodeGenerator;
import com.facebook.presto.sql.gen.Binding;
import com.facebook.presto.sql.gen.BytecodeGeneratorContext;
import com.facebook.presto.sql.gen.BytecodeUtils;
import com.facebook.presto.sql.gen.CachedInstanceBinder;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.facebook.presto.sql.gen.CoalesceCodeGenerator;
import com.facebook.presto.sql.gen.DereferenceCodeGenerator;
import com.facebook.presto.sql.gen.FunctionCallCodeGenerator;
import com.facebook.presto.sql.gen.IfCodeGenerator;
import com.facebook.presto.sql.gen.InCodeGenerator;
import com.facebook.presto.sql.gen.IsNullCodeGenerator;
import com.facebook.presto.sql.gen.LambdaBytecodeGenerator;
import com.facebook.presto.sql.gen.NullIfCodeGenerator;
import com.facebook.presto.sql.gen.OrCodeGenerator;
import com.facebook.presto.sql.gen.RowConstructorCodeGenerator;
import com.facebook.presto.sql.gen.SpecialFormBytecodeGenerator;
import com.facebook.presto.sql.gen.SwitchCodeGenerator;
import com.facebook.presto.sql.relational.SqlFunctionUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class RowExpressionCompiler {
    private final ClassDefinition classDefinition;
    private final CallSiteBinder callSiteBinder;
    private final CachedInstanceBinder cachedInstanceBinder;
    private final RowExpressionVisitor<BytecodeNode, Scope> fieldReferenceCompiler;
    private final Metadata metadata;
    private final SqlFunctionProperties sqlFunctionProperties;
    private final Map<SqlFunctionId, SqlInvokedFunction> sessionFunctions;
    private final Map<LambdaDefinitionExpression, LambdaBytecodeGenerator.CompiledLambda> compiledLambdaMap;

    RowExpressionCompiler(ClassDefinition classDefinition, CallSiteBinder callSiteBinder, CachedInstanceBinder cachedInstanceBinder, RowExpressionVisitor<BytecodeNode, Scope> fieldReferenceCompiler, Metadata metadata, SqlFunctionProperties sqlFunctionProperties, Map<SqlFunctionId, SqlInvokedFunction> sessionFunctions, Map<LambdaDefinitionExpression, LambdaBytecodeGenerator.CompiledLambda> compiledLambdaMap) {
        this.classDefinition = classDefinition;
        this.callSiteBinder = callSiteBinder;
        this.cachedInstanceBinder = cachedInstanceBinder;
        this.fieldReferenceCompiler = fieldReferenceCompiler;
        this.metadata = metadata;
        this.sqlFunctionProperties = sqlFunctionProperties;
        this.sessionFunctions = sessionFunctions;
        this.compiledLambdaMap = new HashMap<LambdaDefinitionExpression, LambdaBytecodeGenerator.CompiledLambda>(compiledLambdaMap);
    }

    public BytecodeNode compile(RowExpression rowExpression, Scope scope, Optional<Variable> outputBlockVariable) {
        return this.compile(rowExpression, scope, outputBlockVariable, Optional.empty());
    }

    public BytecodeNode compile(RowExpression rowExpression, Scope scope, Optional<Variable> outputBlockVariable, Optional<Class> lambdaInterface) {
        return (BytecodeNode)rowExpression.accept((RowExpressionVisitor)new Visitor(), (Object)new Context(scope, outputBlockVariable, lambdaInterface));
    }

    private static class Context {
        private final Scope scope;
        private final Optional<Variable> outputBlockVariable;
        private final Optional<Class> lambdaInterface;

        public Context(Scope scope, Optional<Variable> outputBlockVariable, Optional<Class> lambdaInterface) {
            this.scope = scope;
            this.outputBlockVariable = outputBlockVariable;
            this.lambdaInterface = lambdaInterface;
        }

        public Scope getScope() {
            return this.scope;
        }

        public Optional<Variable> getOutputBlockVariable() {
            return this.outputBlockVariable;
        }

        public Optional<Class> getLambdaInterface() {
            return this.lambdaInterface;
        }
    }

    private class Visitor
    implements RowExpressionVisitor<BytecodeNode, Context> {
        private Visitor() {
        }

        public BytecodeNode visitCall(CallExpression call, Context context) {
            FunctionAndTypeManager functionAndTypeManager = RowExpressionCompiler.this.metadata.getFunctionAndTypeManager();
            FunctionMetadata functionMetadata = functionAndTypeManager.getFunctionMetadata(call.getFunctionHandle());
            switch (functionMetadata.getImplementationType()) {
                case BUILTIN: {
                    BytecodeGeneratorContext generatorContext = new BytecodeGeneratorContext(RowExpressionCompiler.this, context.getScope(), RowExpressionCompiler.this.callSiteBinder, RowExpressionCompiler.this.cachedInstanceBinder, functionAndTypeManager);
                    return new FunctionCallCodeGenerator().generateCall(call.getFunctionHandle(), generatorContext, call.getType(), call.getArguments(), context.getOutputBlockVariable());
                }
                case SQL: {
                    SqlInvokedScalarFunctionImplementation functionImplementation = (SqlInvokedScalarFunctionImplementation)functionAndTypeManager.getScalarFunctionImplementation(call.getFunctionHandle());
                    RowExpression function = SqlFunctionUtils.getSqlFunctionRowExpression(functionMetadata, functionImplementation, RowExpressionCompiler.this.metadata, RowExpressionCompiler.this.sqlFunctionProperties, RowExpressionCompiler.this.sessionFunctions, call.getArguments());
                    RowExpressionCompiler.this.compiledLambdaMap.putAll(LambdaBytecodeGenerator.generateMethodsForLambda(RowExpressionCompiler.this.classDefinition, RowExpressionCompiler.this.callSiteBinder, RowExpressionCompiler.this.cachedInstanceBinder, function, RowExpressionCompiler.this.metadata, RowExpressionCompiler.this.sqlFunctionProperties, (Map<SqlFunctionId, SqlInvokedFunction>)RowExpressionCompiler.this.sessionFunctions, "sql", RowExpressionCompiler.this.compiledLambdaMap.keySet()));
                    RowExpressionCompiler newRowExpressionCompiler = new RowExpressionCompiler(RowExpressionCompiler.this.classDefinition, RowExpressionCompiler.this.callSiteBinder, RowExpressionCompiler.this.cachedInstanceBinder, (RowExpressionVisitor<BytecodeNode, Scope>)RowExpressionCompiler.this.fieldReferenceCompiler, RowExpressionCompiler.this.metadata, RowExpressionCompiler.this.sqlFunctionProperties, RowExpressionCompiler.this.sessionFunctions, RowExpressionCompiler.this.compiledLambdaMap);
                    if (functionMetadata.isCalledOnNullInput() || call.getArguments().isEmpty()) {
                        return newRowExpressionCompiler.compile(function, context.getScope(), context.getOutputBlockVariable(), context.getLambdaInterface());
                    }
                    BytecodeGeneratorContext generatorContext = new BytecodeGeneratorContext(newRowExpressionCompiler, context.getScope(), RowExpressionCompiler.this.callSiteBinder, RowExpressionCompiler.this.cachedInstanceBinder, functionAndTypeManager);
                    return new IfCodeGenerator().generateExpression(generatorContext, call.getType(), (List<RowExpression>)ImmutableList.of((Object)call.getArguments().stream().map(argument -> new SpecialFormExpression(SpecialFormExpression.Form.IS_NULL, (Type)BooleanType.BOOLEAN, new RowExpression[]{argument})).reduce((a, b) -> new SpecialFormExpression(SpecialFormExpression.Form.OR, (Type)BooleanType.BOOLEAN, new RowExpression[]{a, b})).get(), (Object)new ConstantExpression(null, call.getType()), (Object)function), context.getOutputBlockVariable());
                }
            }
            throw new IllegalArgumentException(String.format("Unsupported function implementation type: %s", functionMetadata.getImplementationType()));
        }

        public BytecodeNode visitConstant(ConstantExpression constant, Context context) {
            Object value = constant.getValue();
            Class javaType = constant.getType().getJavaType();
            BytecodeBlock block = new BytecodeBlock();
            if (value == null) {
                block.comment("constant null").append((BytecodeNode)context.getScope().getVariable("wasNull").set(BytecodeExpressions.constantTrue())).pushJavaDefault(javaType);
            } else {
                block.comment("constant " + constant.getType().getTypeSignature());
                if (javaType == Boolean.TYPE) {
                    block.append((BytecodeNode)Constant.loadBoolean((boolean)((Boolean)value)));
                } else if (javaType == Byte.TYPE || javaType == Short.TYPE || javaType == Integer.TYPE) {
                    block.append((BytecodeNode)Constant.loadInt((int)((Number)value).intValue()));
                } else if (javaType == Long.TYPE) {
                    block.append((BytecodeNode)Constant.loadLong((long)((Long)value)));
                } else if (javaType == Float.TYPE) {
                    block.append((BytecodeNode)Constant.loadFloat((float)((Float)value).floatValue()));
                } else if (javaType == Double.TYPE) {
                    block.append((BytecodeNode)Constant.loadDouble((double)((Double)value)));
                } else if (javaType == String.class) {
                    block.append((BytecodeNode)Constant.loadString((String)((String)value)));
                } else {
                    Binding binding = RowExpressionCompiler.this.callSiteBinder.bind(value, constant.getType().getJavaType());
                    block = new BytecodeBlock().setDescription("constant " + constant.getType()).comment(constant.toString()).append((BytecodeNode)BytecodeUtils.loadConstant(binding));
                }
            }
            if (context.getOutputBlockVariable().isPresent()) {
                block.append(BytecodeUtils.generateWrite(RowExpressionCompiler.this.callSiteBinder, context.getScope(), context.getScope().getVariable("wasNull"), constant.getType(), context.getOutputBlockVariable().get()));
            }
            return block;
        }

        public BytecodeNode visitInputReference(InputReferenceExpression node, Context context) {
            BytecodeNode inputReferenceBytecode = (BytecodeNode)RowExpressionCompiler.this.fieldReferenceCompiler.visitInputReference(node, (Object)context.getScope());
            if (!context.getOutputBlockVariable().isPresent()) {
                return inputReferenceBytecode;
            }
            return new BytecodeBlock().append(inputReferenceBytecode).append(BytecodeUtils.generateWrite(RowExpressionCompiler.this.callSiteBinder, context.getScope(), context.getScope().getVariable("wasNull"), node.getType(), context.getOutputBlockVariable().get()));
        }

        public BytecodeNode visitLambda(LambdaDefinitionExpression lambda, Context context) {
            Preconditions.checkArgument((!context.getOutputBlockVariable().isPresent() ? 1 : 0) != 0, (Object)"lambda definition expression does not support writing to block");
            Preconditions.checkState((boolean)RowExpressionCompiler.this.compiledLambdaMap.containsKey(lambda), (Object)"lambda expressions map does not contain this lambda definition");
            if (!((Class)context.lambdaInterface.get()).isAnnotationPresent(FunctionalInterface.class)) {
                throw new VerifyException("lambda should be generated as class annotated with FunctionalInterface");
            }
            BytecodeGeneratorContext generatorContext = new BytecodeGeneratorContext(RowExpressionCompiler.this, context.getScope(), RowExpressionCompiler.this.callSiteBinder, RowExpressionCompiler.this.cachedInstanceBinder, RowExpressionCompiler.this.metadata.getFunctionAndTypeManager());
            return LambdaBytecodeGenerator.generateLambda(generatorContext, (List<RowExpression>)ImmutableList.of(), (LambdaBytecodeGenerator.CompiledLambda)RowExpressionCompiler.this.compiledLambdaMap.get(lambda), context.getLambdaInterface().get());
        }

        public BytecodeNode visitVariableReference(VariableReferenceExpression reference, Context context) {
            BytecodeNode variableReferenceByteCode = (BytecodeNode)RowExpressionCompiler.this.fieldReferenceCompiler.visitVariableReference(reference, (Object)context.getScope());
            if (!context.getOutputBlockVariable().isPresent()) {
                return variableReferenceByteCode;
            }
            return new BytecodeBlock().append(variableReferenceByteCode).append(BytecodeUtils.generateWrite(RowExpressionCompiler.this.callSiteBinder, context.getScope(), context.getScope().getVariable("wasNull"), reference.getType(), context.getOutputBlockVariable().get()));
        }

        public BytecodeNode visitSpecialForm(SpecialFormExpression specialForm, Context context) {
            SpecialFormBytecodeGenerator generator;
            switch (specialForm.getForm()) {
                case IF: {
                    generator = new IfCodeGenerator();
                    break;
                }
                case NULL_IF: {
                    generator = new NullIfCodeGenerator();
                    break;
                }
                case SWITCH: {
                    generator = new SwitchCodeGenerator();
                    break;
                }
                case IS_NULL: {
                    generator = new IsNullCodeGenerator();
                    break;
                }
                case COALESCE: {
                    generator = new CoalesceCodeGenerator();
                    break;
                }
                case IN: {
                    generator = new InCodeGenerator(RowExpressionCompiler.this.metadata.getFunctionAndTypeManager());
                    break;
                }
                case AND: {
                    generator = new AndCodeGenerator();
                    break;
                }
                case OR: {
                    generator = new OrCodeGenerator();
                    break;
                }
                case DEREFERENCE: {
                    generator = new DereferenceCodeGenerator();
                    break;
                }
                case ROW_CONSTRUCTOR: {
                    generator = new RowConstructorCodeGenerator();
                    break;
                }
                case BIND: {
                    generator = new BindCodeGenerator(RowExpressionCompiler.this.compiledLambdaMap, context.getLambdaInterface().get());
                    break;
                }
                default: {
                    throw new IllegalStateException("Cannot compile special form: " + specialForm.getForm());
                }
            }
            BytecodeGeneratorContext generatorContext = new BytecodeGeneratorContext(RowExpressionCompiler.this, context.getScope(), RowExpressionCompiler.this.callSiteBinder, RowExpressionCompiler.this.cachedInstanceBinder, RowExpressionCompiler.this.metadata.getFunctionAndTypeManager());
            return generator.generateExpression(generatorContext, specialForm.getType(), specialForm.getArguments(), context.getOutputBlockVariable());
        }
    }
}

