/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.MethodGenerationContext;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.instruction.InvokeInstruction;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.sql.gen.Binding;
import com.facebook.presto.sql.gen.Bootstrap;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;

public class SqlTypeBytecodeExpression
extends BytecodeExpression {
    private final Type type;
    private final Binding binding;
    private final Method bootstrapMethod;

    public static SqlTypeBytecodeExpression constantType(CallSiteBinder callSiteBinder, Type type) {
        Objects.requireNonNull(callSiteBinder, "callSiteBinder is null");
        Objects.requireNonNull(type, "type is null");
        Binding binding = callSiteBinder.bind(type, Type.class);
        return new SqlTypeBytecodeExpression(type, binding, Bootstrap.BOOTSTRAP_METHOD);
    }

    private static String generateName(Type type) {
        String name = type.getTypeSignature().toString();
        if (name.length() > 20) {
            name = type.getTypeSignature().getBase();
        }
        return name.replaceAll("\\W+", "_");
    }

    private SqlTypeBytecodeExpression(Type type, Binding binding, Method bootstrapMethod) {
        super(ParameterizedType.type(Type.class));
        this.type = Objects.requireNonNull(type, "type is null");
        this.binding = Objects.requireNonNull(binding, "binding is null");
        this.bootstrapMethod = Objects.requireNonNull(bootstrapMethod, "bootstrapMethod is null");
    }

    public BytecodeNode getBytecode(MethodGenerationContext generationContext) {
        return InvokeInstruction.invokeDynamic((String)SqlTypeBytecodeExpression.generateName(this.type), (MethodType)this.binding.getType(), (Method)this.bootstrapMethod, (Object[])new Object[]{this.binding.getBindingId()});
    }

    public List<BytecodeNode> getChildNodes() {
        return ImmutableList.of();
    }

    protected String formatOneLine() {
        return this.type.getTypeSignature().toString();
    }

    public BytecodeExpression getValue(BytecodeExpression block, BytecodeExpression position) {
        Class fromJavaElementType = this.type.getJavaType();
        if (fromJavaElementType == Boolean.TYPE) {
            return this.invoke("getBoolean", Boolean.TYPE, new BytecodeExpression[]{block, position});
        }
        if (fromJavaElementType == Long.TYPE) {
            return this.invoke("getLong", Long.TYPE, new BytecodeExpression[]{block, position});
        }
        if (fromJavaElementType == Double.TYPE) {
            return this.invoke("getDouble", Double.TYPE, new BytecodeExpression[]{block, position});
        }
        if (fromJavaElementType == Slice.class) {
            return this.invoke("getSlice", Slice.class, new BytecodeExpression[]{block, position});
        }
        return this.invoke("getObject", Object.class, new BytecodeExpression[]{block, position}).cast(fromJavaElementType);
    }

    public BytecodeExpression writeValue(BytecodeExpression blockBuilder, BytecodeExpression value) {
        Class fromJavaElementType = this.type.getJavaType();
        if (fromJavaElementType == Boolean.TYPE) {
            return this.invoke("writeBoolean", Void.TYPE, new BytecodeExpression[]{blockBuilder, value});
        }
        if (fromJavaElementType == Long.TYPE) {
            return this.invoke("writeLong", Void.TYPE, new BytecodeExpression[]{blockBuilder, value});
        }
        if (fromJavaElementType == Double.TYPE) {
            return this.invoke("writeDouble", Void.TYPE, new BytecodeExpression[]{blockBuilder, value});
        }
        if (fromJavaElementType == Slice.class) {
            return this.invoke("writeSlice", Void.TYPE, new BytecodeExpression[]{blockBuilder, value});
        }
        return this.invoke("writeObject", Void.TYPE, new BytecodeExpression[]{blockBuilder, value.cast(Object.class)});
    }
}

