/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.optimizations.QueryCardinalityUtil;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import java.util.Collections;

public class EliminateEmptyJoins
implements Rule<JoinNode> {
    private static final Pattern<JoinNode> PATTERN = Patterns.join();

    @Override
    public Pattern<JoinNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(JoinNode joinNode, Captures captures, Rule.Context context) {
        if (!SystemSessionProperties.isEmptyJoinOptimization(context.getSession())) {
            return Rule.Result.empty();
        }
        boolean leftChildEmpty = QueryCardinalityUtil.isAtMost(context.getLookup().resolve(joinNode.getLeft()), context.getLookup(), 0L);
        boolean rightChildEmpty = QueryCardinalityUtil.isAtMost(context.getLookup().resolve(joinNode.getRight()), context.getLookup(), 0L);
        if (!leftChildEmpty && !rightChildEmpty || joinNode.getType() != JoinNode.Type.INNER) {
            return Rule.Result.empty();
        }
        return Rule.Result.ofPlanNode((PlanNode)new ValuesNode(joinNode.getId(), joinNode.getOutputVariables(), Collections.emptyList()));
    }
}

