/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.relational;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.predicate.DiscreteValues;
import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.Marker;
import com.facebook.presto.common.predicate.NullableValue;
import com.facebook.presto.common.predicate.Range;
import com.facebook.presto.common.predicate.Ranges;
import com.facebook.presto.common.predicate.SortedRangeSet;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.predicate.Utils;
import com.facebook.presto.common.predicate.ValueSet;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.metadata.CastType;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.OperatorNotFoundException;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.function.FunctionMetadataManager;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.DeterminismEvaluator;
import com.facebook.presto.spi.relation.DomainTranslator;
import com.facebook.presto.spi.relation.ExpressionOptimizer;
import com.facebook.presto.spi.relation.InputReferenceExpression;
import com.facebook.presto.spi.relation.LambdaDefinitionExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.InterpretedFunctionInvoker;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.planner.LiteralEncoder;
import com.facebook.presto.sql.planner.RowExpressionInterpreter;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.relational.RowExpressionDeterminismEvaluator;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;

public final class RowExpressionDomainTranslator
implements DomainTranslator {
    private final FunctionAndTypeManager functionAndTypeManager;
    private final LogicalRowExpressions logicalRowExpressions;
    private final StandardFunctionResolution functionResolution;
    private final Metadata metadata;

    @Inject
    public RowExpressionDomainTranslator(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.functionAndTypeManager = metadata.getFunctionAndTypeManager();
        this.logicalRowExpressions = new LogicalRowExpressions((DeterminismEvaluator)new RowExpressionDeterminismEvaluator(this.functionAndTypeManager), (StandardFunctionResolution)new FunctionResolution(this.functionAndTypeManager), (FunctionMetadataManager)this.functionAndTypeManager);
        this.functionResolution = new FunctionResolution(this.functionAndTypeManager);
    }

    public <T extends RowExpression> RowExpression toPredicate(TupleDomain<T> tupleDomain) {
        if (tupleDomain.isNone()) {
            return LogicalRowExpressions.FALSE_CONSTANT;
        }
        Map domains = (Map)tupleDomain.getDomains().get();
        return domains.entrySet().stream().map(entry -> this.toPredicate((Domain)entry.getValue(), (RowExpression)entry.getKey())).collect(Collectors.collectingAndThen(ImmutableList.toImmutableList(), arg_0 -> ((LogicalRowExpressions)this.logicalRowExpressions).combineConjuncts(arg_0)));
    }

    public DomainTranslator.ExtractionResult<VariableReferenceExpression> fromPredicate(ConnectorSession session, RowExpression predicate) {
        return this.fromPredicate(session, predicate, BASIC_COLUMN_EXTRACTOR);
    }

    public <T> DomainTranslator.ExtractionResult<T> fromPredicate(ConnectorSession session, RowExpression predicate, DomainTranslator.ColumnExtractor<T> columnExtractor) {
        return (DomainTranslator.ExtractionResult)predicate.accept(new Visitor(this.metadata, session, columnExtractor), (Object)false);
    }

    private RowExpression toPredicate(Domain domain, RowExpression reference) {
        if (domain.getValues().isNone()) {
            return domain.isNullAllowed() ? RowExpressionDomainTranslator.isNull(reference) : LogicalRowExpressions.FALSE_CONSTANT;
        }
        if (domain.getValues().isAll()) {
            return domain.isNullAllowed() ? LogicalRowExpressions.TRUE_CONSTANT : RowExpressionDomainTranslator.not(this.functionResolution, RowExpressionDomainTranslator.isNull(reference));
        }
        ArrayList<RowExpression> disjuncts = new ArrayList<RowExpression>();
        disjuncts.addAll((Collection)domain.getValues().getValuesProcessor().transform(ranges -> this.extractDisjuncts(domain.getType(), (Ranges)ranges, reference), discreteValues -> this.extractDisjuncts(domain.getType(), (DiscreteValues)discreteValues, reference), allOrNone -> {
            throw new IllegalStateException("Case should not be reachable");
        }));
        if (domain.isNullAllowed()) {
            disjuncts.add(RowExpressionDomainTranslator.isNull(reference));
        }
        return this.logicalRowExpressions.combineDisjunctsWithDefault(disjuncts, (RowExpression)LogicalRowExpressions.TRUE_CONSTANT);
    }

    private RowExpression processRange(Type type, Range range, RowExpression reference) {
        if (range.isAll()) {
            return LogicalRowExpressions.TRUE_CONSTANT;
        }
        if (RowExpressionDomainTranslator.isBetween(range)) {
            return Expressions.call(OperatorType.BETWEEN.name(), this.functionAndTypeManager.resolveOperator(OperatorType.BETWEEN, TypeSignatureProvider.fromTypes(reference.getType(), type, type)), (Type)BooleanType.BOOLEAN, reference, LiteralEncoder.toRowExpression(range.getLow().getValue(), type), LiteralEncoder.toRowExpression(range.getHigh().getValue(), type));
        }
        ArrayList<RowExpression> rangeConjuncts = new ArrayList<RowExpression>();
        if (!range.getLow().isLowerUnbounded()) {
            switch (range.getLow().getBound()) {
                case ABOVE: {
                    rangeConjuncts.add(this.greaterThan(reference, LiteralEncoder.toRowExpression(range.getLow().getValue(), type)));
                    break;
                }
                case EXACTLY: {
                    rangeConjuncts.add(this.greaterThanOrEqual(reference, LiteralEncoder.toRowExpression(range.getLow().getValue(), type)));
                    break;
                }
                case BELOW: {
                    throw new IllegalStateException("Low Marker should never use BELOW bound: " + range);
                }
                default: {
                    throw new AssertionError((Object)("Unhandled bound: " + range.getLow().getBound()));
                }
            }
        }
        if (!range.getHigh().isUpperUnbounded()) {
            switch (range.getHigh().getBound()) {
                case ABOVE: {
                    throw new IllegalStateException("High Marker should never use ABOVE bound: " + range);
                }
                case EXACTLY: {
                    rangeConjuncts.add(this.lessThanOrEqual(reference, LiteralEncoder.toRowExpression(range.getHigh().getValue(), type)));
                    break;
                }
                case BELOW: {
                    rangeConjuncts.add(this.lessThan(reference, LiteralEncoder.toRowExpression(range.getHigh().getValue(), type)));
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unhandled bound: " + range.getHigh().getBound()));
                }
            }
        }
        Preconditions.checkState((!rangeConjuncts.isEmpty() ? 1 : 0) != 0);
        return this.logicalRowExpressions.combineConjuncts(rangeConjuncts);
    }

    private RowExpression combineRangeWithExcludedPoints(Type type, RowExpression reference, Range range, List<RowExpression> excludedPoints) {
        if (excludedPoints.isEmpty()) {
            return this.processRange(type, range, reference);
        }
        RowExpression excludedPointsExpression = RowExpressionDomainTranslator.not(this.functionResolution, this.in(reference, excludedPoints));
        if (excludedPoints.size() == 1) {
            excludedPointsExpression = this.notEqual(reference, (RowExpression)Iterables.getOnlyElement(excludedPoints));
        }
        return this.logicalRowExpressions.combineConjuncts(new RowExpression[]{this.processRange(type, range, reference), excludedPointsExpression});
    }

    private List<RowExpression> extractDisjuncts(Type type, Ranges ranges, RowExpression reference) {
        ArrayList<RowExpression> disjuncts = new ArrayList<RowExpression>();
        ArrayList<RowExpression> singleValues = new ArrayList<RowExpression>();
        List orderedRanges = ranges.getOrderedRanges();
        SortedRangeSet sortedRangeSet = SortedRangeSet.copyOf((Type)type, (List)orderedRanges);
        SortedRangeSet complement = sortedRangeSet.complement();
        List singleValueExclusionsList = complement.getOrderedRanges().stream().filter(Range::isSingleValue).collect(Collectors.toList());
        List originalUnionSingleValues = SortedRangeSet.copyOf((Type)type, singleValueExclusionsList).union((ValueSet)sortedRangeSet).getOrderedRanges();
        PeekingIterator singleValueExclusions = Iterators.peekingIterator(singleValueExclusionsList.iterator());
        for (Range range : originalUnionSingleValues) {
            if (range.isSingleValue()) {
                singleValues.add(LiteralEncoder.toRowExpression(range.getSingleValue(), type));
                continue;
            }
            ArrayList<RowExpression> singleValuesInRange = new ArrayList<RowExpression>();
            while (singleValueExclusions.hasNext() && range.contains((Range)singleValueExclusions.peek())) {
                singleValuesInRange.add(LiteralEncoder.toRowExpression(((Range)singleValueExclusions.next()).getSingleValue(), type));
            }
            if (!singleValuesInRange.isEmpty()) {
                disjuncts.add(this.combineRangeWithExcludedPoints(type, reference, range, singleValuesInRange));
                continue;
            }
            disjuncts.add(this.processRange(type, range, reference));
        }
        if (singleValues.size() == 1) {
            disjuncts.add(this.equal(reference, (RowExpression)Iterables.getOnlyElement(singleValues)));
        } else if (singleValues.size() > 1) {
            disjuncts.add(this.in(reference, singleValues));
        }
        return disjuncts;
    }

    private List<RowExpression> extractDisjuncts(Type type, DiscreteValues discreteValues, RowExpression reference) {
        List<RowExpression> values = discreteValues.getValues().stream().map(object -> LiteralEncoder.toRowExpression(object, type)).collect(Collectors.toList());
        Preconditions.checkState((!values.isEmpty() ? 1 : 0) != 0);
        RowExpression predicate = values.size() == 1 ? this.equal(reference, (RowExpression)Iterables.getOnlyElement(values)) : this.in(reference, values);
        if (!discreteValues.isWhiteList()) {
            predicate = RowExpressionDomainTranslator.not(this.functionResolution, predicate);
        }
        return ImmutableList.of((Object)predicate);
    }

    private static boolean isBetween(Range range) {
        return !range.getLow().isLowerUnbounded() && range.getLow().getBound() == Marker.Bound.EXACTLY && !range.getHigh().isUpperUnbounded() && range.getHigh().getBound() == Marker.Bound.EXACTLY;
    }

    private static RowExpression isNull(RowExpression expression) {
        return new SpecialFormExpression(SpecialFormExpression.Form.IS_NULL, (Type)BooleanType.BOOLEAN, new RowExpression[]{expression});
    }

    private static RowExpression not(StandardFunctionResolution resolution, RowExpression expression) {
        return Expressions.call("not", resolution.notFunction(), expression.getType(), expression);
    }

    private RowExpression in(RowExpression value, List<RowExpression> inList) {
        return new SpecialFormExpression(SpecialFormExpression.Form.IN, (Type)BooleanType.BOOLEAN, (List)ImmutableList.builder().add((Object)value).addAll(inList).build());
    }

    private RowExpression binaryOperator(OperatorType operatorType, RowExpression left, RowExpression right) {
        return Expressions.call(operatorType.name(), this.functionAndTypeManager.resolveOperator(operatorType, TypeSignatureProvider.fromTypes(left.getType(), right.getType())), (Type)BooleanType.BOOLEAN, left, right);
    }

    private RowExpression greaterThan(RowExpression left, RowExpression right) {
        return this.binaryOperator(OperatorType.GREATER_THAN, left, right);
    }

    private RowExpression lessThan(RowExpression left, RowExpression right) {
        return this.binaryOperator(OperatorType.LESS_THAN, left, right);
    }

    private RowExpression greaterThanOrEqual(RowExpression left, RowExpression right) {
        return this.binaryOperator(OperatorType.GREATER_THAN_OR_EQUAL, left, right);
    }

    private RowExpression lessThanOrEqual(RowExpression left, RowExpression right) {
        return this.binaryOperator(OperatorType.LESS_THAN_OR_EQUAL, left, right);
    }

    private RowExpression equal(RowExpression left, RowExpression right) {
        return this.binaryOperator(OperatorType.EQUAL, left, right);
    }

    private RowExpression notEqual(RowExpression left, RowExpression right) {
        return this.binaryOperator(OperatorType.NOT_EQUAL, left, right);
    }

    private static class NormalizedSimpleComparison {
        private final RowExpression expression;
        private final OperatorType comparisonOperator;
        private final NullableValue value;

        public NormalizedSimpleComparison(RowExpression expression, OperatorType comparisonOperator, NullableValue value) {
            this.expression = Objects.requireNonNull(expression, "expression is null");
            this.comparisonOperator = Objects.requireNonNull(comparisonOperator, "comparisonOperator is null");
            this.value = Objects.requireNonNull(value, "value is null");
        }

        public RowExpression getExpression() {
            return this.expression;
        }

        public OperatorType getComparisonOperator() {
            return this.comparisonOperator;
        }

        public NullableValue getValue() {
            return this.value;
        }
    }

    private static class Visitor<T>
    implements RowExpressionVisitor<DomainTranslator.ExtractionResult<T>, Boolean> {
        private final InterpretedFunctionInvoker functionInvoker;
        private final Metadata metadata;
        private final ConnectorSession session;
        private final FunctionAndTypeManager functionAndTypeManager;
        private final LogicalRowExpressions logicalRowExpressions;
        private final DeterminismEvaluator determinismEvaluator;
        private final StandardFunctionResolution resolution;
        private final DomainTranslator.ColumnExtractor<T> columnExtractor;

        private Visitor(Metadata metadata, ConnectorSession session, DomainTranslator.ColumnExtractor<T> columnExtractor) {
            this.functionInvoker = new InterpretedFunctionInvoker(metadata.getFunctionAndTypeManager());
            this.metadata = metadata;
            this.session = session;
            this.functionAndTypeManager = metadata.getFunctionAndTypeManager();
            this.logicalRowExpressions = new LogicalRowExpressions((DeterminismEvaluator)new RowExpressionDeterminismEvaluator(this.functionAndTypeManager), (StandardFunctionResolution)new FunctionResolution(this.functionAndTypeManager), (FunctionMetadataManager)this.functionAndTypeManager);
            this.determinismEvaluator = new RowExpressionDeterminismEvaluator(this.functionAndTypeManager);
            this.resolution = new FunctionResolution(this.functionAndTypeManager);
            this.columnExtractor = Objects.requireNonNull(columnExtractor, "columnExtractor is null");
        }

        public DomainTranslator.ExtractionResult<T> visitSpecialForm(SpecialFormExpression node, Boolean complement) {
            switch (node.getForm()) {
                case AND: 
                case OR: {
                    return this.visitBinaryLogic(node, complement);
                }
                case IN: {
                    RowExpression target = (RowExpression)node.getArguments().get(0);
                    List values = node.getArguments().subList(1, node.getArguments().size());
                    Preconditions.checkState((!values.isEmpty() ? 1 : 0) != 0, (Object)"values should never be empty");
                    ImmutableList.Builder disjuncts = ImmutableList.builder();
                    for (RowExpression expression : values) {
                        disjuncts.add((Object)Expressions.call(OperatorType.EQUAL.name(), this.functionAndTypeManager.resolveOperator(OperatorType.EQUAL, TypeSignatureProvider.fromTypes(target.getType(), expression.getType())), (Type)BooleanType.BOOLEAN, target, expression));
                    }
                    DomainTranslator.ExtractionResult extractionResult = (DomainTranslator.ExtractionResult)LogicalRowExpressions.or((Collection)disjuncts.build()).accept((RowExpressionVisitor)this, (Object)complement);
                    if (extractionResult.getTupleDomain().isAll()) {
                        SpecialFormExpression originalPredicate = node;
                        if (complement.booleanValue()) {
                            originalPredicate = RowExpressionDomainTranslator.not(this.resolution, (RowExpression)originalPredicate);
                        }
                        return new DomainTranslator.ExtractionResult(extractionResult.getTupleDomain(), (RowExpression)originalPredicate);
                    }
                    return extractionResult;
                }
                case IS_NULL: {
                    RowExpression value = (RowExpression)node.getArguments().get(0);
                    Domain domain = Visitor.complementIfNecessary(Domain.onlyNull((Type)value.getType()), (boolean)complement);
                    Optional column = this.columnExtractor.extract(value, domain);
                    if (!column.isPresent()) {
                        return this.visitRowExpression((RowExpression)node, complement);
                    }
                    return new DomainTranslator.ExtractionResult(TupleDomain.withColumnDomains((Map)ImmutableMap.of(column.get(), (Object)domain)), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT);
                }
            }
            return this.visitRowExpression((RowExpression)node, complement);
        }

        public DomainTranslator.ExtractionResult<T> visitConstant(ConstantExpression node, Boolean complement) {
            if (node.getValue() == null) {
                return new DomainTranslator.ExtractionResult(TupleDomain.none(), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT);
            }
            if (node.getType() == BooleanType.BOOLEAN) {
                boolean value = complement.booleanValue() != ((Boolean)node.getValue()).booleanValue();
                return new DomainTranslator.ExtractionResult(value ? TupleDomain.all() : TupleDomain.none(), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT);
            }
            throw new IllegalStateException("Can not extract predicate from constant type: " + node.getType());
        }

        public DomainTranslator.ExtractionResult<T> visitLambda(LambdaDefinitionExpression node, Boolean complement) {
            return this.visitRowExpression((RowExpression)node, complement);
        }

        public DomainTranslator.ExtractionResult<T> visitVariableReference(VariableReferenceExpression node, Boolean complement) {
            if (node.getType() == BooleanType.BOOLEAN) {
                Domain domain = Visitor.createComparisonDomain(OperatorType.EQUAL, (Type)BooleanType.BOOLEAN, complement == false, Boolean.FALSE);
                Optional column = this.columnExtractor.extract((RowExpression)node, domain);
                return new DomainTranslator.ExtractionResult(TupleDomain.withColumnDomains((Map)ImmutableMap.of(column.get(), (Object)domain)), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT);
            }
            return this.visitRowExpression((RowExpression)node, complement);
        }

        public DomainTranslator.ExtractionResult<T> visitCall(CallExpression node, Boolean complement) {
            if (node.getFunctionHandle().equals(this.resolution.notFunction())) {
                return (DomainTranslator.ExtractionResult)((RowExpression)node.getArguments().get(0)).accept((RowExpressionVisitor)this, (Object)(complement == false ? 1 : 0));
            }
            if (this.resolution.isBetweenFunction(node.getFunctionHandle())) {
                return (DomainTranslator.ExtractionResult)LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.binaryOperator(OperatorType.GREATER_THAN_OR_EQUAL, (RowExpression)node.getArguments().get(0), (RowExpression)node.getArguments().get(1)), this.binaryOperator(OperatorType.LESS_THAN_OR_EQUAL, (RowExpression)node.getArguments().get(0), (RowExpression)node.getArguments().get(2))}).accept((RowExpressionVisitor)this, (Object)complement);
            }
            FunctionMetadata functionMetadata = this.metadata.getFunctionAndTypeManager().getFunctionMetadata(node.getFunctionHandle());
            if (functionMetadata.getOperatorType().map(OperatorType::isComparisonOperator).orElse(false).booleanValue()) {
                Optional<NormalizedSimpleComparison> optionalNormalized = this.toNormalizedSimpleComparison((OperatorType)functionMetadata.getOperatorType().get(), (RowExpression)node.getArguments().get(0), (RowExpression)node.getArguments().get(1));
                if (!optionalNormalized.isPresent()) {
                    return this.visitRowExpression((RowExpression)node, complement);
                }
                NormalizedSimpleComparison normalized = optionalNormalized.get();
                RowExpression expression = normalized.getExpression();
                NullableValue value = normalized.getValue();
                Domain domain = Visitor.createComparisonDomain(normalized.getComparisonOperator(), value.getType(), value.getValue(), complement);
                Optional column = this.columnExtractor.extract(expression, domain);
                if (column.isPresent()) {
                    if (domain.isNone()) {
                        return new DomainTranslator.ExtractionResult(TupleDomain.none(), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT);
                    }
                    return new DomainTranslator.ExtractionResult(TupleDomain.withColumnDomains((Map)ImmutableMap.of(column.get(), (Object)domain)), (RowExpression)LogicalRowExpressions.TRUE_CONSTANT);
                }
                if (expression instanceof CallExpression && this.resolution.isCastFunction(((CallExpression)expression).getFunctionHandle())) {
                    CallExpression castExpression = (CallExpression)expression;
                    if (!this.isImplicitCoercion(castExpression)) {
                        return this.visitRowExpression((RowExpression)node, complement);
                    }
                    CallExpression cast = (CallExpression)expression;
                    Type sourceType = ((RowExpression)cast.getArguments().get(0)).getType();
                    Optional<RowExpression> coercedExpression = this.coerceComparisonWithRounding(sourceType, (RowExpression)cast.getArguments().get(0), normalized.getValue(), normalized.getComparisonOperator());
                    if (coercedExpression.isPresent()) {
                        return (DomainTranslator.ExtractionResult)coercedExpression.get().accept((RowExpressionVisitor)this, (Object)complement);
                    }
                    return this.visitRowExpression((RowExpression)node, complement);
                }
                return this.visitRowExpression((RowExpression)node, complement);
            }
            return this.visitRowExpression((RowExpression)node, complement);
        }

        public DomainTranslator.ExtractionResult<T> visitInputReference(InputReferenceExpression node, Boolean complement) {
            return this.visitRowExpression((RowExpression)node, complement);
        }

        private Optional<RowExpression> coerceComparisonWithRounding(Type expressionType, RowExpression expression, NullableValue nullableValue, OperatorType comparisonOperator) {
            Objects.requireNonNull(nullableValue, "nullableValue is null");
            if (nullableValue.isNull()) {
                return Optional.empty();
            }
            Type valueType = nullableValue.getType();
            Object value = nullableValue.getValue();
            return this.floorValue(valueType, expressionType, value).map(floorValue -> this.rewriteComparisonExpression(expressionType, expression, valueType, value, floorValue, comparisonOperator));
        }

        private RowExpression rewriteComparisonExpression(Type expressionType, RowExpression expression, Type valueType, Object originalValue, Object coercedValue, OperatorType comparisonOperator) {
            int originalComparedToCoerced = this.compareOriginalValueToCoerced(valueType, originalValue, expressionType, coercedValue);
            boolean coercedValueIsEqualToOriginal = originalComparedToCoerced == 0;
            boolean coercedValueIsLessThanOriginal = originalComparedToCoerced > 0;
            boolean coercedValueIsGreaterThanOriginal = originalComparedToCoerced < 0;
            RowExpression coercedLiteral = LiteralEncoder.toRowExpression(coercedValue, expressionType);
            switch (comparisonOperator) {
                case GREATER_THAN_OR_EQUAL: 
                case GREATER_THAN: {
                    if (coercedValueIsGreaterThanOriginal) {
                        return this.binaryOperator(OperatorType.GREATER_THAN_OR_EQUAL, expression, coercedLiteral);
                    }
                    if (coercedValueIsEqualToOriginal) {
                        return this.binaryOperator(comparisonOperator, expression, coercedLiteral);
                    }
                    return this.binaryOperator(OperatorType.GREATER_THAN, expression, coercedLiteral);
                }
                case LESS_THAN_OR_EQUAL: 
                case LESS_THAN: {
                    if (coercedValueIsLessThanOriginal) {
                        return this.binaryOperator(OperatorType.LESS_THAN_OR_EQUAL, expression, coercedLiteral);
                    }
                    if (coercedValueIsEqualToOriginal) {
                        return this.binaryOperator(comparisonOperator, expression, coercedLiteral);
                    }
                    return this.binaryOperator(OperatorType.LESS_THAN, expression, coercedLiteral);
                }
                case EQUAL: {
                    if (coercedValueIsEqualToOriginal) {
                        return this.binaryOperator(OperatorType.EQUAL, expression, coercedLiteral);
                    }
                    return LogicalRowExpressions.and((RowExpression[])new RowExpression[]{this.binaryOperator(OperatorType.EQUAL, expression, coercedLiteral), this.binaryOperator(OperatorType.NOT_EQUAL, expression, coercedLiteral)});
                }
                case NOT_EQUAL: {
                    if (coercedValueIsEqualToOriginal) {
                        return this.binaryOperator(comparisonOperator, expression, coercedLiteral);
                    }
                    return LogicalRowExpressions.or((RowExpression[])new RowExpression[]{this.binaryOperator(OperatorType.EQUAL, expression, coercedLiteral), this.binaryOperator(OperatorType.NOT_EQUAL, expression, coercedLiteral)});
                }
                case IS_DISTINCT_FROM: {
                    if (coercedValueIsEqualToOriginal) {
                        return this.binaryOperator(comparisonOperator, expression, coercedLiteral);
                    }
                    return LogicalRowExpressions.TRUE_CONSTANT;
                }
            }
            throw new IllegalArgumentException("Unhandled operator: " + comparisonOperator);
        }

        private RowExpression binaryOperator(OperatorType operatorType, RowExpression left, RowExpression right) {
            return Expressions.call(operatorType.name(), this.metadata.getFunctionAndTypeManager().resolveOperator(operatorType, TypeSignatureProvider.fromTypes(left.getType(), right.getType())), (Type)BooleanType.BOOLEAN, left, right);
        }

        private Optional<Object> floorValue(Type fromType, Type toType, Object value) {
            return this.getSaturatedFloorCastOperator(fromType, toType).map(operator -> this.functionInvoker.invoke((FunctionHandle)operator, this.session.getSqlFunctionProperties(), value));
        }

        private Optional<FunctionHandle> getSaturatedFloorCastOperator(Type fromType, Type toType) {
            try {
                return Optional.of(this.metadata.getFunctionAndTypeManager().lookupCast(CastType.SATURATED_FLOOR_CAST, fromType.getTypeSignature(), toType.getTypeSignature()));
            }
            catch (OperatorNotFoundException e) {
                return Optional.empty();
            }
        }

        private int compareOriginalValueToCoerced(Type originalValueType, Object originalValue, Type coercedValueType, Object coercedValue) {
            FunctionHandle castToOriginalTypeOperator = this.metadata.getFunctionAndTypeManager().lookupCast(CastType.CAST, coercedValueType.getTypeSignature(), originalValueType.getTypeSignature());
            Object coercedValueInOriginalType = this.functionInvoker.invoke(castToOriginalTypeOperator, this.session.getSqlFunctionProperties(), coercedValue);
            Block originalValueBlock = Utils.nativeValueToBlock((Type)originalValueType, (Object)originalValue);
            Block coercedValueBlock = Utils.nativeValueToBlock((Type)originalValueType, (Object)coercedValueInOriginalType);
            return originalValueType.compareTo(originalValueBlock, 0, coercedValueBlock, 0);
        }

        private boolean isImplicitCoercion(CallExpression cast) {
            Type sourceType = ((RowExpression)cast.getArguments().get(0)).getType();
            Type targetType = cast.getType();
            return this.metadata.getFunctionAndTypeManager().canCoerce(sourceType, targetType);
        }

        private static Domain extractOrderableDomain(OperatorType comparisonOperator, Type type, Object value, boolean complement) {
            Preconditions.checkArgument((value != null ? 1 : 0) != 0);
            switch (comparisonOperator) {
                case EQUAL: {
                    return Domain.create((ValueSet)Visitor.complementIfNecessary(ValueSet.ofRanges((Range)Range.equal((Type)type, (Object)value), (Range[])new Range[0]), complement), (boolean)false);
                }
                case GREATER_THAN: {
                    return Domain.create((ValueSet)Visitor.complementIfNecessary(ValueSet.ofRanges((Range)Range.greaterThan((Type)type, (Object)value), (Range[])new Range[0]), complement), (boolean)false);
                }
                case GREATER_THAN_OR_EQUAL: {
                    return Domain.create((ValueSet)Visitor.complementIfNecessary(ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)type, (Object)value), (Range[])new Range[0]), complement), (boolean)false);
                }
                case LESS_THAN: {
                    return Domain.create((ValueSet)Visitor.complementIfNecessary(ValueSet.ofRanges((Range)Range.lessThan((Type)type, (Object)value), (Range[])new Range[0]), complement), (boolean)false);
                }
                case LESS_THAN_OR_EQUAL: {
                    return Domain.create((ValueSet)Visitor.complementIfNecessary(ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)type, (Object)value), (Range[])new Range[0]), complement), (boolean)false);
                }
                case NOT_EQUAL: {
                    return Domain.create((ValueSet)Visitor.complementIfNecessary(ValueSet.ofRanges((Range)Range.lessThan((Type)type, (Object)value), (Range[])new Range[]{Range.greaterThan((Type)type, (Object)value)}), complement), (boolean)false);
                }
                case IS_DISTINCT_FROM: {
                    return Visitor.complementIfNecessary(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)type, (Object)value), (Range[])new Range[]{Range.greaterThan((Type)type, (Object)value)}), (boolean)true), complement);
                }
            }
            throw new AssertionError((Object)("Unhandled operator: " + comparisonOperator));
        }

        private static Domain extractEquatableDomain(OperatorType comparisonOperator, Type type, Object value, boolean complement) {
            Preconditions.checkArgument((value != null ? 1 : 0) != 0);
            switch (comparisonOperator) {
                case EQUAL: {
                    return Domain.create((ValueSet)Visitor.complementIfNecessary(ValueSet.of((Type)type, (Object)value, (Object[])new Object[0]), complement), (boolean)false);
                }
                case NOT_EQUAL: {
                    return Domain.create((ValueSet)Visitor.complementIfNecessary(ValueSet.of((Type)type, (Object)value, (Object[])new Object[0]).complement(), complement), (boolean)false);
                }
                case IS_DISTINCT_FROM: {
                    return Visitor.complementIfNecessary(Domain.create((ValueSet)ValueSet.of((Type)type, (Object)value, (Object[])new Object[0]).complement(), (boolean)true), complement);
                }
            }
            throw new AssertionError((Object)("Unhandled operator: " + comparisonOperator));
        }

        private Optional<NormalizedSimpleComparison> toNormalizedSimpleComparison(OperatorType operatorType, RowExpression leftExpression, RowExpression rightExpression) {
            NullableValue value;
            OperatorType comparisonOperator;
            RowExpression expression;
            Object right;
            Object left = leftExpression instanceof VariableReferenceExpression ? leftExpression : new RowExpressionInterpreter(leftExpression, this.metadata, this.session, ExpressionOptimizer.Level.OPTIMIZED).optimize();
            if (left instanceof RowExpression == (right = rightExpression instanceof VariableReferenceExpression ? rightExpression : new RowExpressionInterpreter(rightExpression, this.metadata, this.session, ExpressionOptimizer.Level.OPTIMIZED).optimize()) instanceof RowExpression) {
                return Optional.empty();
            }
            if (left instanceof RowExpression) {
                expression = leftExpression;
                comparisonOperator = operatorType;
                value = new NullableValue(rightExpression.getType(), right);
            } else {
                expression = rightExpression;
                comparisonOperator = Visitor.flip(operatorType);
                value = new NullableValue(leftExpression.getType(), left);
            }
            return Optional.of(new NormalizedSimpleComparison(expression, comparisonOperator, value));
        }

        private static Domain createComparisonDomain(OperatorType comparisonOperator, Type type, @Nullable Object value, boolean complement) {
            Domain domain;
            if (value == null) {
                switch (comparisonOperator) {
                    case GREATER_THAN_OR_EQUAL: 
                    case GREATER_THAN: 
                    case LESS_THAN_OR_EQUAL: 
                    case LESS_THAN: 
                    case EQUAL: 
                    case NOT_EQUAL: {
                        return Domain.none((Type)type);
                    }
                    case IS_DISTINCT_FROM: {
                        return Visitor.complementIfNecessary(Domain.notNull((Type)type), complement);
                    }
                }
                throw new AssertionError((Object)("Unhandled operator: " + comparisonOperator));
            }
            if (type.isOrderable()) {
                domain = Visitor.extractOrderableDomain(comparisonOperator, type, value, complement);
            } else if (type.isComparable()) {
                domain = Visitor.extractEquatableDomain(comparisonOperator, type, value, complement);
            } else {
                throw new AssertionError((Object)("Type cannot be used in a comparison expression (should have been caught in analysis): " + type));
            }
            return domain;
        }

        private static OperatorType flip(OperatorType operatorType) {
            switch (operatorType) {
                case EQUAL: {
                    return OperatorType.EQUAL;
                }
                case NOT_EQUAL: {
                    return OperatorType.NOT_EQUAL;
                }
                case LESS_THAN: {
                    return OperatorType.GREATER_THAN;
                }
                case LESS_THAN_OR_EQUAL: {
                    return OperatorType.GREATER_THAN_OR_EQUAL;
                }
                case GREATER_THAN: {
                    return OperatorType.LESS_THAN;
                }
                case GREATER_THAN_OR_EQUAL: {
                    return OperatorType.LESS_THAN_OR_EQUAL;
                }
                case IS_DISTINCT_FROM: {
                    return OperatorType.IS_DISTINCT_FROM;
                }
            }
            throw new IllegalArgumentException("Unsupported comparison: " + operatorType);
        }

        private static ValueSet complementIfNecessary(ValueSet valueSet, boolean complement) {
            return complement ? valueSet.complement() : valueSet;
        }

        private static Domain complementIfNecessary(Domain domain, boolean complement) {
            return complement ? domain.complement() : domain;
        }

        private RowExpression complementIfNecessary(RowExpression expression, boolean complement) {
            return complement ? RowExpressionDomainTranslator.not(this.resolution, expression) : expression;
        }

        private DomainTranslator.ExtractionResult<T> visitRowExpression(RowExpression node, Boolean complement) {
            return new DomainTranslator.ExtractionResult(TupleDomain.all(), this.complementIfNecessary(node, complement));
        }

        private DomainTranslator.ExtractionResult<T> visitBinaryLogic(SpecialFormExpression node, Boolean complement) {
            DomainTranslator.ExtractionResult leftResult = (DomainTranslator.ExtractionResult)((RowExpression)node.getArguments().get(0)).accept((RowExpressionVisitor)this, (Object)complement);
            DomainTranslator.ExtractionResult rightResult = (DomainTranslator.ExtractionResult)((RowExpression)node.getArguments().get(1)).accept((RowExpressionVisitor)this, (Object)complement);
            TupleDomain leftTupleDomain = leftResult.getTupleDomain();
            TupleDomain rightTupleDomain = rightResult.getTupleDomain();
            SpecialFormExpression.Form operator = node.getForm();
            if (complement.booleanValue()) {
                if (operator == SpecialFormExpression.Form.AND) {
                    operator = SpecialFormExpression.Form.OR;
                } else if (operator == SpecialFormExpression.Form.OR) {
                    operator = SpecialFormExpression.Form.AND;
                } else {
                    throw new IllegalStateException("Can not extract predicate from special form: " + node.getForm());
                }
            }
            switch (operator) {
                case AND: {
                    return new DomainTranslator.ExtractionResult(leftTupleDomain.intersect(rightTupleDomain), this.logicalRowExpressions.combineConjuncts(new RowExpression[]{leftResult.getRemainingExpression(), rightResult.getRemainingExpression()}));
                }
                case OR: {
                    TupleDomain columnUnionedTupleDomain = TupleDomain.columnWiseUnion((TupleDomain)leftTupleDomain, (TupleDomain)rightTupleDomain, (TupleDomain[])new TupleDomain[0]);
                    RowExpression remainingExpression = this.complementIfNecessary((RowExpression)node, complement);
                    if (leftResult.getRemainingExpression().equals((Object)rightResult.getRemainingExpression()) && this.determinismEvaluator.isDeterministic(leftResult.getRemainingExpression())) {
                        boolean oneSideIsSuperSet;
                        boolean matchingSingleSymbolDomains = !leftTupleDomain.isNone() && !rightTupleDomain.isNone() && ((Map)leftTupleDomain.getDomains().get()).size() == 1 && ((Map)rightTupleDomain.getDomains().get()).size() == 1 && ((Map)leftTupleDomain.getDomains().get()).keySet().equals(((Map)rightTupleDomain.getDomains().get()).keySet());
                        boolean bl = oneSideIsSuperSet = leftTupleDomain.contains(rightTupleDomain) || rightTupleDomain.contains(leftTupleDomain);
                        if (matchingSingleSymbolDomains || oneSideIsSuperSet) {
                            remainingExpression = leftResult.getRemainingExpression();
                        }
                    }
                    return new DomainTranslator.ExtractionResult(columnUnionedTupleDomain, remainingExpression);
                }
            }
            throw new IllegalStateException("Can not extract predicate from special form: " + node.getForm());
        }
    }
}

