/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.util.HeapDumper;
import io.airlift.units.DataSize;
import java.util.Optional;

public class ExceededMemoryLimitException
extends PrestoException {
    public static ExceededMemoryLimitException exceededGlobalUserLimit(DataSize maxMemory) {
        return new ExceededMemoryLimitException(StandardErrorCode.EXCEEDED_GLOBAL_MEMORY_LIMIT, String.format("Query exceeded distributed user memory limit of %s", maxMemory));
    }

    public static ExceededMemoryLimitException exceededGlobalTotalLimit(DataSize maxMemory, String limitSource) {
        return new ExceededMemoryLimitException(StandardErrorCode.EXCEEDED_GLOBAL_MEMORY_LIMIT, String.format("Query exceeded distributed total memory limit of %s defined at the %s", maxMemory, limitSource));
    }

    public static ExceededMemoryLimitException exceededLocalUserMemoryLimit(DataSize maxMemory, String additionalFailureInfo, boolean heapDumpOnExceededMemoryLimitEnabled, Optional<String> heapDumpFilePath) {
        ExceededMemoryLimitException.performHeapDumpIfEnabled(heapDumpOnExceededMemoryLimitEnabled, heapDumpFilePath);
        return new ExceededMemoryLimitException(StandardErrorCode.EXCEEDED_LOCAL_MEMORY_LIMIT, String.format("Query exceeded per-node user memory limit of %s [%s]", maxMemory, additionalFailureInfo));
    }

    public static ExceededMemoryLimitException exceededLocalBroadcastMemoryLimit(DataSize maxMemory, String additionalFailureInfo) {
        return new ExceededMemoryLimitException(StandardErrorCode.EXCEEDED_LOCAL_BROADCAST_JOIN_MEMORY_LIMIT, String.format("Query exceeded per-node broadcast memory limit of %s [%s]", maxMemory, additionalFailureInfo));
    }

    public static ExceededMemoryLimitException exceededLocalTotalMemoryLimit(DataSize maxMemory, String additionalFailureInfo, boolean heapDumpOnExceededMemoryLimitEnabled, Optional<String> heapDumpFilePath) {
        ExceededMemoryLimitException.performHeapDumpIfEnabled(heapDumpOnExceededMemoryLimitEnabled, heapDumpFilePath);
        return new ExceededMemoryLimitException(StandardErrorCode.EXCEEDED_LOCAL_MEMORY_LIMIT, String.format("Query exceeded per-node total memory limit of %s [%s]", maxMemory, additionalFailureInfo));
    }

    public static ExceededMemoryLimitException exceededLocalRevocableMemoryLimit(DataSize maxMemory, String additionalFailureInfo, boolean heapDumpOnExceededMemoryLimitEnabled, Optional<String> heapDumpFilePath) {
        ExceededMemoryLimitException.performHeapDumpIfEnabled(heapDumpOnExceededMemoryLimitEnabled, heapDumpFilePath);
        return new ExceededMemoryLimitException(StandardErrorCode.EXCEEDED_REVOCABLE_MEMORY_LIMIT, String.format("Query exceeded per-node revocable memory limit of %s [%s]", maxMemory, additionalFailureInfo));
    }

    private static void performHeapDumpIfEnabled(boolean heapDumpOnExceededMemoryLimitEnabled, Optional<String> heapDumpFilePath) {
        if (heapDumpOnExceededMemoryLimitEnabled && heapDumpFilePath.isPresent()) {
            HeapDumper.dumpHeap(heapDumpFilePath.get());
        }
    }

    private ExceededMemoryLimitException(StandardErrorCode errorCode, String message) {
        super((ErrorCodeSupplier)errorCode, message);
    }
}

