/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.cost.HistoryBasedPlanStatisticsCalculator;
import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.statistics.EmptyPlanStatisticsProvider;
import com.facebook.presto.spi.statistics.ExternalPlanStatisticsProvider;
import com.google.inject.Inject;
import java.util.Objects;

public class HistoryBasedPlanStatisticsManager {
    private ExternalPlanStatisticsProvider externalPlanStatisticsProvider = EmptyPlanStatisticsProvider.getInstance();
    private final Metadata metadata;
    private boolean externalProviderAdded;

    @Inject
    public HistoryBasedPlanStatisticsManager(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.externalProviderAdded = false;
    }

    public void addExternalPlanStatisticsProviderFactory(ExternalPlanStatisticsProvider externalPlanStatisticsProvider) {
        if (this.externalProviderAdded) {
            throw new IllegalStateException("externalPlanStatisticsProviderFactory can only be set once");
        }
        this.externalPlanStatisticsProvider = externalPlanStatisticsProvider;
        this.externalProviderAdded = true;
    }

    public HistoryBasedPlanStatisticsCalculator getHistoryBasedPlanStatisticsCalculator(StatsCalculator delegate) {
        return new HistoryBasedPlanStatisticsCalculator(() -> this.externalPlanStatisticsProvider, this.metadata, delegate);
    }
}

