/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.execution.QueryExecution;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.memory.VersionedMemoryPoolId;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.resourceGroups.ResourceGroupQueryLimits;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

public abstract class DataDefinitionExecution<T extends Statement>
implements QueryExecution {
    protected final T statement;
    protected final TransactionManager transactionManager;
    protected final Metadata metadata;
    protected final AccessControl accessControl;
    protected final QueryStateMachine stateMachine;
    protected final List<Expression> parameters;
    private final String slug;
    private final int retryCount;
    private final AtomicReference<Optional<ResourceGroupQueryLimits>> resourceGroupQueryLimits = new AtomicReference(Optional.empty());

    protected DataDefinitionExecution(T statement, String slug, int retryCount, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        this.statement = (Statement)Objects.requireNonNull(statement, "statement is null");
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.stateMachine = Objects.requireNonNull(stateMachine, "stateMachine is null");
        this.parameters = parameters;
        this.slug = Objects.requireNonNull(slug, "slug is null");
        this.retryCount = retryCount;
    }

    @Override
    public String getSlug() {
        return this.slug;
    }

    @Override
    public int getRetryCount() {
        return this.retryCount;
    }

    @Override
    public VersionedMemoryPoolId getMemoryPool() {
        return this.stateMachine.getMemoryPool();
    }

    @Override
    public void setMemoryPool(VersionedMemoryPoolId poolId) {
        this.stateMachine.setMemoryPool(poolId);
    }

    @Override
    public Session getSession() {
        return this.stateMachine.getSession();
    }

    @Override
    public DataSize getUserMemoryReservation() {
        return new DataSize(0.0, DataSize.Unit.BYTE);
    }

    @Override
    public DataSize getTotalMemoryReservation() {
        return new DataSize(0.0, DataSize.Unit.BYTE);
    }

    @Override
    public DateTime getCreateTime() {
        return this.stateMachine.getCreateTime();
    }

    @Override
    public Optional<DateTime> getExecutionStartTime() {
        return this.stateMachine.getExecutionStartTime();
    }

    @Override
    public DateTime getLastHeartbeat() {
        return this.stateMachine.getLastHeartbeat();
    }

    @Override
    public Optional<DateTime> getEndTime() {
        return this.stateMachine.getEndTime();
    }

    @Override
    public Duration getTotalCpuTime() {
        return new Duration(0.0, TimeUnit.NANOSECONDS);
    }

    @Override
    public DataSize getRawInputDataSize() {
        return DataSize.succinctBytes((long)0L);
    }

    @Override
    public long getOutputPositions() {
        return 0L;
    }

    @Override
    public DataSize getOutputDataSize() {
        return DataSize.succinctBytes((long)0L);
    }

    @Override
    public Optional<ResourceGroupQueryLimits> getResourceGroupQueryLimits() {
        return this.resourceGroupQueryLimits.get();
    }

    @Override
    public void setResourceGroupQueryLimits(ResourceGroupQueryLimits resourceGroupQueryLimits) {
        if (!this.resourceGroupQueryLimits.compareAndSet(Optional.empty(), Optional.of(Objects.requireNonNull(resourceGroupQueryLimits, "resourceGroupQueryLimits is null")))) {
            throw new IllegalStateException("Cannot set resourceGroupQueryLimits more than once");
        }
    }

    @Override
    public BasicQueryInfo getBasicQueryInfo() {
        return this.stateMachine.getFinalQueryInfo().map(BasicQueryInfo::new).orElseGet(() -> this.stateMachine.getBasicQueryInfo(Optional.empty()));
    }

    @Override
    public int getRunningTaskCount() {
        return this.stateMachine.getCurrentRunningTaskCount();
    }

    @Override
    public void start() {
        try {
            if (!this.stateMachine.transitionToRunning()) {
                return;
            }
            ListenableFuture<?> future = this.executeTask();
            Futures.addCallback(future, (FutureCallback)new FutureCallback<Object>(){

                public void onSuccess(@Nullable Object result) {
                    DataDefinitionExecution.this.stateMachine.transitionToFinishing();
                }

                public void onFailure(Throwable throwable) {
                    DataDefinitionExecution.this.fail(throwable);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }
        catch (Throwable e) {
            this.fail(e);
            Throwables.throwIfInstanceOf((Throwable)e, Error.class);
        }
    }

    @Override
    public void addOutputInfoListener(Consumer<QueryExecution.QueryOutputInfo> listener) {
    }

    @Override
    public ListenableFuture<QueryState> getStateChange(QueryState currentState) {
        return this.stateMachine.getStateChange(currentState);
    }

    @Override
    public void addStateChangeListener(StateMachine.StateChangeListener<QueryState> stateChangeListener) {
        this.stateMachine.addStateChangeListener(stateChangeListener);
    }

    @Override
    public void addFinalQueryInfoListener(StateMachine.StateChangeListener<QueryInfo> stateChangeListener) {
        this.stateMachine.addQueryInfoStateChangeListener(stateChangeListener);
    }

    @Override
    public void fail(Throwable cause) {
        this.stateMachine.transitionToFailed(cause);
        this.stateMachine.updateQueryInfo(Optional.empty());
    }

    @Override
    public boolean isDone() {
        return this.getState().isDone();
    }

    @Override
    public void cancelQuery() {
        this.stateMachine.transitionToCanceled();
    }

    @Override
    public void cancelStage(StageId stageId) {
    }

    @Override
    public void recordHeartbeat() {
        this.stateMachine.recordHeartbeat();
    }

    @Override
    public void pruneInfo() {
    }

    @Override
    public QueryId getQueryId() {
        return this.stateMachine.getQueryId();
    }

    @Override
    public QueryInfo getQueryInfo() {
        return this.stateMachine.getFinalQueryInfo().orElseGet(() -> this.stateMachine.updateQueryInfo(Optional.empty()));
    }

    @Override
    public Plan getQueryPlan() {
        throw new UnsupportedOperationException();
    }

    @Override
    public QueryState getState() {
        return this.stateMachine.getQueryState();
    }

    public List<Expression> getParameters() {
        return this.parameters;
    }

    protected abstract ListenableFuture<?> executeTask();
}

