/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.warnings;

import com.facebook.presto.execution.warnings.WarningCollectorConfig;
import com.facebook.presto.execution.warnings.WarningHandlingLevel;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.PrestoWarning;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.StandardWarningCode;
import com.facebook.presto.spi.WarningCode;
import com.facebook.presto.spi.WarningCollector;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class DefaultWarningCollector
implements WarningCollector {
    @GuardedBy(value="this")
    private final Multimap<WarningCode, PrestoWarning> warnings = LinkedHashMultimap.create();
    private final WarningCollectorConfig config;
    private final WarningHandlingLevel warningHandlingLevel;

    public DefaultWarningCollector(WarningCollectorConfig config, WarningHandlingLevel warningHandlingLevel) {
        this.config = Objects.requireNonNull(config, "config is null");
        this.warningHandlingLevel = warningHandlingLevel;
    }

    public synchronized void add(PrestoWarning warning) {
        Objects.requireNonNull(warning, "warning is null");
        switch (this.warningHandlingLevel) {
            case SUPPRESS: {
                break;
            }
            case NORMAL: {
                this.addWarningIfNumWarningsLessThanConfig(warning);
                break;
            }
            case AS_ERROR: {
                if (warning.getWarningCode() == StandardWarningCode.PARSER_WARNING.toWarningCode()) {
                    this.addWarningIfNumWarningsLessThanConfig(warning);
                    break;
                }
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.WARNING_AS_ERROR, warning.toString());
            }
        }
    }

    public synchronized List<PrestoWarning> getWarnings() {
        return ImmutableList.copyOf((Collection)this.warnings.values());
    }

    private synchronized void addWarningIfNumWarningsLessThanConfig(PrestoWarning warning) {
        if (this.warnings.size() < this.config.getMaxWarnings()) {
            this.warnings.put((Object)warning.getWarningCode(), (Object)warning);
        }
    }

    public synchronized boolean hasWarnings() {
        return !this.warnings.isEmpty();
    }
}

