/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.exchange;

import com.facebook.presto.common.Page;
import com.facebook.presto.operator.HashGenerator;
import com.facebook.presto.operator.PartitionFunction;
import com.google.common.base.Preconditions;
import io.airlift.slice.XxHash64;

public class LocalPartitionGenerator
implements PartitionFunction {
    private final HashGenerator hashGenerator;
    private final int partitionCount;
    private final int hashMask;

    public LocalPartitionGenerator(HashGenerator hashGenerator, int partitionCount) {
        this.hashGenerator = hashGenerator;
        Preconditions.checkArgument((Integer.bitCount(partitionCount) == 1 ? 1 : 0) != 0, (Object)"partitionCount must be a power of 2");
        this.partitionCount = partitionCount;
        this.hashMask = partitionCount - 1;
    }

    @Override
    public int getPartitionCount() {
        return this.partitionCount;
    }

    @Override
    public int getPartition(Page page, int position) {
        long rawHash = this.getRawHash(page, position);
        return LocalPartitionGenerator.processRawHash(rawHash) & this.hashMask;
    }

    public long getRawHash(Page page, int position) {
        return this.hashGenerator.hashPosition(position, page);
    }

    public int getPartition(long rawHash) {
        return LocalPartitionGenerator.processRawHash(rawHash) & this.hashMask;
    }

    private static int processRawHash(long rawHash) {
        return (int)XxHash64.hash((long)Long.reverse(rawHash));
    }
}

