/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.scalar.BlockToBooleanFunction;
import com.facebook.presto.operator.scalar.BooleanToBooleanFunction;
import com.facebook.presto.operator.scalar.DoubleToBooleanFunction;
import com.facebook.presto.operator.scalar.LongToBooleanFunction;
import com.facebook.presto.operator.scalar.SliceToBooleanFunction;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.spi.function.TypeParameterSpecialization;
import io.airlift.slice.Slice;

@Description(value="Returns true if all elements of the array match the given predicate")
@ScalarFunction(value="all_match")
public final class ArrayAllMatchFunction {
    private ArrayAllMatchFunction() {
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=Block.class)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean allMatchBlock(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="function(T, boolean)") BlockToBooleanFunction function) {
        boolean hasNullResult = false;
        for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
            Boolean match;
            Block element = null;
            if (!arrayBlock.isNull(i)) {
                element = (Block)elementType.getObject(arrayBlock, i);
            }
            if (Boolean.FALSE.equals(match = function.apply(element))) {
                return false;
            }
            if (match != null) continue;
            hasNullResult = true;
        }
        if (hasNullResult) {
            return null;
        }
        return true;
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=Slice.class)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean allMatchSlice(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="function(T, boolean)") SliceToBooleanFunction function) {
        boolean hasNullResult = false;
        int positionCount = arrayBlock.getPositionCount();
        for (int i = 0; i < positionCount; ++i) {
            Boolean match;
            Slice element = null;
            if (!arrayBlock.isNull(i)) {
                element = elementType.getSlice(arrayBlock, i);
            }
            if (Boolean.FALSE.equals(match = function.apply(element))) {
                return false;
            }
            if (match != null) continue;
            hasNullResult = true;
        }
        if (hasNullResult) {
            return null;
        }
        return true;
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=long.class)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean allMatchLong(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="function(T, boolean)") LongToBooleanFunction function) {
        boolean hasNullResult = false;
        int positionCount = arrayBlock.getPositionCount();
        for (int i = 0; i < positionCount; ++i) {
            Boolean match;
            Long element = null;
            if (!arrayBlock.isNull(i)) {
                element = elementType.getLong(arrayBlock, i);
            }
            if (Boolean.FALSE.equals(match = function.apply(element))) {
                return false;
            }
            if (match != null) continue;
            hasNullResult = true;
        }
        if (hasNullResult) {
            return null;
        }
        return true;
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=double.class)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean allMatchDouble(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="function(T, boolean)") DoubleToBooleanFunction function) {
        boolean hasNullResult = false;
        int positionCount = arrayBlock.getPositionCount();
        for (int i = 0; i < positionCount; ++i) {
            Boolean match;
            Double element = null;
            if (!arrayBlock.isNull(i)) {
                element = elementType.getDouble(arrayBlock, i);
            }
            if (Boolean.FALSE.equals(match = function.apply(element))) {
                return false;
            }
            if (match != null) continue;
            hasNullResult = true;
        }
        if (hasNullResult) {
            return null;
        }
        return true;
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=boolean.class)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean allMatchBoolean(@TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="function(T, boolean)") BooleanToBooleanFunction function) {
        boolean hasNullResult = false;
        int positionCount = arrayBlock.getPositionCount();
        for (int i = 0; i < positionCount; ++i) {
            Boolean match;
            Boolean element = null;
            if (!arrayBlock.isNull(i)) {
                element = elementType.getBoolean(arrayBlock, i);
            }
            if (Boolean.FALSE.equals(match = function.apply(element))) {
                return false;
            }
            if (match != null) continue;
            hasNullResult = true;
        }
        if (hasNullResult) {
            return null;
        }
        return true;
    }
}

