/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeUtils;
import com.facebook.presto.operator.scalar.CombineHashFunction;
import com.facebook.presto.spi.function.OperatorDependency;
import com.facebook.presto.spi.function.ScalarOperator;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.spi.function.TypeParameterSpecialization;
import com.facebook.presto.util.Failures;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;

@ScalarOperator(value=OperatorType.HASH_CODE)
public final class ArrayHashCodeOperator {
    private ArrayHashCodeOperator() {
    }

    @TypeParameter(value="T")
    @SqlType(value="bigint")
    public static long hash(@OperatorDependency(operator=OperatorType.HASH_CODE, argumentTypes={"T"}) MethodHandle hashFunction, @TypeParameter(value="T") Type type, @SqlType(value="array(T)") Block block) {
        try {
            long hash = 0L;
            for (int i = 0; i < block.getPositionCount(); ++i) {
                hash = CombineHashFunction.getHash(hash, block.isNull(i) ? 0L : hashFunction.invoke(TypeUtils.readNativeValue((Type)type, (Block)block, (int)i)));
            }
            return hash;
        }
        catch (Throwable t) {
            throw Failures.internalError(t);
        }
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=long.class)
    @SqlType(value="bigint")
    public static long hashLong(@OperatorDependency(operator=OperatorType.HASH_CODE, argumentTypes={"T"}) MethodHandle hashFunction, @TypeParameter(value="T") Type type, @SqlType(value="array(T)") Block block) {
        try {
            long hash = 0L;
            for (int i = 0; i < block.getPositionCount(); ++i) {
                hash = CombineHashFunction.getHash(hash, block.isNull(i) ? 0L : hashFunction.invokeExact(type.getLong(block, i)));
            }
            return hash;
        }
        catch (Throwable t) {
            throw Failures.internalError(t);
        }
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=boolean.class)
    @SqlType(value="bigint")
    public static long hashBoolean(@OperatorDependency(operator=OperatorType.HASH_CODE, argumentTypes={"T"}) MethodHandle hashFunction, @TypeParameter(value="T") Type type, @SqlType(value="array(T)") Block block) {
        try {
            long hash = 0L;
            for (int i = 0; i < block.getPositionCount(); ++i) {
                hash = CombineHashFunction.getHash(hash, block.isNull(i) ? 0L : hashFunction.invokeExact(type.getBoolean(block, i)));
            }
            return hash;
        }
        catch (Throwable t) {
            throw Failures.internalError(t);
        }
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=Slice.class)
    @SqlType(value="bigint")
    public static long hashSlice(@OperatorDependency(operator=OperatorType.HASH_CODE, argumentTypes={"T"}) MethodHandle hashFunction, @TypeParameter(value="T") Type type, @SqlType(value="array(T)") Block block) {
        try {
            long hash = 0L;
            for (int i = 0; i < block.getPositionCount(); ++i) {
                hash = CombineHashFunction.getHash(hash, block.isNull(i) ? 0L : hashFunction.invokeExact(type.getSlice(block, i)));
            }
            return hash;
        }
        catch (Throwable t) {
            throw Failures.internalError(t);
        }
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=double.class)
    @SqlType(value="bigint")
    public static long hashDouble(@OperatorDependency(operator=OperatorType.HASH_CODE, argumentTypes={"T"}) MethodHandle hashFunction, @TypeParameter(value="T") Type type, @SqlType(value="array(T)") Block block) {
        try {
            long hash = 0L;
            for (int i = 0; i < block.getPositionCount(); ++i) {
                hash = CombineHashFunction.getHash(hash, block.isNull(i) ? 0L : hashFunction.invokeExact(type.getDouble(block, i)));
            }
            return hash;
        }
        catch (Throwable t) {
            throw Failures.internalError(t);
        }
    }
}

