/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.protocol;

import com.facebook.airlift.concurrent.BoundedExecutor;
import com.facebook.airlift.http.server.AsyncResponseHandler;
import com.facebook.airlift.stats.TimeStat;
import com.facebook.presto.server.ForStatementResource;
import com.facebook.presto.server.ServerConfig;
import com.facebook.presto.server.protocol.LocalQueryProvider;
import com.facebook.presto.server.protocol.Query;
import com.facebook.presto.server.protocol.QueryBlockingRateLimiter;
import com.facebook.presto.server.protocol.QueryResourceUtil;
import com.facebook.presto.spi.QueryId;
import com.google.common.base.Strings;
import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.security.RolesAllowed;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

@Path(value="/")
@RolesAllowed(value={"user"})
public class ExecutingStatementResource {
    private static final Duration MAX_WAIT_TIME = new Duration(1.0, TimeUnit.SECONDS);
    private static final Ordering<Comparable<Duration>> WAIT_ORDERING = Ordering.natural().nullsLast();
    private static final DataSize DEFAULT_TARGET_RESULT_SIZE = new DataSize(1.0, DataSize.Unit.MEGABYTE);
    private static final DataSize MAX_TARGET_RESULT_SIZE = new DataSize(128.0, DataSize.Unit.MEGABYTE);
    private final BoundedExecutor responseExecutor;
    private final LocalQueryProvider queryProvider;
    private final boolean compressionEnabled;
    private final QueryBlockingRateLimiter queryRateLimiter;

    @Inject
    public ExecutingStatementResource(@ForStatementResource BoundedExecutor responseExecutor, LocalQueryProvider queryProvider, ServerConfig serverConfig, QueryBlockingRateLimiter queryRateLimiter) {
        this.responseExecutor = Objects.requireNonNull(responseExecutor, "responseExecutor is null");
        this.queryProvider = Objects.requireNonNull(queryProvider, "queryProvider is null");
        this.compressionEnabled = Objects.requireNonNull(serverConfig, "serverConfig is null").isQueryResultsCompressionEnabled();
        this.queryRateLimiter = Objects.requireNonNull(queryRateLimiter, "queryRateLimiter is null");
    }

    @Managed
    @Nested
    public TimeStat getRateLimiterBlockTime() {
        return this.queryRateLimiter.getRateLimiterBlockTime();
    }

    @GET
    @Path(value="/v1/statement/executing/{queryId}/{token}")
    @Produces(value={"application/json"})
    public void getQueryResults(@PathParam(value="queryId") QueryId queryId, @PathParam(value="token") long token, @QueryParam(value="slug") String slug, @QueryParam(value="maxWait") Duration maxWait, @QueryParam(value="targetResultSize") DataSize targetResultSize, @HeaderParam(value="X-Forwarded-Proto") String proto, @Context UriInfo uriInfo, @Suspended AsyncResponse asyncResponse) {
        Duration wait = (Duration)WAIT_ORDERING.min((Object)MAX_WAIT_TIME, (Object)maxWait);
        targetResultSize = targetResultSize == null ? DEFAULT_TARGET_RESULT_SIZE : (DataSize)Ordering.natural().min((Object)targetResultSize, (Object)MAX_TARGET_RESULT_SIZE);
        if (Strings.isNullOrEmpty((String)proto)) {
            proto = uriInfo.getRequestUri().getScheme();
        }
        Query query = this.queryProvider.getQuery(queryId, slug);
        ListenableFuture<Double> acquirePermitAsync = this.queryRateLimiter.acquire(queryId);
        String effectiveFinalProto = proto;
        DataSize effectiveFinalTargetResultSize = targetResultSize;
        ListenableFuture waitForResultsAsync = Futures.transformAsync(acquirePermitAsync, acquirePermitTimeSeconds -> {
            this.queryRateLimiter.addRateLimiterBlockTime(new Duration(acquirePermitTimeSeconds.doubleValue(), TimeUnit.SECONDS));
            return query.waitForResults(token, uriInfo, effectiveFinalProto, wait, effectiveFinalTargetResultSize);
        }, (Executor)this.responseExecutor);
        ListenableFuture queryResultsFuture = Futures.transform((ListenableFuture)waitForResultsAsync, results -> QueryResourceUtil.toResponse(query, results, this.compressionEnabled), (Executor)MoreExecutors.directExecutor());
        AsyncResponseHandler.bindAsyncResponse((AsyncResponse)asyncResponse, (ListenableFuture)queryResultsFuture, (Executor)this.responseExecutor);
    }

    @DELETE
    @Path(value="/v1/statement/executing/{queryId}/{token}")
    @Produces(value={"application/json"})
    public Response cancelQuery(@PathParam(value="queryId") QueryId queryId, @PathParam(value="token") long token, @QueryParam(value="slug") String slug) {
        this.queryProvider.cancel(queryId, slug);
        return Response.noContent().build();
    }
}

