/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.split;

import com.facebook.presto.Session;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.FixedPageSource;
import com.facebook.presto.spi.SplitContext;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.split.PageSourceProvider;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;

public class PageSourceManager
implements PageSourceProvider {
    private final ConcurrentMap<ConnectorId, ConnectorPageSourceProvider> pageSourceProviders = new ConcurrentHashMap<ConnectorId, ConnectorPageSourceProvider>();

    public void addConnectorPageSourceProvider(ConnectorId connectorId, ConnectorPageSourceProvider pageSourceProvider) {
        Objects.requireNonNull(connectorId, "connectorId is null");
        Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
        Preconditions.checkState((this.pageSourceProviders.put(connectorId, pageSourceProvider) == null ? 1 : 0) != 0, (String)"PageSourceProvider for connector '%s' is already registered", (Object)connectorId);
    }

    public void removeConnectorPageSourceProvider(ConnectorId connectorId) {
        this.pageSourceProviders.remove(connectorId);
    }

    @Override
    public ConnectorPageSource createPageSource(Session session, Split split, TableHandle table, List<ColumnHandle> columns) {
        Objects.requireNonNull(split, "split is null");
        Objects.requireNonNull(columns, "columns is null");
        Optional dynamicFilter = table.getDynamicFilter();
        if (dynamicFilter.isPresent() && ((TupleDomain)((Supplier)dynamicFilter.get()).get()).isNone()) {
            return new FixedPageSource((Iterable)ImmutableList.of());
        }
        if (dynamicFilter.isPresent()) {
            split = new Split(split.getConnectorId(), split.getTransactionHandle(), split.getConnectorSplit(), split.getLifespan(), new SplitContext(split.getSplitContext().isCacheable(), (TupleDomain)((Supplier)dynamicFilter.get()).get()));
        }
        ConnectorSession connectorSession = session.toConnectorSession(split.getConnectorId());
        if (table.getLayout().isPresent()) {
            return this.getPageSourceProvider(split).createPageSource(split.getTransactionHandle(), connectorSession, split.getConnectorSplit(), (ConnectorTableLayoutHandle)table.getLayout().get(), columns, split.getSplitContext());
        }
        return this.getPageSourceProvider(split).createPageSource(split.getTransactionHandle(), connectorSession, split.getConnectorSplit(), columns, split.getSplitContext());
    }

    private ConnectorPageSourceProvider getPageSourceProvider(Split split) {
        ConnectorPageSourceProvider provider = (ConnectorPageSourceProvider)this.pageSourceProviders.get(split.getConnectorId());
        Preconditions.checkArgument((provider != null ? 1 : 0) != 0, (String)"No page stream provider for '%s", (Object)split.getConnectorId());
        return provider;
    }
}

