/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.bytecode.Binding;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.Scope;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.control.IfStatement;
import com.facebook.presto.bytecode.control.SwitchStatement;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.bytecode.instruction.JumpInstruction;
import com.facebook.presto.bytecode.instruction.LabelNode;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.JavaScalarFunctionImplementation;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.gen.BytecodeGeneratorContext;
import com.facebook.presto.sql.gen.BytecodeUtils;
import com.facebook.presto.sql.gen.SpecialFormBytecodeGenerator;
import com.facebook.presto.util.FastutilSetHelper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import java.lang.invoke.MethodHandle;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class InCodeGenerator
implements SpecialFormBytecodeGenerator {
    private final FunctionAndTypeManager functionAndTypeManager;

    public InCodeGenerator(FunctionAndTypeManager functionAndTypeManager) {
        this.functionAndTypeManager = Objects.requireNonNull(functionAndTypeManager, "functionManager is null");
    }

    @VisibleForTesting
    static SwitchGenerationCase checkSwitchGenerationCase(Type type, List<RowExpression> values) {
        if (values.size() > 32) {
            return SwitchGenerationCase.SET_CONTAINS;
        }
        if (!(type instanceof IntegerType || type instanceof BigintType || type instanceof DateType)) {
            return SwitchGenerationCase.HASH_SWITCH;
        }
        for (RowExpression expression : values) {
            long longConstant;
            Object constant;
            if (!(expression instanceof ConstantExpression) || (constant = ((ConstantExpression)expression).getValue()) == null || (longConstant = ((Number)constant).longValue()) >= Integer.MIN_VALUE && longConstant <= Integer.MAX_VALUE) continue;
            return SwitchGenerationCase.HASH_SWITCH;
        }
        return SwitchGenerationCase.DIRECT_SWITCH;
    }

    @Override
    public BytecodeNode generateExpression(BytecodeGeneratorContext generatorContext, Type returnType, List<RowExpression> arguments, Optional<Variable> outputBlockVariable) {
        BytecodeBlock switchBlock;
        List<RowExpression> values = arguments.subList(1, arguments.size());
        Preconditions.checkArgument((values.size() > 0 ? 1 : 0) != 0, (Object)"values must not be empty");
        Type type = arguments.get(0).getType();
        Class<Object> javaType = type.getJavaType();
        SwitchGenerationCase switchGenerationCase = InCodeGenerator.checkSwitchGenerationCase(type, values);
        FunctionHandle hashCodeHandle = generatorContext.getFunctionManager().resolveOperator(OperatorType.HASH_CODE, TypeSignatureProvider.fromTypes(type));
        MethodHandle hashCodeFunction = generatorContext.getFunctionManager().getJavaScalarFunctionImplementation(hashCodeHandle).getMethodHandle();
        FunctionHandle isIndeterminateHandle = generatorContext.getFunctionManager().resolveOperator(OperatorType.INDETERMINATE, TypeSignatureProvider.fromTypes(type));
        JavaScalarFunctionImplementation isIndeterminateFunction = generatorContext.getFunctionManager().getJavaScalarFunctionImplementation(isIndeterminateHandle);
        ImmutableListMultimap.Builder hashBucketsBuilder = ImmutableListMultimap.builder();
        ImmutableList.Builder defaultBucket = ImmutableList.builder();
        ImmutableSet.Builder constantValuesBuilder = ImmutableSet.builder();
        for (RowExpression testValue : values) {
            BytecodeNode testBytecode = generatorContext.generate(testValue, Optional.empty());
            if (InCodeGenerator.isDeterminateConstant(testValue, isIndeterminateFunction.getMethodHandle())) {
                ConstantExpression constant = (ConstantExpression)testValue;
                Object object = constant.getValue();
                switch (switchGenerationCase) {
                    case DIRECT_SWITCH: 
                    case SET_CONTAINS: {
                        constantValuesBuilder.add(object);
                        break;
                    }
                    case HASH_SWITCH: {
                        try {
                            int hashCode = Math.toIntExact(Long.hashCode(hashCodeFunction.invoke(object)));
                            hashBucketsBuilder.put((Object)hashCode, (Object)testBytecode);
                            break;
                        }
                        catch (Throwable throwable) {
                            throw new IllegalArgumentException("Error processing IN statement: error calculating hash code for " + object, throwable);
                        }
                    }
                    default: {
                        throw new IllegalArgumentException("Not supported switch generation case: " + (Object)((Object)switchGenerationCase));
                    }
                }
                continue;
            }
            defaultBucket.add((Object)testBytecode);
        }
        ImmutableListMultimap hashBuckets = hashBucketsBuilder.build();
        ImmutableSet constantValues = constantValuesBuilder.build();
        LabelNode end = new LabelNode("end");
        LabelNode match = new LabelNode("match");
        LabelNode noMatch = new LabelNode("noMatch");
        LabelNode defaultLabel = new LabelNode("default");
        Scope scope = generatorContext.getScope();
        Variable value = scope.createTempVariable((Class)javaType);
        Variable expression = scope.createTempVariable(Integer.TYPE);
        SwitchStatement.SwitchBuilder switchBuilder = new SwitchStatement.SwitchBuilder().expression((BytecodeExpression)expression);
        switch (switchGenerationCase) {
            case DIRECT_SWITCH: {
                for (Object constantValue : constantValues) {
                    switchBuilder.addCase(Math.toIntExact((Long)constantValue), (BytecodeNode)JumpInstruction.jump((LabelNode)match));
                }
                switchBuilder.defaultCase((BytecodeNode)JumpInstruction.jump((LabelNode)defaultLabel));
                switchBlock = new BytecodeBlock().comment("lookupSwitch(<stackValue>))").append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.invokeStatic(InCodeGenerator.class, (String)"isInteger", Boolean.TYPE, (BytecodeExpression[])new BytecodeExpression[]{value})).ifFalse((BytecodeNode)new BytecodeBlock().gotoLabel(defaultLabel))).append((BytecodeNode)expression.set(value.cast(Integer.TYPE))).append((BytecodeNode)switchBuilder.build());
                break;
            }
            case HASH_SWITCH: {
                for (Map.Entry bucket : hashBuckets.asMap().entrySet()) {
                    Collection testValues = (Collection)bucket.getValue();
                    BytecodeBlock caseBlock = InCodeGenerator.buildInCase(generatorContext, scope, type, match, defaultLabel, value, testValues, false, isIndeterminateFunction);
                    switchBuilder.addCase(((Integer)bucket.getKey()).intValue(), (BytecodeNode)caseBlock);
                }
                switchBuilder.defaultCase((BytecodeNode)JumpInstruction.jump((LabelNode)defaultLabel));
                Binding hashCodeBinding = generatorContext.getCallSiteBinder().bind(hashCodeFunction);
                switchBlock = new BytecodeBlock().comment("lookupSwitch(hashCode(<stackValue>))").getVariable(value).append((BytecodeNode)BytecodeUtils.invoke(hashCodeBinding, OperatorType.HASH_CODE.name())).invokeStatic(Long.class, "hashCode", Integer.TYPE, new Class[]{Long.TYPE}).putVariable(expression).append((BytecodeNode)switchBuilder.build());
                break;
            }
            case SET_CONTAINS: {
                Set<?> constantValuesSet = FastutilSetHelper.toFastutilHashSet(constantValues, type, this.functionAndTypeManager);
                Binding constant = generatorContext.getCallSiteBinder().bind(constantValuesSet, constantValuesSet.getClass());
                switchBlock = new BytecodeBlock().comment("inListSet.contains(<stackValue>)").append((BytecodeNode)new IfStatement().condition((BytecodeNode)new BytecodeBlock().comment("value").getVariable(value).comment("set").append((BytecodeNode)BytecodeUtils.loadConstant(constant)).invokeStatic(FastutilSetHelper.class, "in", Boolean.TYPE, new Class[]{javaType.isPrimitive() ? javaType : Object.class, constantValuesSet.getClass()})).ifTrue((BytecodeNode)JumpInstruction.jump((LabelNode)match)));
                break;
            }
            default: {
                throw new IllegalArgumentException("Not supported switch generation case: " + (Object)((Object)switchGenerationCase));
            }
        }
        BytecodeBlock defaultCaseBlock = InCodeGenerator.buildInCase(generatorContext, scope, type, match, noMatch, value, (Collection<BytecodeNode>)defaultBucket.build(), true, isIndeterminateFunction).setDescription("default");
        BytecodeBlock block = new BytecodeBlock().comment("IN").append(generatorContext.generate(arguments.get(0), Optional.empty())).append(BytecodeUtils.ifWasNullPopAndGoto(scope, end, Boolean.TYPE, javaType)).putVariable(value).append((BytecodeNode)switchBlock).visitLabel(defaultLabel).append((BytecodeNode)defaultCaseBlock);
        BytecodeBlock matchBlock = new BytecodeBlock().setDescription("match").visitLabel(match).append((BytecodeNode)generatorContext.wasNull().set(BytecodeExpressions.constantFalse())).push(true).gotoLabel(end);
        block.append((BytecodeNode)matchBlock);
        BytecodeBlock noMatchBlock = new BytecodeBlock().setDescription("noMatch").visitLabel(noMatch).push(false).gotoLabel(end);
        block.append((BytecodeNode)noMatchBlock);
        block.visitLabel(end);
        outputBlockVariable.ifPresent(output -> block.append(SpecialFormBytecodeGenerator.generateWrite(generatorContext, returnType, output)));
        return block;
    }

    public static boolean isInteger(long value) {
        return value == (long)((int)value);
    }

    private static BytecodeBlock buildInCase(BytecodeGeneratorContext generatorContext, Scope scope, Type type, LabelNode matchLabel, LabelNode noMatchLabel, Variable value, Collection<BytecodeNode> testValues, boolean checkForNulls, JavaScalarFunctionImplementation isIndeterminateFunction) {
        Variable caseWasNull = null;
        if (checkForNulls) {
            caseWasNull = scope.createTempVariable(Boolean.TYPE);
        }
        BytecodeBlock caseBlock = new BytecodeBlock();
        if (checkForNulls) {
            caseBlock.putVariable(caseWasNull, false);
        }
        LabelNode elseLabel = new LabelNode("else");
        BytecodeBlock elseBlock = new BytecodeBlock().visitLabel(elseLabel);
        Variable wasNull = generatorContext.wasNull();
        if (checkForNulls) {
            if (testValues.isEmpty()) {
                elseBlock.append((BytecodeNode)new BytecodeBlock().append(generatorContext.generateCall(OperatorType.INDETERMINATE.name(), isIndeterminateFunction, (List<BytecodeNode>)ImmutableList.of((Object)value))).putVariable(wasNull));
            } else {
                elseBlock.append((BytecodeNode)wasNull.set((BytecodeExpression)caseWasNull));
            }
        }
        elseBlock.gotoLabel(noMatchLabel);
        FunctionHandle equalsHandle = generatorContext.getFunctionManager().resolveOperator(OperatorType.EQUAL, TypeSignatureProvider.fromTypes(type, type));
        JavaScalarFunctionImplementation equalsFunction = generatorContext.getFunctionManager().getJavaScalarFunctionImplementation(equalsHandle);
        BytecodeBlock elseNode = elseBlock;
        for (BytecodeNode testNode : testValues) {
            LabelNode testLabel = new LabelNode("test");
            IfStatement test = new IfStatement();
            BytecodeNode equalsCall = generatorContext.generateCall(OperatorType.EQUAL.name(), equalsFunction, (List<BytecodeNode>)ImmutableList.of((Object)value, (Object)testNode));
            test.condition().visitLabel(testLabel).append(equalsCall);
            if (checkForNulls) {
                IfStatement wasNullCheck = new IfStatement("if wasNull, set caseWasNull to true, clear wasNull, pop boolean, and goto next test value", new Object[0]);
                wasNullCheck.condition((BytecodeNode)wasNull);
                wasNullCheck.ifTrue((BytecodeNode)new BytecodeBlock().append((BytecodeNode)caseWasNull.set(BytecodeExpressions.constantTrue())).append((BytecodeNode)wasNull.set(BytecodeExpressions.constantFalse())).pop(Boolean.TYPE).gotoLabel(elseLabel));
                test.condition().append((BytecodeNode)wasNullCheck);
            }
            test.ifTrue().gotoLabel(matchLabel);
            test.ifFalse((BytecodeNode)elseNode);
            elseNode = test;
            elseLabel = testLabel;
        }
        caseBlock.append((BytecodeNode)elseNode);
        return caseBlock;
    }

    private static boolean isDeterminateConstant(RowExpression expression, MethodHandle isIndeterminateFunction) {
        boolean isNull;
        if (!(expression instanceof ConstantExpression)) {
            return false;
        }
        ConstantExpression constantExpression = (ConstantExpression)expression;
        Object value = constantExpression.getValue();
        boolean bl = isNull = value == null;
        if (isNull) {
            return false;
        }
        try {
            return !isIndeterminateFunction.invoke(value, false);
        }
        catch (Throwable t) {
            Throwables.throwIfUnchecked((Throwable)t);
            throw new RuntimeException(t);
        }
    }

    static enum SwitchGenerationCase {
        DIRECT_SWITCH,
        HASH_SWITCH,
        SET_CONTAINS;

    }
}

