/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.expressions.DefaultRowExpressionTraversalVisitor;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.ExpressionTreeUtils;
import com.facebook.presto.sql.planner.ExpressionExtractor;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.optimizations.PlanNodeSearcher;
import com.facebook.presto.sql.relational.OriginalExpressionUtils;
import com.facebook.presto.sql.tree.DefaultExpressionTraversalVisitor;
import com.facebook.presto.sql.tree.DefaultTraversalVisitor;
import com.facebook.presto.sql.tree.DereferenceExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class VariablesExtractor {
    private VariablesExtractor() {
    }

    public static Set<VariableReferenceExpression> extractUnique(PlanNode node, TypeProvider types) {
        ImmutableSet.Builder unique = ImmutableSet.builder();
        ExpressionExtractor.extractExpressions(node).forEach(expression -> unique.addAll(VariablesExtractor.extractUniqueVariableInternal(expression, types)));
        return unique.build();
    }

    public static Set<VariableReferenceExpression> extractUniqueNonRecursive(PlanNode node, TypeProvider types) {
        ImmutableSet.Builder uniqueVariables = ImmutableSet.builder();
        ExpressionExtractor.extractExpressionsNonRecursive(node).forEach(expression -> uniqueVariables.addAll(VariablesExtractor.extractUniqueVariableInternal(expression, types)));
        return uniqueVariables.build();
    }

    public static Set<VariableReferenceExpression> extractUnique(PlanNode node, Lookup lookup, TypeProvider types) {
        ImmutableSet.Builder unique = ImmutableSet.builder();
        ExpressionExtractor.extractExpressions(node, lookup).forEach(expression -> unique.addAll(VariablesExtractor.extractUniqueVariableInternal(expression, types)));
        return unique.build();
    }

    public static Set<VariableReferenceExpression> extractUnique(Expression expression, TypeProvider types) {
        return ImmutableSet.copyOf(VariablesExtractor.extractAll(expression, types));
    }

    public static Set<VariableReferenceExpression> extractUnique(RowExpression expression) {
        return ImmutableSet.copyOf(VariablesExtractor.extractAll(expression));
    }

    public static Set<VariableReferenceExpression> extractUnique(Iterable<? extends RowExpression> expressions) {
        ImmutableSet.Builder unique = ImmutableSet.builder();
        for (RowExpression rowExpression : expressions) {
            unique.addAll(VariablesExtractor.extractAll(rowExpression));
        }
        return unique.build();
    }

    @Deprecated
    public static Set<VariableReferenceExpression> extractUnique(Iterable<? extends Expression> expressions, TypeProvider types) {
        ImmutableSet.Builder unique = ImmutableSet.builder();
        for (Expression expression : expressions) {
            unique.addAll(VariablesExtractor.extractAll(expression, types));
        }
        return unique.build();
    }

    public static List<Symbol> extractAllSymbols(Expression expression) {
        ImmutableList.Builder builder = ImmutableList.builder();
        new SymbolBuilderVisitor().process((Node)expression, builder);
        return builder.build();
    }

    public static List<VariableReferenceExpression> extractAll(Expression expression, TypeProvider types) {
        ImmutableList.Builder builder = ImmutableList.builder();
        new VariableFromExpressionBuilderVisitor(types).process((Node)expression, builder);
        return builder.build();
    }

    public static List<VariableReferenceExpression> extractAll(RowExpression expression) {
        ImmutableList.Builder builder = ImmutableList.builder();
        expression.accept((RowExpressionVisitor)new VariableBuilderVisitor(), (Object)builder);
        return builder.build();
    }

    public static Set<QualifiedName> extractNames(Expression expression, Set<NodeRef<Expression>> columnReferences) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        new QualifiedNameBuilderVisitor(columnReferences).process((Node)expression, builder);
        return builder.build();
    }

    public static Set<VariableReferenceExpression> extractOutputVariables(PlanNode planNode) {
        return VariablesExtractor.extractOutputVariables(planNode, Lookup.noLookup());
    }

    public static Set<VariableReferenceExpression> extractOutputVariables(PlanNode planNode, Lookup lookup) {
        return (Set)PlanNodeSearcher.searchFrom(planNode, lookup).findAll().stream().flatMap(node -> node.getOutputVariables().stream()).collect(ImmutableSet.toImmutableSet());
    }

    private static Set<VariableReferenceExpression> extractUniqueVariableInternal(RowExpression expression, TypeProvider types) {
        if (OriginalExpressionUtils.isExpression(expression)) {
            return VariablesExtractor.extractUnique(OriginalExpressionUtils.castToExpression(expression), types);
        }
        return VariablesExtractor.extractUnique(expression);
    }

    private static class QualifiedNameBuilderVisitor
    extends DefaultTraversalVisitor<Void, ImmutableSet.Builder<QualifiedName>> {
        private final Set<NodeRef<Expression>> columnReferences;

        private QualifiedNameBuilderVisitor(Set<NodeRef<Expression>> columnReferences) {
            this.columnReferences = Objects.requireNonNull(columnReferences, "columnReferences is null");
        }

        protected Void visitDereferenceExpression(DereferenceExpression node, ImmutableSet.Builder<QualifiedName> builder) {
            if (this.columnReferences.contains(NodeRef.of((Node)node))) {
                builder.add((Object)DereferenceExpression.getQualifiedName((DereferenceExpression)node));
            } else {
                this.process((Node)node.getBase(), builder);
            }
            return null;
        }

        protected Void visitIdentifier(Identifier node, ImmutableSet.Builder<QualifiedName> builder) {
            builder.add((Object)QualifiedName.of((String)node.getValue()));
            return null;
        }
    }

    private static class VariableBuilderVisitor
    extends DefaultRowExpressionTraversalVisitor<ImmutableList.Builder<VariableReferenceExpression>> {
        private VariableBuilderVisitor() {
        }

        public Void visitVariableReference(VariableReferenceExpression variable, ImmutableList.Builder<VariableReferenceExpression> builder) {
            builder.add((Object)variable);
            return null;
        }
    }

    private static class VariableFromExpressionBuilderVisitor
    extends DefaultExpressionTraversalVisitor<Void, ImmutableList.Builder<VariableReferenceExpression>> {
        private final TypeProvider types;

        protected VariableFromExpressionBuilderVisitor(TypeProvider types) {
            this.types = types;
        }

        protected Void visitSymbolReference(SymbolReference node, ImmutableList.Builder<VariableReferenceExpression> builder) {
            builder.add((Object)new VariableReferenceExpression(ExpressionTreeUtils.getSourceLocation((Node)node), node.getName(), this.types.get((Expression)node)));
            return null;
        }
    }

    private static class SymbolBuilderVisitor
    extends DefaultExpressionTraversalVisitor<Void, ImmutableList.Builder<Symbol>> {
        private SymbolBuilderVisitor() {
        }

        protected Void visitSymbolReference(SymbolReference node, ImmutableList.Builder<Symbol> builder) {
            builder.add((Object)Symbol.from((Expression)node));
            return null;
        }
    }
}

