/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.properties;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.constraints.UniqueConstraint;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.DistinctLimitNode;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.LimitNode;
import com.facebook.presto.spi.plan.LogicalProperties;
import com.facebook.presto.spi.plan.LogicalPropertiesProvider;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.plan.TopNNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.iterative.GroupReference;
import com.facebook.presto.sql.planner.iterative.properties.LogicalPropertiesImpl;
import com.facebook.presto.sql.planner.plan.AssignUniqueId;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.relational.FunctionResolution;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class LogicalPropertiesProviderImpl
implements LogicalPropertiesProvider {
    private final FunctionResolution functionResolution;

    public LogicalPropertiesProviderImpl(FunctionResolution functionResolution) {
        this.functionResolution = Objects.requireNonNull(functionResolution, "functionResolution is null");
    }

    public LogicalProperties getValuesProperties(ValuesNode valuesNode) {
        LogicalPropertiesImpl sourceProps = new LogicalPropertiesImpl.NoPropagateBuilder(this.functionResolution).build();
        LogicalPropertiesImpl.PropagateAndLimitBuilder propagateAndLimitBuilder = new LogicalPropertiesImpl.PropagateAndLimitBuilder(sourceProps, valuesNode.getRows().size(), this.functionResolution);
        return propagateAndLimitBuilder.build();
    }

    public LogicalProperties getTableScanProperties(TableScanNode tableScanNode) {
        ArrayList<Set<VariableReferenceExpression>> keys = new ArrayList<Set<VariableReferenceExpression>>();
        List uniqueConstraints = tableScanNode.getTableConstraints().stream().filter(tableConstraint -> tableConstraint instanceof UniqueConstraint && (tableConstraint.isEnforced() || tableConstraint.isRely())).collect(Collectors.toList());
        if (!uniqueConstraints.isEmpty()) {
            Map assignments = tableScanNode.getAssignments();
            Map<ColumnHandle, VariableReferenceExpression> inverseAssignments = assignments.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
            uniqueConstraints.stream().filter(uniqueConstraint -> uniqueConstraint.getColumns().stream().allMatch(col -> inverseAssignments.containsKey(col))).forEach(uniqueConstraint -> keys.add(uniqueConstraint.getColumns().stream().map(col -> (VariableReferenceExpression)inverseAssignments.get(col)).collect(Collectors.toSet())));
        }
        LogicalPropertiesImpl.TableScanBuilder logicalPropsBuilder = new LogicalPropertiesImpl.TableScanBuilder(keys, this.functionResolution);
        return logicalPropsBuilder.build();
    }

    public LogicalProperties getFilterProperties(FilterNode filterNode) {
        if (!(filterNode.getSource() instanceof GroupReference) || !((GroupReference)filterNode.getSource()).getLogicalProperties().isPresent()) {
            throw new IllegalStateException("Expected source PlanNode to be a GroupReference with LogicalProperties");
        }
        LogicalPropertiesImpl sourceProps = (LogicalPropertiesImpl)((GroupReference)filterNode.getSource()).getLogicalProperties().get();
        LogicalPropertiesImpl.FilterBuilder logicalPropsBuilder = new LogicalPropertiesImpl.FilterBuilder(sourceProps, filterNode.getPredicate(), this.functionResolution);
        return logicalPropsBuilder.build();
    }

    public LogicalProperties getProjectProperties(ProjectNode projectNode) {
        if (!(projectNode.getSource() instanceof GroupReference) || !((GroupReference)projectNode.getSource()).getLogicalProperties().isPresent()) {
            throw new IllegalStateException("Expected source PlanNode to be a GroupReference with LogicalProperties");
        }
        LogicalPropertiesImpl sourceProps = (LogicalPropertiesImpl)((GroupReference)projectNode.getSource()).getLogicalProperties().get();
        LogicalPropertiesImpl.ProjectBuilder logicalPropsBuilder = new LogicalPropertiesImpl.ProjectBuilder(sourceProps, projectNode.getAssignments(), this.functionResolution);
        return logicalPropsBuilder.build();
    }

    public LogicalProperties getJoinProperties(PlanNode node) {
        if (!(node instanceof JoinNode)) {
            throw new IllegalArgumentException("Expected PlanNode to be instance of JoinNode");
        }
        JoinNode joinNode = (JoinNode)node;
        if (!(joinNode.getLeft() instanceof GroupReference) || !((GroupReference)joinNode.getLeft()).getLogicalProperties().isPresent()) {
            throw new IllegalStateException("Expected left source PlanNode to be a GroupReference with LogicalProperties");
        }
        if (!(joinNode.getRight() instanceof GroupReference) || !((GroupReference)joinNode.getRight()).getLogicalProperties().isPresent()) {
            throw new IllegalStateException("Expected right source PlanNode to be a GroupReference with LogicalProperties");
        }
        LogicalPropertiesImpl leftProps = (LogicalPropertiesImpl)((GroupReference)joinNode.getLeft()).getLogicalProperties().get();
        LogicalPropertiesImpl rightProps = (LogicalPropertiesImpl)((GroupReference)joinNode.getRight()).getLogicalProperties().get();
        LogicalPropertiesImpl.JoinBuilder logicalPropsBuilder = new LogicalPropertiesImpl.JoinBuilder(leftProps, rightProps, joinNode.getCriteria(), joinNode.getType(), joinNode.getFilter(), joinNode.getOutputVariables(), this.functionResolution);
        return logicalPropsBuilder.build();
    }

    public LogicalProperties getSemiJoinProperties(PlanNode node) {
        if (!(node instanceof SemiJoinNode)) {
            throw new IllegalArgumentException("Expected PlanNode to be instance of SemiJoinNode");
        }
        SemiJoinNode semiJoinNode = (SemiJoinNode)node;
        if (!(semiJoinNode.getSource() instanceof GroupReference) || !((GroupReference)semiJoinNode.getSource()).getLogicalProperties().isPresent()) {
            throw new IllegalStateException("Expected non-filtering source PlanNode to be a GroupReference with LogicalProperties");
        }
        LogicalPropertiesImpl sourceProps = (LogicalPropertiesImpl)((GroupReference)semiJoinNode.getSource()).getLogicalProperties().get();
        LogicalPropertiesImpl.PropagateBuilder propagateBuilder = new LogicalPropertiesImpl.PropagateBuilder(sourceProps, this.functionResolution);
        return propagateBuilder.build();
    }

    public LogicalProperties getAggregationProperties(AggregationNode aggregationNode) {
        if (!(aggregationNode.getSource() instanceof GroupReference) || !((GroupReference)aggregationNode.getSource()).getLogicalProperties().isPresent()) {
            throw new IllegalStateException("Expected source PlanNode to be a GroupReference with LogicalProperties");
        }
        if (aggregationNode.getGroupingKeys().isEmpty() && aggregationNode.getAggregations().isEmpty()) {
            throw new IllegalStateException("Aggregation node with no grouping columns and no aggregation functions");
        }
        LogicalPropertiesImpl sourceProps = (LogicalPropertiesImpl)((GroupReference)aggregationNode.getSource()).getLogicalProperties().get();
        if (!aggregationNode.getAggregations().isEmpty() && aggregationNode.getGroupingKeys().isEmpty()) {
            LogicalPropertiesImpl.PropagateAndLimitBuilder propagateBuilder = new LogicalPropertiesImpl.PropagateAndLimitBuilder(sourceProps, 1L, this.functionResolution);
            return propagateBuilder.build();
        }
        LogicalPropertiesImpl.AggregationBuilder aggregationBuilder = new LogicalPropertiesImpl.AggregationBuilder(sourceProps, aggregationNode.getGroupingKeys().stream().collect(Collectors.toSet()), aggregationNode.getOutputVariables(), this.functionResolution);
        return aggregationBuilder.build();
    }

    public LogicalProperties getAssignUniqueIdProperties(PlanNode node) {
        if (!(node instanceof AssignUniqueId)) {
            throw new IllegalArgumentException("Expected PlanNode to be instance of AssignUniqueId");
        }
        AssignUniqueId assignUniqueIdNode = (AssignUniqueId)node;
        if (!(assignUniqueIdNode.getSource() instanceof GroupReference) || !((GroupReference)assignUniqueIdNode.getSource()).getLogicalProperties().isPresent()) {
            throw new IllegalStateException("Expected source PlanNode to be a GroupReference with LogicalProperties");
        }
        if (assignUniqueIdNode.getIdVariable() == null) {
            throw new IllegalStateException("AssignUniqueId should have an id variable");
        }
        LogicalPropertiesImpl sourceProps = (LogicalPropertiesImpl)((GroupReference)assignUniqueIdNode.getSource()).getLogicalProperties().get();
        HashSet<VariableReferenceExpression> key = new HashSet<VariableReferenceExpression>();
        key.add(assignUniqueIdNode.getIdVariable());
        LogicalPropertiesImpl.AggregationBuilder aggregationBuilder = new LogicalPropertiesImpl.AggregationBuilder(sourceProps, key, assignUniqueIdNode.getOutputVariables(), this.functionResolution);
        return aggregationBuilder.build();
    }

    public LogicalProperties getDistinctLimitProperties(DistinctLimitNode distinctLimitNode) {
        if (!(distinctLimitNode.getSource() instanceof GroupReference) || !((GroupReference)distinctLimitNode.getSource()).getLogicalProperties().isPresent()) {
            throw new IllegalStateException("Expected source PlanNode to be a GroupReference with LogicalProperties");
        }
        LogicalPropertiesImpl sourceProps = (LogicalPropertiesImpl)((GroupReference)distinctLimitNode.getSource()).getLogicalProperties().get();
        LogicalPropertiesImpl.DistinctLimitBuilder aggregationBuilder = new LogicalPropertiesImpl.DistinctLimitBuilder(sourceProps, distinctLimitNode.getDistinctVariables().stream().collect(Collectors.toSet()), distinctLimitNode.getLimit(), distinctLimitNode.getOutputVariables(), this.functionResolution);
        return aggregationBuilder.build();
    }

    public LogicalProperties getLimitProperties(LimitNode limitNode) {
        if (!(limitNode.getSource() instanceof GroupReference) || !((GroupReference)limitNode.getSource()).getLogicalProperties().isPresent()) {
            throw new IllegalStateException("Expected source PlanNode to be a GroupReference with LogicalProperties");
        }
        LogicalPropertiesImpl sourceProps = (LogicalPropertiesImpl)((GroupReference)limitNode.getSource()).getLogicalProperties().get();
        LogicalPropertiesImpl.PropagateAndLimitBuilder propagateBuilder = new LogicalPropertiesImpl.PropagateAndLimitBuilder(sourceProps, limitNode.getCount(), this.functionResolution);
        return propagateBuilder.build();
    }

    public LogicalProperties getTopNProperties(TopNNode topNNode) {
        if (!(topNNode.getSource() instanceof GroupReference) || !((GroupReference)topNNode.getSource()).getLogicalProperties().isPresent()) {
            throw new IllegalStateException("Expected left source PlanNode to be a GroupReference with LogicalProperties");
        }
        LogicalPropertiesImpl sourceProps = (LogicalPropertiesImpl)((GroupReference)topNNode.getSource()).getLogicalProperties().get();
        LogicalPropertiesImpl.PropagateAndLimitBuilder propagateBuilder = new LogicalPropertiesImpl.PropagateAndLimitBuilder(sourceProps, topNNode.getCount(), this.functionResolution);
        return propagateBuilder.build();
    }

    public LogicalProperties getSortProperties(PlanNode node) {
        if (!(node instanceof SortNode)) {
            throw new IllegalArgumentException("Expected PlanNode to be instance of SortNode");
        }
        SortNode sortNode = (SortNode)node;
        if (!(sortNode.getSource() instanceof GroupReference) || !((GroupReference)sortNode.getSource()).getLogicalProperties().isPresent()) {
            throw new IllegalStateException("Expected source PlanNode to be a GroupReference with LogicalProperties");
        }
        LogicalPropertiesImpl sourceProps = (LogicalPropertiesImpl)((GroupReference)sortNode.getSource()).getLogicalProperties().get();
        LogicalPropertiesImpl.PropagateBuilder propagateBuilder = new LogicalPropertiesImpl.PropagateBuilder(sourceProps, this.functionResolution);
        return propagateBuilder.build();
    }

    public LogicalProperties getDefaultProperties() {
        LogicalPropertiesImpl.NoPropagateBuilder logicalPropsBuilder = new LogicalPropertiesImpl.NoPropagateBuilder(this.functionResolution);
        return logicalPropsBuilder.build();
    }
}

