/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.spi.SourceLocation;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.plan.InternalPlanNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class DeleteNode
extends InternalPlanNode {
    private final PlanNode source;
    private final VariableReferenceExpression rowId;
    private final List<VariableReferenceExpression> outputVariables;

    @JsonCreator
    public DeleteNode(Optional<SourceLocation> sourceLocation, @JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="rowId") VariableReferenceExpression rowId, @JsonProperty(value="outputVariables") List<VariableReferenceExpression> outputVariables) {
        super(sourceLocation, id);
        this.source = Objects.requireNonNull(source, "source is null");
        this.rowId = Objects.requireNonNull(rowId, "rowId is null");
        this.outputVariables = ImmutableList.copyOf((Collection)Objects.requireNonNull(outputVariables, "outputVariables is null"));
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public VariableReferenceExpression getRowId() {
        return this.rowId;
    }

    @JsonProperty
    public List<VariableReferenceExpression> getOutputVariables() {
        return this.outputVariables;
    }

    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @Override
    public <R, C> R accept(InternalPlanVisitor<R, C> visitor, C context) {
        return visitor.visitDelete(this, context);
    }

    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new DeleteNode(this.getSourceLocation(), this.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), this.rowId, this.outputVariables);
    }
}

