/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.planPrinter;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.function.FunctionMetadataManager;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.InputReferenceExpression;
import com.facebook.presto.spi.relation.LambdaDefinitionExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.LiteralInterpreter;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class RowExpressionFormatter {
    private final FunctionMetadataManager functionMetadataManager;
    private final StandardFunctionResolution standardFunctionResolution;

    public RowExpressionFormatter(FunctionAndTypeManager functionAndTypeManager) {
        this.functionMetadataManager = Objects.requireNonNull(functionAndTypeManager, "function manager is null");
        this.standardFunctionResolution = new FunctionResolution(functionAndTypeManager);
    }

    public String formatRowExpression(ConnectorSession session, RowExpression expression) {
        return (String)expression.accept((RowExpressionVisitor)new Formatter(), (Object)Objects.requireNonNull(session, "session is null"));
    }

    private List<String> formatRowExpressions(ConnectorSession session, List<RowExpression> rowExpressions) {
        return rowExpressions.stream().map(rowExpression -> this.formatRowExpression(session, (RowExpression)rowExpression)).collect(Collectors.toList());
    }

    public class Formatter
    implements RowExpressionVisitor<String, ConnectorSession> {
        public String visitCall(CallExpression node, ConnectorSession session) {
            if (RowExpressionFormatter.this.standardFunctionResolution.isArithmeticFunction(node.getFunctionHandle()) || RowExpressionFormatter.this.standardFunctionResolution.isComparisonFunction(node.getFunctionHandle())) {
                String operation = ((OperatorType)RowExpressionFormatter.this.functionMetadataManager.getFunctionMetadata(node.getFunctionHandle()).getOperatorType().get()).getOperator();
                return String.join((CharSequence)(" " + operation + " "), (Iterable)RowExpressionFormatter.this.formatRowExpressions(session, node.getArguments()).stream().map(e -> "(" + e + ")").collect(ImmutableList.toImmutableList()));
            }
            if (RowExpressionFormatter.this.standardFunctionResolution.isCastFunction(node.getFunctionHandle())) {
                return String.format("CAST(%s AS %s)", RowExpressionFormatter.this.formatRowExpression(session, (RowExpression)node.getArguments().get(0)), node.getType().getDisplayName());
            }
            if (RowExpressionFormatter.this.standardFunctionResolution.isNegateFunction(node.getFunctionHandle())) {
                return "-(" + RowExpressionFormatter.this.formatRowExpression(session, (RowExpression)node.getArguments().get(0)) + ")";
            }
            if (RowExpressionFormatter.this.standardFunctionResolution.isSubscriptFunction(node.getFunctionHandle())) {
                return RowExpressionFormatter.this.formatRowExpression(session, (RowExpression)node.getArguments().get(0)) + "[" + RowExpressionFormatter.this.formatRowExpression(session, (RowExpression)node.getArguments().get(1)) + "]";
            }
            if (RowExpressionFormatter.this.standardFunctionResolution.isBetweenFunction(node.getFunctionHandle())) {
                List formattedExpressions = RowExpressionFormatter.this.formatRowExpressions(session, node.getArguments());
                return String.format("%s BETWEEN (%s) AND (%s)", formattedExpressions.get(0), formattedExpressions.get(1), formattedExpressions.get(2));
            }
            if (RowExpressionFormatter.this.standardFunctionResolution.isLikeFunction(node.getFunctionHandle())) {
                RowExpression value = (RowExpression)node.getArguments().get(0);
                RowExpression patternRowExpression = (RowExpression)node.getArguments().get(1);
                if (patternRowExpression instanceof CallExpression) {
                    CallExpression patternCallExpression = (CallExpression)patternRowExpression;
                    if (RowExpressionFormatter.this.standardFunctionResolution.isCastFunction(patternCallExpression.getFunctionHandle())) {
                        RowExpression pattern = (RowExpression)patternCallExpression.getArguments().get(0);
                        return String.format("%s LIKE %s", RowExpressionFormatter.this.formatRowExpression(session, value), RowExpressionFormatter.this.formatRowExpression(session, pattern));
                    }
                    if (RowExpressionFormatter.this.standardFunctionResolution.isLikePatternFunction(patternCallExpression.getFunctionHandle())) {
                        RowExpression pattern = (RowExpression)patternCallExpression.getArguments().get(0);
                        RowExpression escape = (RowExpression)patternCallExpression.getArguments().get(1);
                        return String.format("%s LIKE %s ESCAPE %s", RowExpressionFormatter.this.formatRowExpression(session, value), RowExpressionFormatter.this.formatRowExpression(session, pattern), RowExpressionFormatter.this.formatRowExpression(session, escape));
                    }
                }
                return String.format("%s LIKE %s", RowExpressionFormatter.this.formatRowExpression(session, value), RowExpressionFormatter.this.formatRowExpression(session, patternRowExpression));
            }
            FunctionMetadata metadata = RowExpressionFormatter.this.functionMetadataManager.getFunctionMetadata(node.getFunctionHandle());
            return node.getDisplayName() + (metadata.getVersion().hasVersion() ? ":" + metadata.getVersion() : "") + "(" + String.join((CharSequence)", ", RowExpressionFormatter.this.formatRowExpressions(session, node.getArguments())) + ")";
        }

        public String visitSpecialForm(SpecialFormExpression node, ConnectorSession session) {
            if (node.getForm().equals((Object)SpecialFormExpression.Form.AND) || node.getForm().equals((Object)SpecialFormExpression.Form.OR)) {
                return String.join((CharSequence)(" " + node.getForm() + " "), (Iterable)RowExpressionFormatter.this.formatRowExpressions(session, node.getArguments()).stream().map(e -> "(" + e + ")").collect(ImmutableList.toImmutableList()));
            }
            return node.getForm().name() + "(" + String.join((CharSequence)", ", RowExpressionFormatter.this.formatRowExpressions(session, node.getArguments())) + ")";
        }

        public String visitInputReference(InputReferenceExpression node, ConnectorSession session) {
            return node.toString();
        }

        public String visitLambda(LambdaDefinitionExpression node, ConnectorSession session) {
            return "(" + String.join((CharSequence)", ", node.getArguments()) + ") -> " + RowExpressionFormatter.this.formatRowExpression(session, node.getBody());
        }

        public String visitVariableReference(VariableReferenceExpression node, ConnectorSession session) {
            return node.getName();
        }

        public String visitConstant(ConstantExpression node, ConnectorSession session) {
            Object value = LiteralInterpreter.evaluate(session, node);
            if (value == null) {
                return String.valueOf(null);
            }
            Type type = node.getType();
            if (type.getJavaType() == Block.class) {
                Block block = (Block)value;
                return String.format("[Block: position count: %s; size: %s bytes]", block.getPositionCount(), block.getRetainedSizeInBytes());
            }
            String valueString = "'" + value.toString().replace("'", "''") + "'";
            if (VarbinaryType.isVarbinaryType((Type)type)) {
                return "X" + valueString;
            }
            return type.getTypeSignature().getBase().toUpperCase() + valueString;
        }
    }
}

