/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.relational;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.SourceLocation;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.InputReferenceExpression;
import com.facebook.presto.spi.relation.LambdaDefinitionExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public final class Expressions {
    private Expressions() {
    }

    private static Optional<SourceLocation> getFirstSourceLocation(List<RowExpression> expressions) {
        return expressions.stream().filter(x -> x.getSourceLocation().isPresent()).map(x -> x.getSourceLocation()).findFirst().orElse(Optional.empty());
    }

    public static ConstantExpression constant(Object value, Type type) {
        return Expressions.constant(Optional.empty(), value, type);
    }

    public static ConstantExpression constant(Optional<SourceLocation> sourceLocation, Object value, Type type) {
        return new ConstantExpression(sourceLocation, value, type);
    }

    public static ConstantExpression constantNull(Type type) {
        return Expressions.constantNull(Optional.empty(), type);
    }

    public static ConstantExpression constantNull(Optional<SourceLocation> sourceLocation, Type type) {
        return new ConstantExpression(sourceLocation, null, type);
    }

    public static boolean isNull(RowExpression expression) {
        return expression instanceof ConstantExpression && ((ConstantExpression)expression).isNull();
    }

    public static CallExpression call(String displayName, FunctionHandle functionHandle, Type returnType, RowExpression ... arguments) {
        return Expressions.call(displayName, functionHandle, returnType, Arrays.asList(arguments));
    }

    public static CallExpression call(Optional<SourceLocation> sourceLocation, String displayName, FunctionHandle functionHandle, Type returnType, RowExpression ... arguments) {
        return new CallExpression(displayName, functionHandle, returnType, Arrays.asList(arguments));
    }

    public static CallExpression call(String displayName, FunctionHandle functionHandle, Type returnType, List<RowExpression> arguments) {
        return new CallExpression(Expressions.getFirstSourceLocation(arguments), displayName, functionHandle, returnType, arguments);
    }

    public static CallExpression call(Optional<SourceLocation> sourceLocation, String displayName, FunctionHandle functionHandle, Type returnType, List<RowExpression> arguments) {
        return new CallExpression(sourceLocation, displayName, functionHandle, returnType, arguments);
    }

    public static CallExpression call(FunctionAndTypeManager functionAndTypeManager, String name, Type returnType, RowExpression ... arguments) {
        return Expressions.call(functionAndTypeManager, name, returnType, (List<RowExpression>)ImmutableList.copyOf((Object[])arguments));
    }

    public static CallExpression call(FunctionAndTypeManager functionAndTypeManager, String name, Type returnType, List<RowExpression> arguments) {
        FunctionHandle functionHandle = functionAndTypeManager.lookupFunction(name, TypeSignatureProvider.fromTypes((List)arguments.stream().map(RowExpression::getType).collect(ImmutableList.toImmutableList())));
        return Expressions.call(name, functionHandle, returnType, arguments);
    }

    public static InputReferenceExpression field(Optional<SourceLocation> sourceLocation, int field, Type type) {
        return new InputReferenceExpression(sourceLocation, field, type);
    }

    public static InputReferenceExpression field(int field, Type type) {
        return new InputReferenceExpression(Optional.empty(), field, type);
    }

    public static SpecialFormExpression specialForm(SpecialFormExpression.Form form, Type returnType, RowExpression ... arguments) {
        return Expressions.specialForm(form, returnType, (List<RowExpression>)ImmutableList.copyOf((Object[])arguments));
    }

    public static SpecialFormExpression specialForm(Optional<SourceLocation> sourceLocation, SpecialFormExpression.Form form, Type returnType, RowExpression ... arguments) {
        return Expressions.specialForm(sourceLocation, form, returnType, (List<RowExpression>)ImmutableList.copyOf((Object[])arguments));
    }

    public static SpecialFormExpression specialForm(SpecialFormExpression.Form form, Type returnType, List<RowExpression> arguments) {
        return Expressions.specialForm(Expressions.getFirstSourceLocation(arguments), form, returnType, arguments);
    }

    public static SpecialFormExpression specialForm(Optional<SourceLocation> sourceLocation, SpecialFormExpression.Form form, Type returnType, List<RowExpression> arguments) {
        return new SpecialFormExpression(sourceLocation, form, returnType, arguments);
    }

    public static Set<RowExpression> uniqueSubExpressions(RowExpression expression) {
        return ImmutableSet.copyOf(Expressions.subExpressions((Iterable<RowExpression>)ImmutableList.of((Object)expression)));
    }

    public static List<RowExpression> subExpressions(RowExpression expression) {
        return Expressions.subExpressions((Iterable<RowExpression>)ImmutableList.of((Object)expression));
    }

    public static List<RowExpression> subExpressions(Iterable<RowExpression> expressions) {
        final ImmutableList.Builder builder = ImmutableList.builder();
        for (RowExpression expression : expressions) {
            expression.accept((RowExpressionVisitor)new RowExpressionVisitor<Void, Void>(){

                public Void visitCall(CallExpression call, Void context) {
                    builder.add((Object)call);
                    for (RowExpression argument : call.getArguments()) {
                        argument.accept((RowExpressionVisitor)this, (Object)context);
                    }
                    return null;
                }

                public Void visitInputReference(InputReferenceExpression reference, Void context) {
                    builder.add((Object)reference);
                    return null;
                }

                public Void visitConstant(ConstantExpression literal, Void context) {
                    builder.add((Object)literal);
                    return null;
                }

                public Void visitLambda(LambdaDefinitionExpression lambda, Void context) {
                    builder.add((Object)lambda);
                    lambda.getBody().accept((RowExpressionVisitor)this, (Object)context);
                    return null;
                }

                public Void visitVariableReference(VariableReferenceExpression reference, Void context) {
                    builder.add((Object)reference);
                    return null;
                }

                public Void visitSpecialForm(SpecialFormExpression specialForm, Void context) {
                    builder.add((Object)specialForm);
                    for (RowExpression argument : specialForm.getArguments()) {
                        argument.accept((RowExpressionVisitor)this, (Object)context);
                    }
                    return null;
                }
            }, null);
        }
        return builder.build();
    }

    public static VariableReferenceExpression variable(String name, Type type) {
        return Expressions.variable(Optional.empty(), name, type);
    }

    public static VariableReferenceExpression variable(Optional<SourceLocation> sourceLocation, String name, Type type) {
        return new VariableReferenceExpression(sourceLocation, name, type);
    }
}

