/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.rewrite;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.sql.analyzer.QueryExplainer;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.rewrite.DescribeInputRewrite;
import com.facebook.presto.sql.rewrite.DescribeOutputRewrite;
import com.facebook.presto.sql.rewrite.ExplainRewrite;
import com.facebook.presto.sql.rewrite.MaterializedViewOptimizationRewrite;
import com.facebook.presto.sql.rewrite.ShowQueriesRewrite;
import com.facebook.presto.sql.rewrite.ShowStatsRewrite;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.Parameter;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class StatementRewrite {
    private static final List<Rewrite> REWRITES = ImmutableList.of((Object)new DescribeInputRewrite(), (Object)new DescribeOutputRewrite(), (Object)new ShowQueriesRewrite(), (Object)new ShowStatsRewrite(), (Object)new ExplainRewrite(), (Object)new MaterializedViewOptimizationRewrite());

    private StatementRewrite() {
    }

    public static Statement rewrite(Session session, Metadata metadata, SqlParser parser, Optional<QueryExplainer> queryExplainer, Statement node, List<Expression> parameters, Map<NodeRef<Parameter>, Expression> parameterLookup, AccessControl accessControl, WarningCollector warningCollector) {
        for (Rewrite rewrite : REWRITES) {
            node = Objects.requireNonNull(rewrite.rewrite(session, metadata, parser, queryExplainer, node, parameters, parameterLookup, accessControl, warningCollector), "Statement rewrite returned null");
        }
        return node;
    }

    static interface Rewrite {
        public Statement rewrite(Session var1, Metadata var2, SqlParser var3, Optional<QueryExplainer> var4, Statement var5, List<Expression> var6, Map<NodeRef<Parameter>, Expression> var7, AccessControl var8, WarningCollector var9);
    }
}

