/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.testing;

import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorMaterializedViewDefinition;
import com.facebook.presto.spi.ConnectorNewTableLayout;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ConnectorViewDefinition;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.MaterializedViewStatus;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.ViewNotFoundException;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorOutputMetadata;
import com.facebook.presto.spi.security.PrestoPrincipal;
import com.facebook.presto.spi.security.Privilege;
import com.facebook.presto.spi.statistics.ComputedStatistics;
import com.facebook.presto.testing.TestingHandle;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class TestingMetadata
implements ConnectorMetadata {
    private final Map<SchemaTableName, ConnectorTableMetadata> tables = new ConcurrentHashMap<SchemaTableName, ConnectorTableMetadata>();
    private final Map<SchemaTableName, String> views = new ConcurrentHashMap<SchemaTableName, String>();
    private final Map<SchemaTableName, ConnectorMaterializedViewDefinition> materializedViews = new ConcurrentHashMap<SchemaTableName, ConnectorMaterializedViewDefinition>();

    public List<String> listSchemaNames(ConnectorSession session) {
        HashSet<String> schemaNames = new HashSet<String>();
        for (SchemaTableName schemaTableName : this.tables.keySet()) {
            schemaNames.add(schemaTableName.getSchemaName());
        }
        return ImmutableList.copyOf(schemaNames);
    }

    public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        Objects.requireNonNull(tableName, "tableName is null");
        if (!this.tables.containsKey(tableName)) {
            return null;
        }
        return new TestingTableHandle(tableName);
    }

    public ConnectorTableHandle getTableHandleForStatisticsCollection(ConnectorSession session, SchemaTableName tableName, Map<String, Object> analyzeProperties) {
        return this.getTableHandle(session, tableName);
    }

    public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle table, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        return ImmutableList.of((Object)new ConnectorTableLayoutResult(new ConnectorTableLayout((ConnectorTableLayoutHandle)TestingHandle.INSTANCE), TupleDomain.all()));
    }

    public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle handle) {
        return new ConnectorTableLayout((ConnectorTableLayoutHandle)TestingHandle.INSTANCE);
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        Objects.requireNonNull(tableHandle, "tableHandle is null");
        SchemaTableName tableName = TestingMetadata.getTableName(tableHandle);
        ConnectorTableMetadata tableMetadata = this.tables.get(tableName);
        Preconditions.checkArgument((tableMetadata != null ? 1 : 0) != 0, (String)"Table %s does not exist", (Object)tableName);
        return tableMetadata;
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        int index = 0;
        for (ColumnMetadata columnMetadata : this.getTableMetadata(session, tableHandle).getColumns()) {
            builder.put((Object)columnMetadata.getName(), (Object)new TestingColumnHandle(columnMetadata.getName(), index, columnMetadata.getType()));
            ++index;
        }
        return builder.build();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        ImmutableMap.Builder tableColumns = ImmutableMap.builder();
        for (SchemaTableName tableName : this.listTables(session, prefix.getSchemaName())) {
            ImmutableList.Builder columns = ImmutableList.builder();
            for (ColumnMetadata column : this.tables.get(tableName).getColumns()) {
                columns.add((Object)new ColumnMetadata(column.getName(), column.getType()));
            }
            tableColumns.put((Object)tableName, (Object)columns.build());
        }
        return tableColumns.build();
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        SchemaTableName tableName = TestingMetadata.getTableName(tableHandle);
        int columnIndex = ((TestingColumnHandle)columnHandle).getOrdinalPosition();
        return (ColumnMetadata)this.tables.get(tableName).getColumns().get(columnIndex);
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (SchemaTableName tableName : this.tables.keySet()) {
            if (!schemaName.map(tableName.getSchemaName()::equals).orElse(true).booleanValue()) continue;
            builder.add((Object)tableName);
        }
        return builder.build();
    }

    public void renameTable(ConnectorSession session, ConnectorTableHandle tableHandle, SchemaTableName newTableName) {
        ConnectorTableMetadata table = this.getTableMetadata(session, tableHandle);
        if (this.tables.putIfAbsent(newTableName, table) != null) {
            throw new IllegalArgumentException("Target table already exists: " + newTableName);
        }
        this.tables.remove(table.getTable(), table);
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        ConnectorTableMetadata existingTable = this.tables.putIfAbsent(tableMetadata.getTable(), tableMetadata);
        if (existingTable != null && !ignoreExisting) {
            throw new IllegalArgumentException("Target table already exists: " + tableMetadata.getTable());
        }
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        this.tables.remove(TestingMetadata.getTableName(tableHandle));
    }

    public void createView(ConnectorSession session, ConnectorTableMetadata viewMetadata, String viewData, boolean replace) {
        SchemaTableName viewName = viewMetadata.getTable();
        if (replace) {
            this.views.put(viewName, viewData);
        } else if (this.views.putIfAbsent(viewName, viewData) != null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "View already exists: " + viewName);
        }
    }

    public void dropView(ConnectorSession session, SchemaTableName viewName) {
        if (this.views.remove(viewName) == null) {
            throw new ViewNotFoundException(viewName);
        }
    }

    public List<SchemaTableName> listViews(ConnectorSession session, Optional<String> schemaName) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (SchemaTableName viewName : this.views.keySet()) {
            if (!schemaName.map(viewName.getSchemaName()::equals).orElse(true).booleanValue()) continue;
            builder.add((Object)viewName);
        }
        return builder.build();
    }

    public Map<SchemaTableName, ConnectorViewDefinition> getViews(ConnectorSession session, SchemaTablePrefix prefix) {
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (Map.Entry<SchemaTableName, String> entry : this.views.entrySet()) {
            if (!prefix.matches(entry.getKey())) continue;
            map.put((Object)entry.getKey(), (Object)new ConnectorViewDefinition(entry.getKey(), Optional.empty(), entry.getValue()));
        }
        return map.build();
    }

    public ConnectorOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorNewTableLayout> layout) {
        this.createTable(session, tableMetadata, false);
        return TestingHandle.INSTANCE;
    }

    public Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        return Optional.empty();
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return TestingHandle.INSTANCE;
    }

    public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        return Optional.empty();
    }

    public void addColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnMetadata column) {
        ConnectorTableMetadata tableMetadata = this.getTableMetadata(session, tableHandle);
        SchemaTableName tableName = TestingMetadata.getTableName(tableHandle);
        ImmutableList.Builder columns = ImmutableList.builder();
        columns.addAll((Iterable)tableMetadata.getColumns());
        columns.add((Object)column);
        this.tables.put(tableName, new ConnectorTableMetadata(tableName, (List)columns.build(), tableMetadata.getProperties(), tableMetadata.getComment()));
    }

    public void renameColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle source, String target) {
        ConnectorTableMetadata tableMetadata = this.getTableMetadata(session, tableHandle);
        SchemaTableName tableName = TestingMetadata.getTableName(tableHandle);
        ColumnMetadata columnMetadata = this.getColumnMetadata(session, tableHandle, source);
        ArrayList<ColumnMetadata> columns = new ArrayList<ColumnMetadata>(tableMetadata.getColumns());
        columns.set(columns.indexOf(columnMetadata), new ColumnMetadata(target, columnMetadata.getType(), columnMetadata.getComment(), columnMetadata.isHidden()));
        this.tables.put(tableName, new ConnectorTableMetadata(tableName, (List)ImmutableList.copyOf(columns), tableMetadata.getProperties(), tableMetadata.getComment()));
    }

    public void grantTablePrivileges(ConnectorSession session, SchemaTableName tableName, Set<Privilege> privileges, PrestoPrincipal grantee, boolean grantOption) {
    }

    public void revokeTablePrivileges(ConnectorSession session, SchemaTableName tableName, Set<Privilege> privileges, PrestoPrincipal grantee, boolean grantOption) {
    }

    public void clear() {
        this.views.clear();
        this.tables.clear();
    }

    private static SchemaTableName getTableName(ConnectorTableHandle tableHandle) {
        Objects.requireNonNull(tableHandle, "tableHandle is null");
        Preconditions.checkArgument((boolean)(tableHandle instanceof TestingTableHandle), (Object)"tableHandle is not an instance of TestingTableHandle");
        TestingTableHandle testingTableHandle = (TestingTableHandle)tableHandle;
        return testingTableHandle.getTableName();
    }

    public void dropMaterializedView(ConnectorSession session, SchemaTableName viewName) {
        this.materializedViews.remove(viewName);
    }

    public void createMaterializedView(ConnectorSession session, ConnectorTableMetadata viewMetadata, ConnectorMaterializedViewDefinition viewDefinition, boolean ignoreExisting) {
        SchemaTableName viewName = new SchemaTableName(viewDefinition.getSchema(), viewDefinition.getTable());
        this.tables.put(viewName, new ConnectorTableMetadata(viewName, (List)ImmutableList.of()));
        this.materializedViews.put(viewName, viewDefinition);
    }

    public Optional<ConnectorMaterializedViewDefinition> getMaterializedView(ConnectorSession session, SchemaTableName viewName) {
        return Optional.ofNullable(this.materializedViews.get(viewName));
    }

    public MaterializedViewStatus getMaterializedViewStatus(ConnectorSession session, SchemaTableName materializedViewName) {
        return new MaterializedViewStatus(MaterializedViewStatus.MaterializedViewState.FULLY_MATERIALIZED);
    }

    public Optional<List<SchemaTableName>> getReferencedMaterializedViews(ConnectorSession session, SchemaTableName tableName) {
        List referencedMaterializedViews = this.materializedViews.entrySet().stream().filter(entry -> ((ConnectorMaterializedViewDefinition)entry.getValue()).getBaseTables().contains(tableName)).map(Map.Entry::getKey).collect(Collectors.toList());
        return referencedMaterializedViews.isEmpty() ? Optional.empty() : Optional.of(referencedMaterializedViews);
    }

    public static class TestingColumnHandle
    implements ColumnHandle {
        private final String name;
        private final OptionalInt ordinalPosition;
        private final Optional<Type> type;

        public TestingColumnHandle(String name) {
            this(name, OptionalInt.empty(), Optional.empty());
        }

        public TestingColumnHandle(String name, int ordinalPosition, Type type) {
            this(name, OptionalInt.of(ordinalPosition), Optional.of(type));
        }

        @JsonCreator
        public TestingColumnHandle(@JsonProperty(value="name") String name, @JsonProperty(value="ordinalPosition") OptionalInt ordinalPosition, @JsonProperty(value="type") Optional<Type> type) {
            this.name = Objects.requireNonNull(name, "name is null");
            this.ordinalPosition = Objects.requireNonNull(ordinalPosition, "ordinalPosition is null");
            this.type = Objects.requireNonNull(type, "type is null");
        }

        @JsonProperty
        public String getName() {
            return this.name;
        }

        public int getOrdinalPosition() {
            return this.ordinalPosition.orElseThrow(() -> new UnsupportedOperationException("Testing handle was created without ordinal position"));
        }

        public Type getType() {
            return this.type.orElseThrow(() -> new UnsupportedOperationException("Testing handle was created without type"));
        }

        @JsonProperty(value="ordinalPosition")
        public OptionalInt getJsonOrdinalPosition() {
            return this.ordinalPosition;
        }

        @JsonProperty(value="type")
        public Optional<Type> getJsonType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestingColumnHandle that = (TestingColumnHandle)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.ordinalPosition, that.ordinalPosition) && Objects.equals(this.type, that.type);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.ordinalPosition, this.type);
        }
    }

    public static class TestingTableHandle
    implements ConnectorTableHandle {
        private final SchemaTableName tableName;

        public TestingTableHandle() {
            this(new SchemaTableName("test-schema", "test-table"));
        }

        @JsonCreator
        public TestingTableHandle(@JsonProperty(value="tableName") SchemaTableName schemaTableName) {
            this.tableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        }

        @JsonProperty
        public SchemaTableName getTableName() {
            return this.tableName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TestingTableHandle)) {
                return false;
            }
            TestingTableHandle other = (TestingTableHandle)o;
            return Objects.equals(this.tableName, other.tableName);
        }

        public int hashCode() {
            return Objects.hash(this.tableName);
        }
    }
}

