/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tracing;

import com.facebook.airlift.configuration.Config;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;

public class TracingConfig {
    private String tracerType = "noop";
    private DistributedTracingMode tracingMode = DistributedTracingMode.NO_TRACE;
    private boolean enableDistributedTracing;

    public String getTracerType() {
        return this.tracerType;
    }

    @Config(value="tracing.tracer-type")
    public TracingConfig setTracerType(String tracerType) {
        this.tracerType = tracerType;
        return this;
    }

    public boolean getEnableDistributedTracing() {
        return this.enableDistributedTracing;
    }

    @Config(value="tracing.enable-distributed-tracing")
    public TracingConfig setEnableDistributedTracing(boolean enableDistributedTracing) {
        this.enableDistributedTracing = enableDistributedTracing;
        return this;
    }

    public DistributedTracingMode getDistributedTracingMode() {
        return this.tracingMode;
    }

    @Config(value="tracing.distributed-tracing-mode")
    public TracingConfig setDistributedTracingMode(String tracingMode) {
        if (tracingMode.equalsIgnoreCase(DistributedTracingMode.SAMPLE_BASED.name())) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.DISTRIBUTED_TRACING_ERROR, "SAMPLE_BASED Tracing Mode is currently not supported.");
        }
        this.tracingMode = DistributedTracingMode.valueOf(tracingMode.toUpperCase());
        return this;
    }

    public static enum DistributedTracingMode {
        NO_TRACE,
        ALWAYS_TRACE,
        SAMPLE_BASED;

    }

    public static class TracerType {
        public static final String NOOP = "noop";
        public static final String SIMPLE = "simple";
    }
}

