/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.testng.annotations.Test;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@Fork(value=3)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkBlocks {
    @Benchmark
    public Block benchmarkCopyPositions(BenchmarkData data) {
        return this.copyPositions(data.dataBlock, data.positions, data.positionCount);
    }

    private Block copyPositions(Block block, int[] positions, int positionCount) {
        return block.copyPositions(positions, 0, positionCount);
    }

    @Test
    public static void verifyCopyPositions() throws Exception {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        BenchmarkBlocks benchmarkSelectiveStreamReaders = new BenchmarkBlocks();
        benchmarkSelectiveStreamReaders.copyPositions(data.dataBlock, data.positions, data.positionCount);
    }

    @Benchmark
    public long benchmarkGetPositionsSizeInBytes(BenchmarkData data) {
        return data.dataBlock.getPositionsSizeInBytes(data.usedPositions, data.positionCount);
    }

    @Test
    public static void verifyGetPositionsSizeInBytes() {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        new BenchmarkBlocks().benchmarkGetPositionsSizeInBytes(data);
    }

    @Benchmark
    public long benchmarkGetPositionsThenGetSizeInBytes(BenchmarkData data) {
        return data.dataBlock.getPositions(data.positions, 0, data.positionCount).getSizeInBytes();
    }

    @Test
    public static void verifyGetPositionsThenGetSizeInBytes() {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        new BenchmarkBlocks().benchmarkGetPositionsThenGetSizeInBytes(data);
    }

    public static void main(String[] args) throws Throwable {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkBlocks.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        private static final int POSITION_COUNT = 1024;
        private static final Random random = new Random(0L);
        @Param(value={"BOOLEAN", "TINYINT", "SMALLINT", "INTEGER", "BIGINT", "LONG_DECIMAL", "VARCHAR", "ARRAY(BIGINT)", "ARRAY(VARCHAR)", "ARRAY(ARRAY(BIGINT))", "MAP(BIGINT,BIGINT)", "MAP(BIGINT,MAP(BIGINT,VARCHAR))", "ROW(BIGINT,BIGINT,BIGINT)", "ROW(VARCHAR,VARCHAR,VARCHAR)", "ROW(ARRAY(BIGINT),ARRAY(VARCHAR))"})
        private String typeSignature = "BIGINT";
        @Param(value={"0.0f", "0.5f"})
        private float primitiveNullRate;
        @Param(value={"0.0f", "0.25f", "0.5f", "0.75f"})
        private float nestedNullRate;
        @Param(value={"true", "false"})
        private boolean useBlockView;
        @Param(value={"NONE", "DICTIONARY", "RUN_LENGTH"})
        private String encodings = "NONE";
        @Param(value={"0", "128", "512", "1024"})
        private int positionCount = 128;
        private Type type;
        private Block dataBlock;
        private int[] positions;
        private boolean[] usedPositions;

        @Setup
        public void setup() {
            this.type = FunctionAndTypeManager.createTestFunctionAndTypeManager().getType(TypeSignature.parseTypeSignature((String)this.typeSignature));
            List<BlockAssertions.Encoding> encodingWrappings = this.createWrappings();
            this.dataBlock = BlockAssertions.createRandomBlockForType(this.type, 1024, this.primitiveNullRate, this.nestedNullRate, this.useBlockView, encodingWrappings);
            this.populatePositions();
        }

        private void populatePositions() {
            HashSet<Integer> set = new HashSet<Integer>();
            while (set.size() < this.positionCount) {
                set.add(random.nextInt(1024));
            }
            this.positions = Ints.toArray(set);
            Arrays.sort(this.positions);
            this.usedPositions = new boolean[this.dataBlock.getPositionCount()];
            for (int position : this.positions) {
                this.usedPositions[position] = true;
            }
        }

        private List<BlockAssertions.Encoding> createWrappings() {
            String[] encodingWrappings;
            ArrayList<BlockAssertions.Encoding> wrappingList = new ArrayList<BlockAssertions.Encoding>();
            String[] stringArray = encodingWrappings = this.encodings.split(",");
            int n = stringArray.length;
            block10: for (int i = 0; i < n; ++i) {
                String wrapping;
                switch (wrapping = stringArray[i]) {
                    case "NONE": {
                        continue block10;
                    }
                    case "DICTIONARY": {
                        wrappingList.add(BlockAssertions.Encoding.DICTIONARY);
                        continue block10;
                    }
                    case "RUN_LENGTH": {
                        wrappingList.add(BlockAssertions.Encoding.RUN_LENGTH);
                        continue block10;
                    }
                    default: {
                        throw new UnsupportedOperationException("Encoding type not supported: " + wrapping);
                    }
                }
            }
            return wrappingList;
        }
    }
}

