/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.Session;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.cost.ConnectorFilterStatsCalculatorService;
import com.facebook.presto.cost.FilterStatsCalculator;
import com.facebook.presto.cost.ScalarStatsCalculator;
import com.facebook.presto.cost.StatsNormalizer;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.TestingColumnHandle;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.statistics.ColumnStatistics;
import com.facebook.presto.spi.statistics.DoubleRange;
import com.facebook.presto.spi.statistics.Estimate;
import com.facebook.presto.spi.statistics.TableStatistics;
import com.facebook.presto.sql.TestingRowExpressionTranslator;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.testing.TestingSession;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestConnectorFilterStatsCalculatorService {
    private Session session;
    private ConnectorFilterStatsCalculatorService statsCalculatorService;
    private ColumnHandle xColumn = new TestingColumnHandle("x");
    private ColumnStatistics xStats;
    private TableStatistics originalTableStatistics;
    private TableStatistics originalTableStatisticsWithoutTotalSize;
    private TableStatistics zeroTableStatistics;
    private TypeProvider standardTypes;
    private TestingRowExpressionTranslator translator;

    @BeforeClass
    public void setUp() {
        this.session = TestingSession.testSessionBuilder().build();
        MetadataManager metadata = MetadataManager.createTestMetadataManager();
        FilterStatsCalculator statsCalculator = new FilterStatsCalculator((Metadata)metadata, new ScalarStatsCalculator((Metadata)metadata), new StatsNormalizer());
        this.statsCalculatorService = new ConnectorFilterStatsCalculatorService(statsCalculator);
        this.xStats = ColumnStatistics.builder().setDistinctValuesCount(Estimate.of((double)40.0)).setRange(new DoubleRange(-10.0, 10.0)).setNullsFraction(Estimate.of((double)0.25)).build();
        this.zeroTableStatistics = TableStatistics.builder().setRowCount(Estimate.zero()).setTotalSize(Estimate.zero()).build();
        this.originalTableStatistics = TableStatistics.builder().setRowCount(Estimate.of((double)100.0)).setTotalSize(Estimate.of((double)800.0)).setColumnStatistics(this.xColumn, this.xStats).build();
        this.originalTableStatisticsWithoutTotalSize = TableStatistics.builder().setRowCount(Estimate.of((double)100.0)).setColumnStatistics(this.xColumn, this.xStats).build();
        this.standardTypes = TypeProvider.fromVariables((Collection)ImmutableList.builder().add((Object)new VariableReferenceExpression(Optional.empty(), "x", (Type)DoubleType.DOUBLE)).build());
        this.translator = new TestingRowExpressionTranslator((Metadata)MetadataManager.createTestMetadataManager());
    }

    @Test
    public void testTableStatisticsAfterFilter() {
        this.assertPredicate("true", this.zeroTableStatistics, this.zeroTableStatistics);
        this.assertPredicate("x < 3e0", this.zeroTableStatistics, this.zeroTableStatistics);
        this.assertPredicate("false", this.zeroTableStatistics, this.zeroTableStatistics);
        this.assertPredicate("true", TableStatistics.empty(), TableStatistics.empty());
        this.assertPredicate("false", TableStatistics.empty(), TableStatistics.builder().setRowCount(Estimate.zero()).setTotalSize(Estimate.zero()).build());
        TableStatistics filteredToZeroStatistics = TableStatistics.builder().setRowCount(Estimate.zero()).setTotalSize(Estimate.zero()).setColumnStatistics(this.xColumn, new ColumnStatistics(Estimate.of((double)1.0), Estimate.zero(), Estimate.zero(), Optional.empty())).build();
        this.assertPredicate("false", this.originalTableStatistics, filteredToZeroStatistics);
        TableStatistics filteredStatistics = TableStatistics.builder().setRowCount(Estimate.of((double)37.5)).setTotalSize(Estimate.of((double)300.0)).setColumnStatistics(this.xColumn, new ColumnStatistics(Estimate.zero(), Estimate.of((double)20.0), Estimate.unknown(), Optional.of(new DoubleRange(-10.0, 0.0)))).build();
        this.assertPredicate("x < 0", this.originalTableStatistics, filteredStatistics);
        TableStatistics filteredStatisticsWithoutTotalSize = TableStatistics.builder().setRowCount(Estimate.of((double)37.5)).setColumnStatistics(this.xColumn, new ColumnStatistics(Estimate.zero(), Estimate.of((double)20.0), Estimate.unknown(), Optional.of(new DoubleRange(-10.0, 0.0)))).build();
        this.assertPredicate("x < 0", this.originalTableStatisticsWithoutTotalSize, filteredStatisticsWithoutTotalSize);
    }

    private void assertPredicate(String filterExpression, TableStatistics tableStatistics, TableStatistics expectedStatistics) {
        this.assertPredicate(PlanBuilder.expression(filterExpression), tableStatistics, expectedStatistics);
    }

    private void assertPredicate(Expression filterExpression, TableStatistics tableStatistics, TableStatistics expectedStatistics) {
        RowExpression predicate = this.translator.translateAndOptimize(filterExpression, this.standardTypes);
        TableStatistics filteredStatistics = this.statsCalculatorService.filterStats(tableStatistics, predicate, this.session.toConnectorSession(), (Map)ImmutableMap.of((Object)this.xColumn, (Object)"x"), (Map)ImmutableMap.of((Object)"x", (Object)DoubleType.DOUBLE));
        Assert.assertEquals((Object)filteredStatistics, (Object)expectedStatistics);
    }
}

