/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.Session;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.cost.CachingCostProvider;
import com.facebook.presto.cost.CachingStatsProvider;
import com.facebook.presto.cost.CostCalculator;
import com.facebook.presto.cost.CostCalculatorUsingExchanges;
import com.facebook.presto.cost.CostCalculatorWithEstimatedExchanges;
import com.facebook.presto.cost.CostProvider;
import com.facebook.presto.cost.PlanCostEstimate;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.StatsAndCosts;
import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.cost.TaskCountEstimator;
import com.facebook.presto.cost.VariableStatsEstimate;
import com.facebook.presto.dispatcher.NoOpQueryManager;
import com.facebook.presto.execution.NodeTaskMap;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.execution.scheduler.LegacyNetworkTopology;
import com.facebook.presto.execution.scheduler.NetworkTopology;
import com.facebook.presto.execution.scheduler.NodeScheduler;
import com.facebook.presto.execution.scheduler.NodeSchedulerConfig;
import com.facebook.presto.execution.scheduler.nodeSelection.NodeSelectionStats;
import com.facebook.presto.execution.scheduler.nodeSelection.SimpleTtlNodeSelectorConfig;
import com.facebook.presto.metadata.CatalogManager;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.InMemoryNodeManager;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.plan.UnionNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.spi.security.AllowAllAccessControl;
import com.facebook.presto.sql.TestingRowExpressionTranslator;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.NodePartitioningManager;
import com.facebook.presto.sql.planner.PartitioningProviderManager;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.PlanFragmenter;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.planner.optimizations.AggregationNodeUtils;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.tpch.TpchColumnHandle;
import com.facebook.presto.tpch.TpchTableHandle;
import com.facebook.presto.tpch.TpchTableLayoutHandle;
import com.facebook.presto.tpch.TpchTransactionHandle;
import com.facebook.presto.transaction.InMemoryTransactionManager;
import com.facebook.presto.transaction.TransactionBuilder;
import com.facebook.presto.transaction.TransactionManager;
import com.facebook.presto.ttl.nodettlfetchermanagers.NodeTtlFetcherManager;
import com.facebook.presto.ttl.nodettlfetchermanagers.ThrowingNodeTtlFetcherManager;
import com.facebook.presto.util.FinalizerService;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestCostCalculator {
    private static final int NUMBER_OF_NODES = 10;
    private static final double AVERAGE_ROW_SIZE = 8.0;
    private static final double IS_NULL_OVERHEAD = 1.125;
    private static final double OFFSET_AND_IS_NULL_OVERHEAD = 1.625;
    private CostCalculator costCalculatorUsingExchanges;
    private CostCalculator costCalculatorWithEstimatedExchanges;
    private PlanFragmenter planFragmenter;
    private Session session;
    private MetadataManager metadata;
    private TransactionManager transactionManager;
    private FinalizerService finalizerService;
    private NodeScheduler nodeScheduler;
    private NodePartitioningManager nodePartitioningManager;
    private TestingRowExpressionTranslator translator;

    @BeforeClass
    public void setUp() {
        TaskCountEstimator taskCountEstimator = new TaskCountEstimator(() -> 10);
        this.costCalculatorUsingExchanges = new CostCalculatorUsingExchanges(taskCountEstimator);
        this.costCalculatorWithEstimatedExchanges = new CostCalculatorWithEstimatedExchanges(this.costCalculatorUsingExchanges, taskCountEstimator);
        this.session = TestingSession.testSessionBuilder().setCatalog("tpch").build();
        CatalogManager catalogManager = new CatalogManager();
        catalogManager.registerCatalog(TestingSession.createBogusTestingCatalog((String)"tpch"));
        this.transactionManager = InMemoryTransactionManager.createTestTransactionManager((CatalogManager)catalogManager);
        this.metadata = MetadataManager.createTestMetadataManager((TransactionManager)this.transactionManager, (FeaturesConfig)new FeaturesConfig());
        this.finalizerService = new FinalizerService();
        this.finalizerService.start();
        this.nodeScheduler = new NodeScheduler((NetworkTopology)new LegacyNetworkTopology(), (InternalNodeManager)new InMemoryNodeManager(), new NodeSelectionStats(), new NodeSchedulerConfig().setIncludeCoordinator(true), new NodeTaskMap(this.finalizerService), (NodeTtlFetcherManager)new ThrowingNodeTtlFetcherManager(), (QueryManager)new NoOpQueryManager(), new SimpleTtlNodeSelectorConfig());
        PartitioningProviderManager partitioningProviderManager = new PartitioningProviderManager();
        this.nodePartitioningManager = new NodePartitioningManager(this.nodeScheduler, partitioningProviderManager, new NodeSelectionStats());
        this.planFragmenter = new PlanFragmenter((Metadata)this.metadata, this.nodePartitioningManager, new QueryManagerConfig(), new SqlParser(), new FeaturesConfig());
        this.translator = new TestingRowExpressionTranslator();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.costCalculatorUsingExchanges = null;
        this.costCalculatorWithEstimatedExchanges = null;
        this.planFragmenter = null;
        this.session = null;
        this.transactionManager = null;
        this.metadata = null;
        this.finalizerService.destroy();
        this.finalizerService = null;
        this.nodeScheduler.stop();
        this.nodeScheduler = null;
        this.nodePartitioningManager = null;
    }

    @Test
    public void testTableScan() {
        TableScanNode tableScan = this.tableScan("ts", "orderkey");
        ImmutableMap types = ImmutableMap.of((Object)"orderkey", (Object)BigintType.BIGINT);
        this.assertCost((PlanNode)tableScan, (Map<String, PlanCostEstimate>)ImmutableMap.of(), (Map<String, PlanNodeStatsEstimate>)ImmutableMap.of((Object)"ts", (Object)TestCostCalculator.statsEstimate((PlanNode)tableScan, 1000.0))).cpu(1125.0).memory(0.0).network(0.0);
        this.assertCostEstimatedExchanges((PlanNode)tableScan, (Map<String, PlanCostEstimate>)ImmutableMap.of(), (Map<String, PlanNodeStatsEstimate>)ImmutableMap.of((Object)"ts", (Object)TestCostCalculator.statsEstimate((PlanNode)tableScan, 1000.0))).cpu(1125.0).memory(0.0).network(0.0);
        this.assertCostSingleStageFragmentedPlan((PlanNode)tableScan, (Map<String, PlanCostEstimate>)ImmutableMap.of(), (Map<String, PlanNodeStatsEstimate>)ImmutableMap.of((Object)"ts", (Object)TestCostCalculator.statsEstimate((PlanNode)tableScan, 1000.0)), (Map<String, Type>)types).cpu(1125.0).memory(0.0).network(0.0);
        this.assertCostHasUnknownComponentsForUnknownStats((PlanNode)tableScan);
    }

    @Test
    public void testProject() {
        TableScanNode tableScan = this.tableScan("ts", "orderkey");
        RowExpression cast = this.translator.translate((Expression)new Cast((Expression)new SymbolReference("orderkey"), "VARCHAR"), TypeProvider.viewOf((Map)ImmutableMap.of((Object)"orderkey", (Object)BigintType.BIGINT)));
        PlanNode project = this.project("project", (PlanNode)tableScan, new VariableReferenceExpression(Optional.empty(), "string", (Type)VarcharType.VARCHAR), cast);
        ImmutableMap costs = ImmutableMap.of((Object)"ts", (Object)TestCostCalculator.cpuCost(1000.0));
        ImmutableMap stats = ImmutableMap.of((Object)"project", (Object)TestCostCalculator.statsEstimate(project, 4000.0), (Object)"ts", (Object)TestCostCalculator.statsEstimate((PlanNode)tableScan, 1000.0));
        ImmutableMap types = ImmutableMap.of((Object)"orderkey", (Object)BigintType.BIGINT, (Object)"string", (Object)VarcharType.VARCHAR);
        this.assertCost(project, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats).cpu(7500.0).memory(0.0).network(0.0);
        this.assertCostEstimatedExchanges(project, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats).cpu(7500.0).memory(0.0).network(0.0);
        this.assertCostSingleStageFragmentedPlan(project, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats, (Map<String, Type>)types).cpu(7500.0).memory(0.0).network(0.0);
        this.assertCostHasUnknownComponentsForUnknownStats(project);
    }

    @Test
    public void testRepartitionedJoin() {
        TableScanNode ts1 = this.tableScan("ts1", "orderkey");
        TableScanNode ts2 = this.tableScan("ts2", "orderkey_0");
        JoinNode join = this.join("join", (PlanNode)ts1, (PlanNode)ts2, JoinNode.DistributionType.PARTITIONED, "orderkey", "orderkey_0");
        ImmutableMap costs = ImmutableMap.of((Object)"ts1", (Object)TestCostCalculator.cpuCost(6000.0), (Object)"ts2", (Object)TestCostCalculator.cpuCost(1000.0));
        ImmutableMap stats = ImmutableMap.of((Object)"join", (Object)TestCostCalculator.statsEstimate((PlanNode)join, 12000.0), (Object)"ts1", (Object)TestCostCalculator.statsEstimate((PlanNode)ts1, 6000.0), (Object)"ts2", (Object)TestCostCalculator.statsEstimate((PlanNode)ts2, 1000.0));
        ImmutableMap types = ImmutableMap.of((Object)"orderkey", (Object)BigintType.BIGINT, (Object)"orderkey_0", (Object)BigintType.BIGINT);
        this.assertCost((PlanNode)join, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats).cpu(28375.0).memory(1125.0).network(0.0);
        this.assertCostEstimatedExchanges((PlanNode)join, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats).cpu(37375.0).memory(1125.0).network(7875.0);
        this.assertCostSingleStageFragmentedPlan((PlanNode)join, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats, (Map<String, Type>)types).cpu(28375.0).memory(1125.0).network(0.0);
        this.assertCostHasUnknownComponentsForUnknownStats((PlanNode)join);
    }

    @Test
    public void testReplicatedJoin() {
        TableScanNode ts1 = this.tableScan("ts1", "orderkey");
        TableScanNode ts2 = this.tableScan("ts2", "orderkey_0");
        JoinNode join = this.join("join", (PlanNode)ts1, (PlanNode)ts2, JoinNode.DistributionType.REPLICATED, "orderkey", "orderkey_0");
        ImmutableMap costs = ImmutableMap.of((Object)"ts1", (Object)TestCostCalculator.cpuCost(6000.0), (Object)"ts2", (Object)TestCostCalculator.cpuCost(1000.0));
        ImmutableMap stats = ImmutableMap.of((Object)"join", (Object)TestCostCalculator.statsEstimate((PlanNode)join, 12000.0), (Object)"ts1", (Object)TestCostCalculator.statsEstimate((PlanNode)ts1, 6000.0), (Object)"ts2", (Object)TestCostCalculator.statsEstimate((PlanNode)ts2, 1000.0));
        ImmutableMap types = ImmutableMap.of((Object)"orderkey", (Object)BigintType.BIGINT, (Object)"orderkey_0", (Object)BigintType.BIGINT);
        this.assertCost((PlanNode)join, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats).cpu(48625.0).memory(11250.0).network(0.0);
        this.assertCostEstimatedExchanges((PlanNode)join, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats).cpu(49750.0).memory(11250.0).network(11250.0);
        this.assertCostSingleStageFragmentedPlan((PlanNode)join, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats, (Map<String, Type>)types).cpu(48625.0).memory(11250.0).network(0.0);
        this.assertCostHasUnknownComponentsForUnknownStats((PlanNode)join);
    }

    @Test
    public void testMemoryCostJoinAboveJoin() {
        TableScanNode ts1 = this.tableScan("ts1", "key1");
        TableScanNode ts2 = this.tableScan("ts2", "key2");
        TableScanNode ts3 = this.tableScan("ts3", "key3");
        JoinNode join23 = this.join("join23", (PlanNode)ts2, (PlanNode)ts3, JoinNode.DistributionType.PARTITIONED, "key2", "key3");
        JoinNode join = this.join("join", (PlanNode)ts1, (PlanNode)join23, JoinNode.DistributionType.PARTITIONED, "key1", "key2");
        ImmutableMap costs = ImmutableMap.of((Object)"ts1", (Object)new PlanCostEstimate(0.0, 128.0, 128.0, 0.0), (Object)"ts2", (Object)new PlanCostEstimate(0.0, 64.0, 64.0, 0.0), (Object)"ts3", (Object)new PlanCostEstimate(0.0, 32.0, 32.0, 0.0));
        ImmutableMap stats = ImmutableMap.of((Object)"join", (Object)TestCostCalculator.statsEstimate((PlanNode)join, 10000.0), (Object)"join23", (Object)TestCostCalculator.statsEstimate((PlanNode)join23, 2000.0), (Object)"ts1", (Object)TestCostCalculator.statsEstimate((PlanNode)ts1, 10000.0), (Object)"ts2", (Object)TestCostCalculator.statsEstimate((PlanNode)ts2, 1000.0), (Object)"ts3", (Object)TestCostCalculator.statsEstimate((PlanNode)ts3, 100.0));
        ImmutableMap types = ImmutableMap.of((Object)"key1", (Object)BigintType.BIGINT, (Object)"key2", (Object)BigintType.BIGINT, (Object)"key3", (Object)BigintType.BIGINT);
        this.assertCost((PlanNode)join23, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats).memory(208.5).memoryWhenOutputting(176.5);
        this.assertCost((PlanNode)join, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats).memory(2554.5).memoryWhenOutputting(2378.0);
        this.assertCostEstimatedExchanges((PlanNode)join23, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats).memory(208.5).memoryWhenOutputting(176.5);
        this.assertCostEstimatedExchanges((PlanNode)join, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats).memory(2554.5).memoryWhenOutputting(2378.0);
        this.assertCostSingleStageFragmentedPlan((PlanNode)join23, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats, (Map<String, Type>)types).memory(208.5).memoryWhenOutputting(176.5);
        this.assertCostSingleStageFragmentedPlan((PlanNode)join, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats, (Map<String, Type>)types).memory(2554.5).memoryWhenOutputting(2378.0);
    }

    @Test
    public void testAggregation() {
        TableScanNode tableScan = this.tableScan("ts", "orderkey");
        AggregationNode aggregation = this.aggregation("agg", (PlanNode)tableScan);
        ImmutableMap costs = ImmutableMap.of((Object)"ts", (Object)TestCostCalculator.cpuCost(6000.0));
        ImmutableMap stats = ImmutableMap.of((Object)"ts", (Object)TestCostCalculator.statsEstimate((PlanNode)tableScan, 6000.0), (Object)"agg", (Object)TestCostCalculator.statsEstimate((PlanNode)aggregation, 13.0));
        ImmutableMap types = ImmutableMap.of((Object)"orderkey", (Object)BigintType.BIGINT, (Object)"count", (Object)BigintType.BIGINT);
        this.assertCost((PlanNode)aggregation, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats).cpu(12750.0).memory(14.625).network(0.0);
        this.assertCostEstimatedExchanges((PlanNode)aggregation, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats).cpu(26250.0).memory(14.625).network(6750.0);
        this.assertCostSingleStageFragmentedPlan((PlanNode)aggregation, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats, (Map<String, Type>)types).cpu(12750.0).memory(14.625).network(0.0);
        this.assertCostHasUnknownComponentsForUnknownStats((PlanNode)aggregation);
    }

    @Test
    public void testRepartitionedJoinWithExchange() {
        TableScanNode ts1 = this.tableScan("ts1", "orderkey");
        TableScanNode ts2 = this.tableScan("ts2", "orderkey_0");
        PlanNode p1 = this.project("p1", (PlanNode)ts1, Expressions.variable((String)"orderkey_1", (Type)BigintType.BIGINT), (RowExpression)Expressions.variable((String)"orderkey", (Type)BigintType.BIGINT));
        ExchangeNode remoteExchange1 = ExchangeNode.systemPartitionedExchange((PlanNodeId)new PlanNodeId("re1"), (ExchangeNode.Scope)ExchangeNode.Scope.REMOTE_STREAMING, (PlanNode)p1, (List)ImmutableList.of((Object)new VariableReferenceExpression(Optional.empty(), "orderkey_1", (Type)BigintType.BIGINT)), Optional.empty());
        ExchangeNode remoteExchange2 = ExchangeNode.systemPartitionedExchange((PlanNodeId)new PlanNodeId("re2"), (ExchangeNode.Scope)ExchangeNode.Scope.REMOTE_STREAMING, (PlanNode)ts2, (List)ImmutableList.of((Object)new VariableReferenceExpression(Optional.empty(), "orderkey_0", (Type)BigintType.BIGINT)), Optional.empty());
        ExchangeNode localExchange = ExchangeNode.systemPartitionedExchange((PlanNodeId)new PlanNodeId("le"), (ExchangeNode.Scope)ExchangeNode.Scope.LOCAL, (PlanNode)remoteExchange2, (List)ImmutableList.of((Object)new VariableReferenceExpression(Optional.empty(), "orderkey_0", (Type)BigintType.BIGINT)), Optional.empty());
        JoinNode join = this.join("join", (PlanNode)remoteExchange1, (PlanNode)localExchange, JoinNode.DistributionType.PARTITIONED, "orderkey_1", "orderkey_0");
        ImmutableMap stats = ImmutableMap.builder().put((Object)"join", (Object)TestCostCalculator.statsEstimate((PlanNode)join, 12000.0)).put((Object)"re1", (Object)TestCostCalculator.statsEstimate((PlanNode)remoteExchange1, 10000.0)).put((Object)"re2", (Object)TestCostCalculator.statsEstimate((PlanNode)remoteExchange2, 10000.0)).put((Object)"le", (Object)TestCostCalculator.statsEstimate((PlanNode)localExchange, 6000.0)).put((Object)"p1", (Object)TestCostCalculator.statsEstimate(p1, 6000.0)).put((Object)"ts1", (Object)TestCostCalculator.statsEstimate((PlanNode)ts1, 6000.0)).put((Object)"ts2", (Object)TestCostCalculator.statsEstimate((PlanNode)ts2, 1000.0)).build();
        ImmutableMap types = ImmutableMap.of((Object)"orderkey", (Object)BigintType.BIGINT, (Object)"orderkey_1", (Object)BigintType.BIGINT, (Object)"orderkey_0", (Object)BigintType.BIGINT);
        this.assertFragmentedEqualsUnfragmented((PlanNode)join, (Map<String, PlanNodeStatsEstimate>)stats, (Map<String, Type>)types);
    }

    @Test
    public void testReplicatedJoinWithExchange() {
        TableScanNode ts1 = this.tableScan("ts1", (List<VariableReferenceExpression>)ImmutableList.of((Object)new VariableReferenceExpression(Optional.empty(), "orderkey", (Type)BigintType.BIGINT)));
        TableScanNode ts2 = this.tableScan("ts2", (List<VariableReferenceExpression>)ImmutableList.of((Object)new VariableReferenceExpression(Optional.empty(), "orderkey_0", (Type)BigintType.BIGINT)));
        ExchangeNode remoteExchange2 = ExchangeNode.replicatedExchange((PlanNodeId)new PlanNodeId("re2"), (ExchangeNode.Scope)ExchangeNode.Scope.REMOTE_STREAMING, (PlanNode)ts2);
        ExchangeNode localExchange = ExchangeNode.systemPartitionedExchange((PlanNodeId)new PlanNodeId("le"), (ExchangeNode.Scope)ExchangeNode.Scope.LOCAL, (PlanNode)remoteExchange2, (List)ImmutableList.of((Object)new VariableReferenceExpression(Optional.empty(), "orderkey_0", (Type)BigintType.BIGINT)), Optional.empty());
        JoinNode join = this.join("join", (PlanNode)ts1, (PlanNode)localExchange, JoinNode.DistributionType.REPLICATED, "orderkey", "orderkey_0");
        ImmutableMap stats = ImmutableMap.builder().put((Object)"join", (Object)TestCostCalculator.statsEstimate((PlanNode)join, 12000.0)).put((Object)"re2", (Object)TestCostCalculator.statsEstimate((PlanNode)remoteExchange2, 10000.0)).put((Object)"le", (Object)TestCostCalculator.statsEstimate((PlanNode)localExchange, 6000.0)).put((Object)"ts1", (Object)TestCostCalculator.statsEstimate((PlanNode)ts1, 6000.0)).put((Object)"ts2", (Object)TestCostCalculator.statsEstimate((PlanNode)ts2, 1000.0)).build();
        ImmutableMap types = ImmutableMap.of((Object)"orderkey", (Object)BigintType.BIGINT, (Object)"orderkey_0", (Object)BigintType.BIGINT);
        this.assertFragmentedEqualsUnfragmented((PlanNode)join, (Map<String, PlanNodeStatsEstimate>)stats, (Map<String, Type>)types);
    }

    @Test
    public void testUnion() {
        TableScanNode ts1 = this.tableScan("ts1", "orderkey");
        TableScanNode ts2 = this.tableScan("ts2", "orderkey_0");
        UnionNode union = new UnionNode(Optional.empty(), new PlanNodeId("union"), (List)ImmutableList.of((Object)ts1, (Object)ts2), (List)ImmutableList.of((Object)new VariableReferenceExpression(Optional.empty(), "orderkey_1", (Type)BigintType.BIGINT)), (Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "orderkey_1", (Type)BigintType.BIGINT), (Object)ImmutableList.of((Object)new VariableReferenceExpression(Optional.empty(), "orderkey", (Type)BigintType.BIGINT), (Object)new VariableReferenceExpression(Optional.empty(), "orderkey_0", (Type)BigintType.BIGINT))));
        ImmutableMap stats = ImmutableMap.of((Object)"ts1", (Object)TestCostCalculator.statsEstimate((PlanNode)ts1, 4000.0), (Object)"ts2", (Object)TestCostCalculator.statsEstimate((PlanNode)ts2, 1000.0), (Object)"union", (Object)TestCostCalculator.statsEstimate((PlanNode)ts1, 5000.0));
        ImmutableMap costs = ImmutableMap.of((Object)"ts1", (Object)TestCostCalculator.cpuCost(1000.0), (Object)"ts2", (Object)TestCostCalculator.cpuCost(1000.0));
        ImmutableMap types = ImmutableMap.of((Object)"orderkey", (Object)BigintType.BIGINT, (Object)"orderkey_0", (Object)BigintType.BIGINT, (Object)"orderkey_1", (Object)BigintType.BIGINT);
        this.assertCost((PlanNode)union, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats).cpu(2000.0).memory(0.0).network(0.0);
        this.assertCostEstimatedExchanges((PlanNode)union, (Map<String, PlanCostEstimate>)costs, (Map<String, PlanNodeStatsEstimate>)stats).cpu(2000.0).memory(0.0).network(5625.0);
    }

    private CostAssertionBuilder assertCost(PlanNode node, Map<String, PlanCostEstimate> costs, Map<String, PlanNodeStatsEstimate> stats) {
        return this.assertCost(this.costCalculatorUsingExchanges, node, costs, stats);
    }

    private CostAssertionBuilder assertCostEstimatedExchanges(PlanNode node, Map<String, PlanCostEstimate> costs, Map<String, PlanNodeStatsEstimate> stats) {
        return this.assertCost(this.costCalculatorWithEstimatedExchanges, node, costs, stats);
    }

    private CostAssertionBuilder assertCostSingleStageFragmentedPlan(PlanNode node, Map<String, PlanCostEstimate> costs, Map<String, PlanNodeStatsEstimate> stats, Map<String, Type> types) {
        TypeProvider typeProvider = TypeProvider.copyOf(types);
        CachingStatsProvider statsProvider = new CachingStatsProvider(this.statsCalculator(stats), this.session, typeProvider);
        TestingCostProvider costProvider = new TestingCostProvider(costs, this.costCalculatorUsingExchanges, (StatsProvider)statsProvider, this.session);
        StatsAndCosts statsAndCosts = StatsAndCosts.create((PlanNode)node, (StatsProvider)statsProvider, (CostProvider)costProvider).getForSubplan(node);
        return new CostAssertionBuilder(statsAndCosts.getCosts().getOrDefault(node.getId(), PlanCostEstimate.unknown()));
    }

    private CostAssertionBuilder assertCost(CostCalculator costCalculator, PlanNode node, Map<String, PlanCostEstimate> costs, Map<String, PlanNodeStatsEstimate> stats) {
        Function<PlanNode, PlanNodeStatsEstimate> statsProvider = planNode -> (PlanNodeStatsEstimate)stats.get(planNode.getId().toString());
        PlanCostEstimate cost = this.calculateCost(costCalculator, node, this.sourceCostProvider(costCalculator, costs, statsProvider), statsProvider);
        return new CostAssertionBuilder(cost);
    }

    private Function<PlanNode, PlanCostEstimate> sourceCostProvider(CostCalculator costCalculator, Map<String, PlanCostEstimate> costs, Function<PlanNode, PlanNodeStatsEstimate> statsProvider) {
        return node -> {
            PlanCostEstimate providedCost = (PlanCostEstimate)costs.get(node.getId().toString());
            if (providedCost != null) {
                return providedCost;
            }
            return this.calculateCost(costCalculator, (PlanNode)node, this.sourceCostProvider(costCalculator, costs, statsProvider), statsProvider);
        };
    }

    private void assertCostHasUnknownComponentsForUnknownStats(PlanNode node) {
        new CostAssertionBuilder(this.calculateCost(this.costCalculatorUsingExchanges, node, (PlanNode planNode) -> PlanCostEstimate.unknown(), (PlanNode planNode) -> PlanNodeStatsEstimate.unknown())).hasUnknownComponents();
        new CostAssertionBuilder(this.calculateCost(this.costCalculatorWithEstimatedExchanges, node, (PlanNode planNode) -> PlanCostEstimate.unknown(), (PlanNode planNode) -> PlanNodeStatsEstimate.unknown())).hasUnknownComponents();
    }

    private void assertFragmentedEqualsUnfragmented(PlanNode node, Map<String, PlanNodeStatsEstimate> stats, Map<String, Type> types) {
        StatsCalculator statsCalculator = this.statsCalculator(stats);
        PlanCostEstimate costWithExchanges = this.calculateCost(node, this.costCalculatorUsingExchanges, statsCalculator, types);
        PlanCostEstimate costWithFragments = this.calculateCostFragmentedPlan(node, statsCalculator, types);
        Assert.assertEquals((Object)costWithExchanges, (Object)costWithFragments);
    }

    private StatsCalculator statsCalculator(Map<String, PlanNodeStatsEstimate> stats) {
        return (node, sourceStats, lookup, session, types) -> (PlanNodeStatsEstimate)Objects.requireNonNull(stats.get(node.getId().toString()), "no stats for node");
    }

    private PlanCostEstimate calculateCost(CostCalculator costCalculator, PlanNode node, Function<PlanNode, PlanCostEstimate> costs, Function<PlanNode, PlanNodeStatsEstimate> stats) {
        return costCalculator.calculateCost(node, planNode -> (PlanNodeStatsEstimate)Objects.requireNonNull(stats.apply(planNode), "no stats for node"), source -> (PlanCostEstimate)Objects.requireNonNull(costs.apply(source), String.format("no cost for source: %s", source.getId())), this.session);
    }

    private PlanCostEstimate calculateCost(PlanNode node, CostCalculator costCalculator, StatsCalculator statsCalculator, Map<String, Type> types) {
        TypeProvider typeProvider = TypeProvider.copyOf(types);
        CachingStatsProvider statsProvider = new CachingStatsProvider(statsCalculator, this.session, typeProvider);
        CachingCostProvider costProvider = new CachingCostProvider(costCalculator, (StatsProvider)statsProvider, Optional.empty(), this.session);
        return costProvider.getCost(node);
    }

    private PlanCostEstimate calculateCostFragmentedPlan(PlanNode node, StatsCalculator statsCalculator, Map<String, Type> types) {
        TypeProvider typeProvider = TypeProvider.copyOf(types);
        CachingStatsProvider statsProvider = new CachingStatsProvider(statsCalculator, this.session, typeProvider);
        CachingCostProvider costProvider = new CachingCostProvider(this.costCalculatorUsingExchanges, (StatsProvider)statsProvider, Optional.empty(), this.session);
        SubPlan subPlan = this.fragment(new Plan(node, typeProvider, StatsAndCosts.create((PlanNode)node, (StatsProvider)statsProvider, (CostProvider)costProvider)));
        return subPlan.getFragment().getStatsAndCosts().getCosts().getOrDefault(node.getId(), PlanCostEstimate.unknown());
    }

    private static PlanNodeStatsEstimate statsEstimate(PlanNode node, double outputSizeInBytes) {
        return TestCostCalculator.statsEstimate(node.getOutputVariables(), outputSizeInBytes);
    }

    private static PlanNodeStatsEstimate statsEstimate(Collection<VariableReferenceExpression> variables, double outputSizeInBytes) {
        Preconditions.checkArgument((variables.size() > 0 ? 1 : 0) != 0, (Object)"No variables");
        Preconditions.checkArgument((ImmutableSet.copyOf(variables).size() == variables.size() ? 1 : 0) != 0, (Object)"Duplicate variables");
        double rowCount = outputSizeInBytes / (double)variables.size() / 8.0;
        PlanNodeStatsEstimate.Builder builder = PlanNodeStatsEstimate.builder().setOutputRowCount(rowCount);
        for (VariableReferenceExpression variable : variables) {
            builder.addVariableStatistics(variable, VariableStatsEstimate.builder().setNullsFraction(0.0).setAverageRowSize(8.0).build());
        }
        return builder.build();
    }

    private TableScanNode tableScan(String id, String ... symbols) {
        List variables = (List)Arrays.stream(symbols).map(symbol -> new VariableReferenceExpression(Optional.empty(), symbol, (Type)BigintType.BIGINT)).collect(ImmutableList.toImmutableList());
        return this.tableScan(id, variables);
    }

    private TableScanNode tableScan(String id, List<VariableReferenceExpression> variables) {
        ImmutableMap.Builder assignments = ImmutableMap.builder();
        for (VariableReferenceExpression variable : variables) {
            assignments.put((Object)variable, (Object)new TpchColumnHandle("orderkey", (Type)BigintType.BIGINT));
        }
        TpchTableHandle tableHandle = new TpchTableHandle("orders", 1.0);
        return new TableScanNode(Optional.empty(), new PlanNodeId(id), new TableHandle(new ConnectorId("tpch"), (ConnectorTableHandle)tableHandle, (ConnectorTransactionHandle)TpchTransactionHandle.INSTANCE, Optional.of(new TpchTableLayoutHandle(tableHandle, TupleDomain.all()))), variables, (Map)assignments.build(), TupleDomain.all(), TupleDomain.all());
    }

    private PlanNode project(String id, PlanNode source, VariableReferenceExpression variable, RowExpression expression) {
        return new ProjectNode(new PlanNodeId(id), source, PlanBuilder.assignment(variable, expression));
    }

    private AggregationNode aggregation(String id, PlanNode source) {
        AggregationNode.Aggregation aggregation = AggregationNodeUtils.count((FunctionAndTypeManager)this.metadata.getFunctionAndTypeManager());
        return new AggregationNode(Optional.empty(), new PlanNodeId(id), source, (Map)ImmutableMap.of((Object)new VariableReferenceExpression(Optional.empty(), "count", (Type)BigintType.BIGINT), (Object)aggregation), AggregationNode.singleGroupingSet((List)source.getOutputVariables()), (List)ImmutableList.of(), AggregationNode.Step.FINAL, Optional.empty(), Optional.empty());
    }

    private JoinNode join(String planNodeId, PlanNode left, PlanNode right, JoinNode.DistributionType distributionType, String ... symbols) {
        Preconditions.checkArgument((symbols.length % 2 == 0 ? 1 : 0) != 0);
        ImmutableList.Builder criteria = ImmutableList.builder();
        for (int i = 0; i < symbols.length; i += 2) {
            criteria.add((Object)new JoinNode.EquiJoinClause(new VariableReferenceExpression(Optional.empty(), symbols[i], (Type)BigintType.BIGINT), new VariableReferenceExpression(Optional.empty(), symbols[i + 1], (Type)BigintType.BIGINT)));
        }
        return new JoinNode(Optional.empty(), new PlanNodeId(planNodeId), JoinNode.Type.INNER, left, right, (List)criteria.build(), (List)ImmutableList.builder().addAll((Iterable)left.getOutputVariables()).addAll((Iterable)right.getOutputVariables()).build(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(distributionType), (Map)ImmutableMap.of());
    }

    private SubPlan fragment(Plan plan) {
        return this.inTransaction(session -> this.planFragmenter.createSubPlans(session, plan, false, new PlanNodeIdAllocator(), WarningCollector.NOOP));
    }

    private <T> T inTransaction(Function<Session, T> transactionSessionConsumer) {
        return (T)TransactionBuilder.transaction((TransactionManager)this.transactionManager, (AccessControl)new AllowAllAccessControl()).singleStatement().execute(this.session, session -> {
            session.getCatalog().ifPresent(catalog -> this.metadata.getCatalogHandle(session, catalog));
            return transactionSessionConsumer.apply((Session)session);
        });
    }

    private static PlanCostEstimate cpuCost(double cpuCost) {
        return new PlanCostEstimate(cpuCost, 0.0, 0.0, 0.0);
    }

    private static class CostAssertionBuilder {
        private final PlanCostEstimate actual;

        CostAssertionBuilder(PlanCostEstimate actual) {
            this.actual = Objects.requireNonNull(actual, "actual is null");
        }

        CostAssertionBuilder cpu(double value) {
            Assert.assertEquals((double)this.actual.getCpuCost(), (double)value, (double)1.0E-6);
            return this;
        }

        CostAssertionBuilder memory(double value) {
            Assert.assertEquals((double)this.actual.getMaxMemory(), (double)value, (double)1.0E-6);
            return this;
        }

        CostAssertionBuilder memoryWhenOutputting(double value) {
            Assert.assertEquals((double)this.actual.getMaxMemoryWhenOutputting(), (double)value, (double)1.0E-6);
            return this;
        }

        CostAssertionBuilder network(double value) {
            Assert.assertEquals((double)this.actual.getNetworkCost(), (double)value, (double)1.0E-6);
            return this;
        }

        CostAssertionBuilder hasUnknownComponents() {
            Assert.assertTrue((boolean)this.actual.hasUnknownComponents());
            return this;
        }
    }

    private static class TestingCostProvider
    implements CostProvider {
        private final Map<String, PlanCostEstimate> costs;
        private final CostCalculator costCalculator;
        private final StatsProvider statsProvider;
        private final Session session;

        private TestingCostProvider(Map<String, PlanCostEstimate> costs, CostCalculator costCalculator, StatsProvider statsProvider, Session session) {
            this.costs = ImmutableMap.copyOf(Objects.requireNonNull(costs, "costs is null"));
            this.costCalculator = Objects.requireNonNull(costCalculator, "costCalculator is null");
            this.statsProvider = Objects.requireNonNull(statsProvider, "statsProvider is null");
            this.session = Objects.requireNonNull(session, "session is null");
        }

        public PlanCostEstimate getCost(PlanNode node) {
            if (this.costs.containsKey(node.getId().toString())) {
                return this.costs.get(node.getId().toString());
            }
            return this.costCalculator.calculateCost(node, this.statsProvider, (CostProvider)this, this.session);
        }
    }
}

