/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.cost.BaseStatsCalculatorTest;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.StatsCalculatorTester;
import com.facebook.presto.cost.VariableStatsEstimate;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.testing.TestingSession;
import java.util.Optional;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestFilterStatsRule
extends BaseStatsCalculatorTest {
    public StatsCalculatorTester defaultFilterTester;

    @BeforeClass
    public void setupClass() {
        this.defaultFilterTester = new StatsCalculatorTester(TestingSession.testSessionBuilder().setSystemProperty("default_filter_factor_enabled", "true").build());
    }

    @AfterClass(alwaysRun=true)
    public void tearDownClass() {
        this.defaultFilterTester.close();
        this.defaultFilterTester = null;
    }

    @Test
    public void testEstimableFilter() {
        this.tester().assertStatsFor(pb -> pb.registerVariable(pb.variable("i1")).filter(pb.rowExpression("i1 = 5"), (PlanNode)pb.values(pb.variable("i1", (Type)BigintType.BIGINT), pb.variable("i2", (Type)BigintType.BIGINT), pb.variable("i3", (Type)BigintType.BIGINT)))).withSourceStats(0, PlanNodeStatsEstimate.builder().setOutputRowCount(10.0).addVariableStatistics(new VariableReferenceExpression(Optional.empty(), "i1", (Type)BigintType.BIGINT), VariableStatsEstimate.builder().setLowValue(1.0).setHighValue(10.0).setDistinctValuesCount(5.0).setNullsFraction(0.0).build()).addVariableStatistics(new VariableReferenceExpression(Optional.empty(), "i2", (Type)BigintType.BIGINT), VariableStatsEstimate.builder().setLowValue(0.0).setHighValue(3.0).setDistinctValuesCount(4.0).setNullsFraction(0.0).build()).addVariableStatistics(new VariableReferenceExpression(Optional.empty(), "i3", (Type)BigintType.BIGINT), VariableStatsEstimate.builder().setLowValue(10.0).setHighValue(15.0).setDistinctValuesCount(4.0).setNullsFraction(0.1).build()).build()).check(check -> check.outputRowsCount(2.0).variableStats(new VariableReferenceExpression(Optional.empty(), "i1", (Type)BigintType.BIGINT), assertion -> assertion.lowValue(5.0).highValue(5.0).distinctValuesCount(1.0).dataSizeUnknown().nullsFraction(0.0)).variableStats(new VariableReferenceExpression(Optional.empty(), "i2", (Type)BigintType.BIGINT), assertion -> assertion.lowValue(0.0).highValue(3.0).dataSizeUnknown().distinctValuesCount(2.0).nullsFraction(0.0)).variableStats(new VariableReferenceExpression(Optional.empty(), "i3", (Type)BigintType.BIGINT), assertion -> assertion.lowValue(10.0).highValue(15.0).dataSizeUnknown().distinctValuesCount(1.9).nullsFraction(0.05)));
        this.defaultFilterTester.assertStatsFor(pb -> pb.registerVariable(pb.variable("i1")).filter(pb.rowExpression("i1 = 5"), (PlanNode)pb.values(pb.variable("i1", (Type)BigintType.BIGINT), pb.variable("i2", (Type)BigintType.BIGINT), pb.variable("i3", (Type)BigintType.BIGINT)))).withSourceStats(0, PlanNodeStatsEstimate.builder().setOutputRowCount(10.0).addVariableStatistics(new VariableReferenceExpression(Optional.empty(), "i1", (Type)BigintType.BIGINT), VariableStatsEstimate.builder().setLowValue(1.0).setHighValue(10.0).setDistinctValuesCount(5.0).setNullsFraction(0.0).build()).addVariableStatistics(new VariableReferenceExpression(Optional.empty(), "i2", (Type)BigintType.BIGINT), VariableStatsEstimate.builder().setLowValue(0.0).setHighValue(3.0).setDistinctValuesCount(4.0).setNullsFraction(0.0).build()).addVariableStatistics(new VariableReferenceExpression(Optional.empty(), "i3", (Type)BigintType.BIGINT), VariableStatsEstimate.builder().setLowValue(10.0).setHighValue(15.0).setDistinctValuesCount(4.0).setNullsFraction(0.1).build()).build()).check(check -> check.outputRowsCount(2.0).variableStats(new VariableReferenceExpression(Optional.empty(), "i1", (Type)BigintType.BIGINT), assertion -> assertion.lowValue(5.0).highValue(5.0).distinctValuesCount(1.0).dataSizeUnknown().nullsFraction(0.0)).variableStats(new VariableReferenceExpression(Optional.empty(), "i2", (Type)BigintType.BIGINT), assertion -> assertion.lowValue(0.0).highValue(3.0).dataSizeUnknown().distinctValuesCount(2.0).nullsFraction(0.0)).variableStats(new VariableReferenceExpression(Optional.empty(), "i3", (Type)BigintType.BIGINT), assertion -> assertion.lowValue(10.0).highValue(15.0).dataSizeUnknown().distinctValuesCount(1.9).nullsFraction(0.05)));
    }

    @Test
    public void testUnestimatableFunction() {
        this.tester().assertStatsFor(pb -> pb.registerVariable(pb.variable("i1")).filter(pb.rowExpression("sin(i1) = 1"), (PlanNode)pb.values(pb.variable("i1", (Type)BigintType.BIGINT), pb.variable("i2", (Type)BigintType.BIGINT), pb.variable("i3", (Type)BigintType.BIGINT)))).withSourceStats(0, PlanNodeStatsEstimate.builder().setOutputRowCount(10.0).addVariableStatistics(new VariableReferenceExpression(Optional.empty(), "i1", (Type)BigintType.BIGINT), VariableStatsEstimate.builder().setLowValue(1.0).setHighValue(10.0).setDistinctValuesCount(5.0).setNullsFraction(0.0).build()).addVariableStatistics(new VariableReferenceExpression(Optional.empty(), "i2", (Type)BigintType.BIGINT), VariableStatsEstimate.builder().setLowValue(0.0).setHighValue(3.0).setDistinctValuesCount(4.0).setNullsFraction(0.0).build()).addVariableStatistics(new VariableReferenceExpression(Optional.empty(), "i3", (Type)BigintType.BIGINT), VariableStatsEstimate.builder().setLowValue(10.0).setHighValue(15.0).setDistinctValuesCount(4.0).setNullsFraction(0.1).build()).build()).check(check -> check.outputRowsCountUnknown());
        this.defaultFilterTester.assertStatsFor(pb -> pb.registerVariable(pb.variable("i1")).filter(pb.rowExpression("sin(i1) = 1"), (PlanNode)pb.values(pb.variable("i1", (Type)BigintType.BIGINT), pb.variable("i2", (Type)BigintType.BIGINT), pb.variable("i3", (Type)BigintType.BIGINT)))).withSourceStats(0, PlanNodeStatsEstimate.builder().setOutputRowCount(10.0).addVariableStatistics(new VariableReferenceExpression(Optional.empty(), "i1", (Type)BigintType.BIGINT), VariableStatsEstimate.builder().setLowValue(1.0).setHighValue(10.0).setDistinctValuesCount(5.0).setNullsFraction(0.0).build()).addVariableStatistics(new VariableReferenceExpression(Optional.empty(), "i2", (Type)BigintType.BIGINT), VariableStatsEstimate.builder().setLowValue(0.0).setHighValue(3.0).setDistinctValuesCount(4.0).setNullsFraction(0.0).build()).addVariableStatistics(new VariableReferenceExpression(Optional.empty(), "i3", (Type)BigintType.BIGINT), VariableStatsEstimate.builder().setLowValue(10.0).setHighValue(15.0).setDistinctValuesCount(4.0).setNullsFraction(0.1).build()).build()).check(check -> check.outputRowsCount(9.0).variableStats(new VariableReferenceExpression(Optional.empty(), "i1", (Type)BigintType.BIGINT), assertion -> assertion.lowValue(1.0).highValue(10.0).dataSizeUnknown().distinctValuesCount(5.0).nullsFraction(0.0)).variableStats(new VariableReferenceExpression(Optional.empty(), "i2", (Type)BigintType.BIGINT), assertion -> assertion.lowValue(0.0).highValue(3.0).dataSizeUnknown().distinctValuesCount(4.0).nullsFraction(0.0)).variableStats(new VariableReferenceExpression(Optional.empty(), "i3", (Type)BigintType.BIGINT), assertion -> assertion.lowValue(10.0).highValue(15.0).dataSizeUnknown().distinctValuesCount(4.0).nullsFraction(0.1)));
    }
}

