/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.cost.HistoricalPlanStatisticsUtil;
import com.facebook.presto.cost.HistoryBasedOptimizationConfig;
import com.facebook.presto.spi.statistics.Estimate;
import com.facebook.presto.spi.statistics.HistoricalPlanStatistics;
import com.facebook.presto.spi.statistics.PlanStatistics;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHistoricalPlanStatistics {
    @Test
    public void testWithNoTables() {
        HistoricalPlanStatistics stats = HistoricalPlanStatistics.empty();
        stats = TestHistoricalPlanStatistics.updatePlanStatistics(stats, (List<PlanStatistics>)ImmutableList.of(), this.stats(10.0, 10.0));
        Assert.assertEquals((Object)TestHistoricalPlanStatistics.getPredictedPlanStatistics(stats, (List<PlanStatistics>)ImmutableList.of()), (Object)this.stats(10.0, 10.0));
        stats = TestHistoricalPlanStatistics.updatePlanStatistics(stats, (List<PlanStatistics>)ImmutableList.of(), this.stats(12.0, 13.0));
        Assert.assertEquals((Object)TestHistoricalPlanStatistics.getPredictedPlanStatistics(stats, (List<PlanStatistics>)ImmutableList.of()), (Object)this.stats(12.0, 13.0));
    }

    @Test
    public void testWithOneTable() {
        HistoricalPlanStatistics stats = HistoricalPlanStatistics.empty();
        stats = TestHistoricalPlanStatistics.updatePlanStatistics(stats, (List<PlanStatistics>)ImmutableList.of((Object)this.stats(100.0, 100.0)), this.stats(10.0, 10.0));
        Assert.assertEquals((Object)TestHistoricalPlanStatistics.getPredictedPlanStatistics(stats, (List<PlanStatistics>)ImmutableList.of((Object)this.stats(100.0, 100.0))), (Object)this.stats(10.0, 10.0));
        Assert.assertEquals((Object)TestHistoricalPlanStatistics.getPredictedPlanStatistics(stats, (List<PlanStatistics>)ImmutableList.of((Object)this.stats(95.0, 105.0))), (Object)this.stats(10.0, 10.0));
        Assert.assertEquals((Object)TestHistoricalPlanStatistics.getPredictedPlanStatistics(stats, (List<PlanStatistics>)ImmutableList.of((Object)this.stats(80.0, 80.0))), (Object)PlanStatistics.empty());
        Assert.assertEquals((Object)TestHistoricalPlanStatistics.getPredictedPlanStatistics(stats, (List<PlanStatistics>)ImmutableList.of((Object)this.stats(120.0, 120.0))), (Object)PlanStatistics.empty());
        stats = TestHistoricalPlanStatistics.updatePlanStatistics(stats, (List<PlanStatistics>)ImmutableList.of((Object)this.stats(95.0, 105.0)), this.stats(11.0, 11.0));
        Assert.assertEquals((int)stats.getLastRunsStatistics().size(), (int)1);
        Assert.assertEquals((Object)TestHistoricalPlanStatistics.getPredictedPlanStatistics(stats, (List<PlanStatistics>)ImmutableList.of((Object)this.stats(95.0, 105.0))), (Object)this.stats(11.0, 11.0));
        stats = TestHistoricalPlanStatistics.updatePlanStatistics(stats, (List<PlanStatistics>)ImmutableList.of((Object)this.stats(80.0, 120.0)), this.stats(15.0, 15.0));
        Assert.assertEquals((int)stats.getLastRunsStatistics().size(), (int)2);
        Assert.assertEquals((Object)TestHistoricalPlanStatistics.getPredictedPlanStatistics(stats, (List<PlanStatistics>)ImmutableList.of((Object)this.stats(100.0, 100.0))), (Object)this.stats(11.0, 11.0));
        Assert.assertEquals((Object)TestHistoricalPlanStatistics.getPredictedPlanStatistics(stats, (List<PlanStatistics>)ImmutableList.of((Object)this.stats(80.0, 120.0))), (Object)this.stats(15.0, 15.0));
    }

    @Test
    public void testWithTwoTables() {
        HistoricalPlanStatistics stats = HistoricalPlanStatistics.empty();
        stats = TestHistoricalPlanStatistics.updatePlanStatistics(stats, (List<PlanStatistics>)ImmutableList.of((Object)this.stats(100.0, 100.0), (Object)this.stats(10.0, 10.0)), this.stats(10.0, 10.0));
        Assert.assertEquals((Object)TestHistoricalPlanStatistics.getPredictedPlanStatistics(stats, (List<PlanStatistics>)ImmutableList.of((Object)this.stats(100.0, 100.0), (Object)this.stats(10.0, 10.0))), (Object)this.stats(10.0, 10.0));
        Assert.assertEquals((Object)TestHistoricalPlanStatistics.getPredictedPlanStatistics(stats, (List<PlanStatistics>)ImmutableList.of((Object)this.stats(95.0, 105.0), (Object)this.stats(9.0, 11.0))), (Object)this.stats(10.0, 10.0));
        Assert.assertEquals((Object)TestHistoricalPlanStatistics.getPredictedPlanStatistics(stats, (List<PlanStatistics>)ImmutableList.of((Object)this.stats(80.0, 80.0), (Object)this.stats(10.0, 10.0))), (Object)PlanStatistics.empty());
        Assert.assertEquals((Object)TestHistoricalPlanStatistics.getPredictedPlanStatistics(stats, (List<PlanStatistics>)ImmutableList.of((Object)this.stats(100.0, 100.0), (Object)this.stats(10.0, 8.0))), (Object)PlanStatistics.empty());
        stats = TestHistoricalPlanStatistics.updatePlanStatistics(stats, (List<PlanStatistics>)ImmutableList.of((Object)this.stats(200.0, 200.0), (Object)this.stats(20.0, 20.0)), this.stats(20.0, 20.0));
        Assert.assertEquals((int)stats.getLastRunsStatistics().size(), (int)2);
        Assert.assertEquals((Object)TestHistoricalPlanStatistics.getPredictedPlanStatistics(stats, (List<PlanStatistics>)ImmutableList.of((Object)this.stats(105.0, 95.0), (Object)this.stats(11.0, 9.0))), (Object)this.stats(10.0, 10.0));
        Assert.assertEquals((Object)TestHistoricalPlanStatistics.getPredictedPlanStatistics(stats, (List<PlanStatistics>)ImmutableList.of((Object)this.stats(200.0, 180.0), (Object)this.stats(18.0, 21.0))), (Object)this.stats(20.0, 20.0));
    }

    @Test
    public void testMaxStatistics() {
        HistoricalPlanStatistics stats = HistoricalPlanStatistics.empty();
        for (int i = 1; i <= 20; ++i) {
            stats = TestHistoricalPlanStatistics.updatePlanStatistics(stats, (List<PlanStatistics>)ImmutableList.of((Object)this.stats(100 * i, 100 * i)), this.stats(10 * i, 10 * i));
        }
        Assert.assertEquals((int)stats.getLastRunsStatistics().size(), (int)10);
    }

    private PlanStatistics stats(double rows, double size) {
        return new PlanStatistics(Estimate.of((double)rows), Estimate.of((double)size), 1.0);
    }

    private static HistoricalPlanStatistics updatePlanStatistics(HistoricalPlanStatistics historicalPlanStatistics, List<PlanStatistics> inputTableStatistics, PlanStatistics current) {
        return HistoricalPlanStatisticsUtil.updatePlanStatistics((HistoricalPlanStatistics)historicalPlanStatistics, inputTableStatistics, (PlanStatistics)current, (HistoryBasedOptimizationConfig)new HistoryBasedOptimizationConfig());
    }

    private static PlanStatistics getPredictedPlanStatistics(HistoricalPlanStatistics historicalPlanStatistics, List<PlanStatistics> inputTableStatistics) {
        return HistoricalPlanStatisticsUtil.getPredictedPlanStatistics((HistoricalPlanStatistics)historicalPlanStatistics, inputTableStatistics, (HistoryBasedOptimizationConfig)new HistoryBasedOptimizationConfig());
    }
}

