/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.Session;
import com.facebook.presto.cost.BaseStatsCalculatorTest;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.StatsCalculatorTester;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.testing.TestingSession;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestRemoteSourceStatsRule
extends BaseStatsCalculatorTest {
    @Test
    public void testRemoteSourceStatsRule() {
        QueryId queryId = new QueryId("testqueryid");
        Session session = TestingSession.testSessionBuilder().setQueryId(queryId).build();
        StatsCalculatorTester tester = new StatsCalculatorTester(session);
        tester.getFragmentStatsProvider().putStats(queryId, new PlanFragmentId(1), new PlanNodeStatsEstimate(Double.NaN, 1000.0, true, (Map)ImmutableMap.of()));
        tester.getFragmentStatsProvider().putStats(queryId, new PlanFragmentId(2), new PlanNodeStatsEstimate(Double.NaN, 1000.0, true, (Map)ImmutableMap.of()));
        tester.assertStatsFor(planBuilder -> planBuilder.remoteSource((List<PlanFragmentId>)ImmutableList.of((Object)new PlanFragmentId(1), (Object)new PlanFragmentId(2)))).check(check -> check.totalSize(2000.0).outputRowsCountUnknown());
        tester.close();
    }

    @Test
    public void testRemoteSourceStatsUnknown() {
        this.tester().assertStatsFor(planBuilder -> planBuilder.remoteSource((List<PlanFragmentId>)ImmutableList.of((Object)new PlanFragmentId(1), (Object)new PlanFragmentId(2)))).check(check -> check.outputRowsCountUnknown().totalSizeUnknown());
    }
}

