/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.cost.PlanNodeStatsAssertion;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.SemiJoinStatsCalculator;
import com.facebook.presto.cost.VariableStatsEstimate;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import java.util.Optional;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestSemiJoinStatsCalculator {
    private PlanNodeStatsEstimate inputStatistics;
    private VariableStatsEstimate uStats;
    private VariableStatsEstimate wStats;
    private VariableStatsEstimate xStats;
    private VariableStatsEstimate yStats;
    private VariableStatsEstimate zStats;
    private VariableStatsEstimate leftOpenStats;
    private VariableStatsEstimate rightOpenStats;
    private VariableStatsEstimate unknownRangeStats;
    private VariableStatsEstimate emptyRangeStats;
    private VariableStatsEstimate fractionalNdvStats;
    private VariableReferenceExpression u = new VariableReferenceExpression(Optional.empty(), "u", (Type)BigintType.BIGINT);
    private VariableReferenceExpression w = new VariableReferenceExpression(Optional.empty(), "w", (Type)BigintType.BIGINT);
    private VariableReferenceExpression x = new VariableReferenceExpression(Optional.empty(), "x", (Type)BigintType.BIGINT);
    private VariableReferenceExpression y = new VariableReferenceExpression(Optional.empty(), "y", (Type)BigintType.BIGINT);
    private VariableReferenceExpression z = new VariableReferenceExpression(Optional.empty(), "z", (Type)BigintType.BIGINT);
    private VariableReferenceExpression leftOpen = new VariableReferenceExpression(Optional.empty(), "leftOpen", (Type)BigintType.BIGINT);
    private VariableReferenceExpression rightOpen = new VariableReferenceExpression(Optional.empty(), "rightOpen", (Type)BigintType.BIGINT);
    private VariableReferenceExpression unknownRange = new VariableReferenceExpression(Optional.empty(), "unknownRange", (Type)BigintType.BIGINT);
    private VariableReferenceExpression emptyRange = new VariableReferenceExpression(Optional.empty(), "emptyRange", (Type)BigintType.BIGINT);
    private VariableReferenceExpression unknown = new VariableReferenceExpression(Optional.empty(), "unknown", (Type)BigintType.BIGINT);
    private VariableReferenceExpression fractionalNdv = new VariableReferenceExpression(Optional.empty(), "fractionalNdv", (Type)BigintType.BIGINT);

    @BeforeClass
    public void setUp() throws Exception {
        this.uStats = VariableStatsEstimate.builder().setAverageRowSize(8.0).setDistinctValuesCount(300.0).setLowValue(0.0).setHighValue(20.0).setNullsFraction(0.1).build();
        this.wStats = VariableStatsEstimate.builder().setAverageRowSize(8.0).setDistinctValuesCount(30.0).setLowValue(0.0).setHighValue(20.0).setNullsFraction(0.1).build();
        this.xStats = VariableStatsEstimate.builder().setAverageRowSize(4.0).setDistinctValuesCount(40.0).setLowValue(-10.0).setHighValue(10.0).setNullsFraction(0.25).build();
        this.yStats = VariableStatsEstimate.builder().setAverageRowSize(4.0).setDistinctValuesCount(20.0).setLowValue(0.0).setHighValue(5.0).setNullsFraction(0.5).build();
        this.zStats = VariableStatsEstimate.builder().setAverageRowSize(4.0).setDistinctValuesCount(5.0).setLowValue(-100.0).setHighValue(100.0).setNullsFraction(0.1).build();
        this.leftOpenStats = VariableStatsEstimate.builder().setAverageRowSize(4.0).setDistinctValuesCount(50.0).setLowValue(Double.NEGATIVE_INFINITY).setHighValue(15.0).setNullsFraction(0.1).build();
        this.rightOpenStats = VariableStatsEstimate.builder().setAverageRowSize(4.0).setDistinctValuesCount(50.0).setLowValue(-15.0).setHighValue(Double.POSITIVE_INFINITY).setNullsFraction(0.1).build();
        this.unknownRangeStats = VariableStatsEstimate.builder().setAverageRowSize(4.0).setDistinctValuesCount(50.0).setLowValue(Double.NEGATIVE_INFINITY).setHighValue(Double.POSITIVE_INFINITY).setNullsFraction(0.1).build();
        this.emptyRangeStats = VariableStatsEstimate.builder().setAverageRowSize(4.0).setDistinctValuesCount(0.0).setLowValue(Double.NaN).setHighValue(Double.NaN).setNullsFraction(Double.NaN).build();
        this.fractionalNdvStats = VariableStatsEstimate.builder().setAverageRowSize(Double.NaN).setDistinctValuesCount(0.1).setNullsFraction(0.0).build();
        this.inputStatistics = PlanNodeStatsEstimate.builder().addVariableStatistics(this.u, this.uStats).addVariableStatistics(this.w, this.wStats).addVariableStatistics(this.x, this.xStats).addVariableStatistics(this.y, this.yStats).addVariableStatistics(this.z, this.zStats).addVariableStatistics(this.leftOpen, this.leftOpenStats).addVariableStatistics(this.rightOpen, this.rightOpenStats).addVariableStatistics(this.unknownRange, this.unknownRangeStats).addVariableStatistics(this.emptyRange, this.emptyRangeStats).addVariableStatistics(this.unknown, VariableStatsEstimate.unknown()).addVariableStatistics(this.fractionalNdv, this.fractionalNdvStats).setOutputRowCount(1000.0).build();
    }

    @Test
    public void testSemiJoin() {
        PlanNodeStatsAssertion.assertThat(SemiJoinStatsCalculator.computeSemiJoin((PlanNodeStatsEstimate)this.inputStatistics, (PlanNodeStatsEstimate)this.inputStatistics, (VariableReferenceExpression)this.x, (VariableReferenceExpression)this.w)).variableStats(this.x, stats -> stats.lowValue(this.xStats.getLowValue()).highValue(this.xStats.getHighValue()).nullsFraction(0.0).distinctValuesCount(this.wStats.getDistinctValuesCount())).variableStats(this.w, stats -> stats.isEqualTo(this.wStats)).variableStats(this.z, stats -> stats.isEqualTo(this.zStats)).outputRowsCount(this.inputStatistics.getOutputRowCount() * this.xStats.getValuesFraction() * (this.wStats.getDistinctValuesCount() / this.xStats.getDistinctValuesCount()));
        PlanNodeStatsAssertion.assertThat(SemiJoinStatsCalculator.computeSemiJoin((PlanNodeStatsEstimate)this.inputStatistics, (PlanNodeStatsEstimate)this.inputStatistics, (VariableReferenceExpression)this.x, (VariableReferenceExpression)this.u)).variableStats(this.x, stats -> stats.lowValue(this.xStats.getLowValue()).highValue(this.xStats.getHighValue()).nullsFraction(0.0).distinctValuesCount(this.xStats.getDistinctValuesCount())).variableStats(this.u, stats -> stats.isEqualTo(this.uStats)).variableStats(this.z, stats -> stats.isEqualTo(this.zStats)).outputRowsCount(this.inputStatistics.getOutputRowCount() * this.xStats.getValuesFraction());
        PlanNodeStatsAssertion.assertThat(SemiJoinStatsCalculator.computeSemiJoin((PlanNodeStatsEstimate)this.inputStatistics, (PlanNodeStatsEstimate)this.inputStatistics, (VariableReferenceExpression)this.unknown, (VariableReferenceExpression)this.u)).variableStats(this.unknown, stats -> stats.nullsFraction(0.0).distinctValuesCountUnknown().unknownRange()).variableStats(this.u, stats -> stats.isEqualTo(this.uStats)).variableStats(this.z, stats -> stats.isEqualTo(this.zStats)).outputRowsCountUnknown();
        PlanNodeStatsAssertion.assertThat(SemiJoinStatsCalculator.computeSemiJoin((PlanNodeStatsEstimate)this.inputStatistics, (PlanNodeStatsEstimate)this.inputStatistics, (VariableReferenceExpression)this.x, (VariableReferenceExpression)this.unknown)).variableStats(this.x, stats -> stats.nullsFraction(0.0).lowValue(this.xStats.getLowValue()).highValue(this.xStats.getHighValue()).distinctValuesCountUnknown()).variableStatsUnknown(this.unknown).variableStats(this.z, stats -> stats.isEqualTo(this.zStats)).outputRowsCountUnknown();
        PlanNodeStatsAssertion.assertThat(SemiJoinStatsCalculator.computeSemiJoin((PlanNodeStatsEstimate)this.inputStatistics, (PlanNodeStatsEstimate)this.inputStatistics, (VariableReferenceExpression)this.emptyRange, (VariableReferenceExpression)this.emptyRange)).outputRowsCount(0.0);
        PlanNodeStatsAssertion.assertThat(SemiJoinStatsCalculator.computeSemiJoin((PlanNodeStatsEstimate)this.inputStatistics, (PlanNodeStatsEstimate)this.inputStatistics, (VariableReferenceExpression)this.fractionalNdv, (VariableReferenceExpression)this.fractionalNdv)).outputRowsCount(1000.0).variableStats(this.fractionalNdv, stats -> stats.nullsFraction(0.0).distinctValuesCount(0.1));
    }

    @Test
    public void testAntiJoin() {
        PlanNodeStatsAssertion.assertThat(SemiJoinStatsCalculator.computeAntiJoin((PlanNodeStatsEstimate)this.inputStatistics, (PlanNodeStatsEstimate)this.inputStatistics, (VariableReferenceExpression)this.u, (VariableReferenceExpression)this.x)).variableStats(this.u, stats -> stats.lowValue(this.uStats.getLowValue()).highValue(this.uStats.getHighValue()).nullsFraction(0.0).distinctValuesCount(this.uStats.getDistinctValuesCount() - this.xStats.getDistinctValuesCount())).variableStats(this.x, stats -> stats.isEqualTo(this.xStats)).variableStats(this.z, stats -> stats.isEqualTo(this.zStats)).outputRowsCount(this.inputStatistics.getOutputRowCount() * this.uStats.getValuesFraction() * (1.0 - this.xStats.getDistinctValuesCount() / this.uStats.getDistinctValuesCount()));
        PlanNodeStatsAssertion.assertThat(SemiJoinStatsCalculator.computeAntiJoin((PlanNodeStatsEstimate)this.inputStatistics, (PlanNodeStatsEstimate)this.inputStatistics, (VariableReferenceExpression)this.x, (VariableReferenceExpression)this.u)).variableStats(this.x, stats -> stats.lowValue(this.xStats.getLowValue()).highValue(this.xStats.getHighValue()).nullsFraction(0.0).distinctValuesCount(this.xStats.getDistinctValuesCount() * 0.5)).variableStats(this.u, stats -> stats.isEqualTo(this.uStats)).variableStats(this.z, stats -> stats.isEqualTo(this.zStats)).outputRowsCount(this.inputStatistics.getOutputRowCount() * this.xStats.getValuesFraction() * 0.5);
        PlanNodeStatsAssertion.assertThat(SemiJoinStatsCalculator.computeAntiJoin((PlanNodeStatsEstimate)this.inputStatistics, (PlanNodeStatsEstimate)this.inputStatistics, (VariableReferenceExpression)this.unknown, (VariableReferenceExpression)this.u)).variableStats(this.unknown, stats -> stats.nullsFraction(0.0).distinctValuesCountUnknown().unknownRange()).variableStats(this.u, stats -> stats.isEqualTo(this.uStats)).variableStats(this.z, stats -> stats.isEqualTo(this.zStats)).outputRowsCountUnknown();
        PlanNodeStatsAssertion.assertThat(SemiJoinStatsCalculator.computeAntiJoin((PlanNodeStatsEstimate)this.inputStatistics, (PlanNodeStatsEstimate)this.inputStatistics, (VariableReferenceExpression)this.x, (VariableReferenceExpression)this.unknown)).variableStats(this.x, stats -> stats.nullsFraction(0.0).lowValue(this.xStats.getLowValue()).highValue(this.xStats.getHighValue()).distinctValuesCountUnknown()).variableStatsUnknown(this.unknown).variableStats(this.z, stats -> stats.isEqualTo(this.zStats)).outputRowsCountUnknown();
        PlanNodeStatsAssertion.assertThat(SemiJoinStatsCalculator.computeAntiJoin((PlanNodeStatsEstimate)this.inputStatistics, (PlanNodeStatsEstimate)this.inputStatistics, (VariableReferenceExpression)this.emptyRange, (VariableReferenceExpression)this.emptyRange)).outputRowsCount(0.0);
        PlanNodeStatsAssertion.assertThat(SemiJoinStatsCalculator.computeAntiJoin((PlanNodeStatsEstimate)this.inputStatistics, (PlanNodeStatsEstimate)this.inputStatistics, (VariableReferenceExpression)this.fractionalNdv, (VariableReferenceExpression)this.fractionalNdv)).outputRowsCount(500.0).variableStats(this.fractionalNdv, stats -> stats.nullsFraction(0.0).distinctValuesCount(0.05));
    }
}

