/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.execution.QueryExecution;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.memory.VersionedMemoryPoolId;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.resourceGroups.ResourceGroupQueryLimits;
import com.facebook.presto.sql.planner.Plan;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.joda.time.DateTime;

public class MockQueryExecution
implements QueryExecution {
    private static final AtomicLong ID_COUNTER = new AtomicLong(0L);
    private final QueryId queryId;
    private final int runningTaskCount;
    private Optional<Throwable> failureReason = Optional.empty();

    public MockQueryExecution() {
        this(0);
    }

    private MockQueryExecution(int runningTaskCount) {
        this.queryId = QueryId.valueOf((String)String.valueOf(ID_COUNTER.getAndIncrement()));
        this.runningTaskCount = runningTaskCount;
    }

    public static MockQueryExecution withRunningTaskCount(int runningTaskCount) {
        return new MockQueryExecution(runningTaskCount);
    }

    public QueryState getState() {
        return null;
    }

    public ListenableFuture<QueryState> getStateChange(QueryState currentState) {
        return null;
    }

    public void addStateChangeListener(StateMachine.StateChangeListener<QueryState> stateChangeListener) {
    }

    public void addOutputInfoListener(Consumer<QueryExecution.QueryOutputInfo> listener) {
    }

    public Plan getQueryPlan() {
        return null;
    }

    public BasicQueryInfo getBasicQueryInfo() {
        return null;
    }

    public QueryInfo getQueryInfo() {
        return null;
    }

    public String getSlug() {
        return null;
    }

    public int getRetryCount() {
        return 0;
    }

    public Duration getTotalCpuTime() {
        return null;
    }

    public DataSize getRawInputDataSize() {
        return null;
    }

    public long getOutputPositions() {
        return 0L;
    }

    public DataSize getOutputDataSize() {
        return null;
    }

    public int getRunningTaskCount() {
        return this.runningTaskCount;
    }

    public DataSize getUserMemoryReservation() {
        return null;
    }

    public DataSize getTotalMemoryReservation() {
        return null;
    }

    public VersionedMemoryPoolId getMemoryPool() {
        return null;
    }

    public QueryId getQueryId() {
        return this.queryId;
    }

    public boolean isDone() {
        return false;
    }

    public Session getSession() {
        return null;
    }

    public DateTime getCreateTime() {
        return null;
    }

    public Optional<DateTime> getExecutionStartTime() {
        return Optional.empty();
    }

    public DateTime getLastHeartbeat() {
        return null;
    }

    public Optional<DateTime> getEndTime() {
        return Optional.empty();
    }

    public Optional<ResourceGroupQueryLimits> getResourceGroupQueryLimits() {
        return Optional.empty();
    }

    public void fail(Throwable cause) {
        this.failureReason = Optional.ofNullable(cause);
    }

    public Optional<Throwable> getFailureReason() {
        return this.failureReason;
    }

    public void pruneInfo() {
    }

    public void setResourceGroupQueryLimits(ResourceGroupQueryLimits resourceGroupQueryLimits) {
    }

    public void setMemoryPool(VersionedMemoryPoolId poolId) {
    }

    public void start() {
    }

    public void cancelQuery() {
    }

    public void cancelStage(StageId stageId) {
    }

    public void recordHeartbeat() {
    }

    public void addFinalQueryInfoListener(StateMachine.StateChangeListener<QueryInfo> stateChangeListener) {
    }
}

