/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.common.RuntimeMetric;
import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.common.RuntimeUnit;
import com.facebook.presto.execution.QueryStats;
import com.facebook.presto.operator.FilterAndProjectOperator;
import com.facebook.presto.operator.OperatorStats;
import com.facebook.presto.operator.TableWriterOperator;
import com.facebook.presto.spi.eventlistener.StageGcStatistics;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestQueryStats {
    private static final String TEST_METRIC_NAME = "test_metric";
    private static final RuntimeMetric TEST_RUNTIME_METRIC_1 = new RuntimeMetric("test_metric", RuntimeUnit.NONE, 10L, 2L, 9L, 1L);
    private static final RuntimeMetric TEST_RUNTIME_METRIC_2 = new RuntimeMetric("test_metric", RuntimeUnit.NONE, 5L, 2L, 3L, 2L);
    private static final List<OperatorStats> OPERATOR_SUMMARIES = ImmutableList.of((Object)new OperatorStats(10, 101, 11, 12, new PlanNodeId("13"), TableWriterOperator.class.getSimpleName(), 14L, 15L, new Duration(16.0, TimeUnit.NANOSECONDS), new Duration(17.0, TimeUnit.NANOSECONDS), new DataSize(123.0, DataSize.Unit.BYTE), DataSize.succinctBytes((long)18L), 200L, DataSize.succinctBytes((long)19L), 110L, 111.0, 112L, new Duration(113.0, TimeUnit.NANOSECONDS), new Duration(114.0, TimeUnit.NANOSECONDS), new DataSize(234.0, DataSize.Unit.BYTE), DataSize.succinctBytes((long)116L), 117L, DataSize.succinctBytes((long)118L), new Duration(1000.0, TimeUnit.NANOSECONDS), new Duration(119.0, TimeUnit.NANOSECONDS), 120L, new Duration(121.0, TimeUnit.NANOSECONDS), new Duration(122.0, TimeUnit.NANOSECONDS), new DataSize(345.0, DataSize.Unit.BYTE), DataSize.succinctBytes((long)124L), DataSize.succinctBytes((long)125L), DataSize.succinctBytes((long)126L), DataSize.succinctBytes((long)127L), DataSize.succinctBytes((long)128L), DataSize.succinctBytes((long)129L), DataSize.succinctBytes((long)130L), Optional.empty(), null, new RuntimeStats((Map)ImmutableMap.of((Object)"test_metric", (Object)RuntimeMetric.copyOf((RuntimeMetric)TEST_RUNTIME_METRIC_1)))), (Object)new OperatorStats(20, 201, 21, 22, new PlanNodeId("23"), FilterAndProjectOperator.class.getSimpleName(), 24L, 25L, new Duration(26.0, TimeUnit.NANOSECONDS), new Duration(27.0, TimeUnit.NANOSECONDS), new DataSize(1230.0, DataSize.Unit.BYTE), DataSize.succinctBytes((long)28L), 250L, DataSize.succinctBytes((long)29L), 210L, 211.0, 212L, new Duration(213.0, TimeUnit.NANOSECONDS), new Duration(214.0, TimeUnit.NANOSECONDS), new DataSize(2340.0, DataSize.Unit.BYTE), DataSize.succinctBytes((long)216L), 217L, DataSize.succinctBytes((long)218L), new Duration(2000.0, TimeUnit.NANOSECONDS), new Duration(219.0, TimeUnit.NANOSECONDS), 220L, new Duration(221.0, TimeUnit.NANOSECONDS), new Duration(222.0, TimeUnit.NANOSECONDS), new DataSize(3450.0, DataSize.Unit.BYTE), DataSize.succinctBytes((long)224L), DataSize.succinctBytes((long)225L), DataSize.succinctBytes((long)226L), DataSize.succinctBytes((long)227L), DataSize.succinctBytes((long)228L), DataSize.succinctBytes((long)229L), DataSize.succinctBytes((long)230L), Optional.empty(), null, new RuntimeStats((Map)ImmutableMap.of((Object)"test_metric", (Object)RuntimeMetric.copyOf((RuntimeMetric)TEST_RUNTIME_METRIC_2)))), (Object)new OperatorStats(30, 301, 31, 32, new PlanNodeId("33"), TableWriterOperator.class.getSimpleName(), 34L, 35L, new Duration(36.0, TimeUnit.NANOSECONDS), new Duration(37.0, TimeUnit.NANOSECONDS), new DataSize(12300.0, DataSize.Unit.BYTE), DataSize.succinctBytes((long)38L), 350L, DataSize.succinctBytes((long)39L), 310L, 311.0, 312L, new Duration(313.0, TimeUnit.NANOSECONDS), new Duration(314.0, TimeUnit.NANOSECONDS), new DataSize(23400.0, DataSize.Unit.BYTE), DataSize.succinctBytes((long)316L), 317L, DataSize.succinctBytes((long)318L), new Duration(3000.0, TimeUnit.NANOSECONDS), new Duration(319.0, TimeUnit.NANOSECONDS), 320L, new Duration(321.0, TimeUnit.NANOSECONDS), new Duration(322.0, TimeUnit.NANOSECONDS), new DataSize(34500.0, DataSize.Unit.BYTE), DataSize.succinctBytes((long)324L), DataSize.succinctBytes((long)325L), DataSize.succinctBytes((long)326L), DataSize.succinctBytes((long)327L), DataSize.succinctBytes((long)328L), DataSize.succinctBytes((long)329L), DataSize.succinctBytes((long)330L), Optional.empty(), null, new RuntimeStats()));
    static final QueryStats EXPECTED = new QueryStats(new DateTime(1L), new DateTime(2L), new DateTime(3L), new DateTime(4L), new Duration(6.0, TimeUnit.NANOSECONDS), new Duration(7.0, TimeUnit.NANOSECONDS), new Duration(5.0, TimeUnit.NANOSECONDS), new Duration(31.0, TimeUnit.NANOSECONDS), new Duration(15.0, TimeUnit.NANOSECONDS), new Duration(15.0, TimeUnit.NANOSECONDS), new Duration(32.0, TimeUnit.NANOSECONDS), new Duration(41.0, TimeUnit.NANOSECONDS), new Duration(7.0, TimeUnit.NANOSECONDS), new Duration(100.0, TimeUnit.NANOSECONDS), new Duration(200.0, TimeUnit.NANOSECONDS), 9, 10, 11, 11, 12, 13, 15, 30, 16, 17.0, 43.0, new DataSize(18.0, DataSize.Unit.BYTE), new DataSize(19.0, DataSize.Unit.BYTE), new DataSize(20.0, DataSize.Unit.BYTE), new DataSize(21.0, DataSize.Unit.BYTE), new DataSize(22.0, DataSize.Unit.BYTE), new DataSize(23.0, DataSize.Unit.BYTE), new DataSize(42.0, DataSize.Unit.BYTE), true, new Duration(20.0, TimeUnit.NANOSECONDS), new Duration(21.0, TimeUnit.NANOSECONDS), new Duration(0.0, TimeUnit.NANOSECONDS), new Duration(23.0, TimeUnit.NANOSECONDS), false, (Set)ImmutableSet.of(), new DataSize(123.0, DataSize.Unit.BYTE), new DataSize(24.0, DataSize.Unit.BYTE), 25L, new DataSize(26.0, DataSize.Unit.BYTE), 27L, new DataSize(30.0, DataSize.Unit.BYTE), 29L, new DataSize(28.0, DataSize.Unit.BYTE), 29L, 30L, new DataSize(31.0, DataSize.Unit.BYTE), new DataSize(32.0, DataSize.Unit.BYTE), new DataSize(33.0, DataSize.Unit.BYTE), (List)ImmutableList.of((Object)new StageGcStatistics(101, 1001, 102, 103, 104, 105, 106, 107)), OPERATOR_SUMMARIES, new RuntimeStats((Map)ImmutableMap.of((Object)"test_metric", (Object)RuntimeMetric.merge((RuntimeMetric)TEST_RUNTIME_METRIC_1, (RuntimeMetric)TEST_RUNTIME_METRIC_2))));

    @Test
    public void testJson() {
        JsonCodec codec = JsonCodec.jsonCodec(QueryStats.class);
        String json = codec.toJson((Object)EXPECTED);
        QueryStats actual = (QueryStats)codec.fromJson(json);
        TestQueryStats.assertExpectedQueryStats(actual);
    }

    static void assertExpectedQueryStats(QueryStats actual) {
        Assert.assertEquals((Object)actual.getCreateTime(), (Object)new DateTime(1L, DateTimeZone.UTC));
        Assert.assertEquals((Object)actual.getExecutionStartTime(), (Object)new DateTime(2L, DateTimeZone.UTC));
        Assert.assertEquals((Object)actual.getLastHeartbeat(), (Object)new DateTime(3L, DateTimeZone.UTC));
        Assert.assertEquals((Object)actual.getEndTime(), (Object)new DateTime(4L, DateTimeZone.UTC));
        Assert.assertEquals((Object)actual.getElapsedTime(), (Object)new Duration(6.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getQueuedTime(), (Object)new Duration(5.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getResourceWaitingTime(), (Object)new Duration(31.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getSemanticAnalyzingTime(), (Object)new Duration(15.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getColumnAccessPermissionCheckingTime(), (Object)new Duration(15.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getDispatchingTime(), (Object)new Duration(32.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getExecutionTime(), (Object)new Duration(41.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getAnalysisTime(), (Object)new Duration(7.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getTotalPlanningTime(), (Object)new Duration(100.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getFinishingTime(), (Object)new Duration(200.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((int)actual.getTotalTasks(), (int)9);
        Assert.assertEquals((int)actual.getRunningTasks(), (int)10);
        Assert.assertEquals((int)actual.getPeakRunningTasks(), (int)11);
        Assert.assertEquals((int)actual.getCompletedTasks(), (int)11);
        Assert.assertEquals((int)actual.getTotalDrivers(), (int)12);
        Assert.assertEquals((int)actual.getQueuedDrivers(), (int)13);
        Assert.assertEquals((int)actual.getRunningDrivers(), (int)15);
        Assert.assertEquals((int)actual.getBlockedDrivers(), (int)30);
        Assert.assertEquals((int)actual.getCompletedDrivers(), (int)16);
        Assert.assertEquals((double)actual.getCumulativeUserMemory(), (double)17.0);
        Assert.assertEquals((Object)actual.getUserMemoryReservation(), (Object)new DataSize(18.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getTotalMemoryReservation(), (Object)new DataSize(19.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getPeakUserMemoryReservation(), (Object)new DataSize(20.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getPeakTotalMemoryReservation(), (Object)new DataSize(21.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getPeakTaskUserMemory(), (Object)new DataSize(22.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getPeakTaskTotalMemory(), (Object)new DataSize(23.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getSpilledDataSize(), (Object)new DataSize(690.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getTotalScheduledTime(), (Object)new Duration(20.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getTotalCpuTime(), (Object)new Duration(21.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getTotalBlockedTime(), (Object)new Duration(23.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getTotalAllocation(), (Object)new DataSize(123.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getRawInputDataSize(), (Object)new DataSize(24.0, DataSize.Unit.BYTE));
        Assert.assertEquals((long)actual.getRawInputPositions(), (long)25L);
        Assert.assertEquals((Object)actual.getProcessedInputDataSize(), (Object)new DataSize(26.0, DataSize.Unit.BYTE));
        Assert.assertEquals((long)actual.getProcessedInputPositions(), (long)27L);
        Assert.assertEquals((Object)actual.getShuffledDataSize(), (Object)new DataSize(30.0, DataSize.Unit.BYTE));
        Assert.assertEquals((long)actual.getShuffledPositions(), (long)29L);
        Assert.assertEquals((Object)actual.getOutputDataSize(), (Object)new DataSize(28.0, DataSize.Unit.BYTE));
        Assert.assertEquals((long)actual.getOutputPositions(), (long)29L);
        Assert.assertEquals((long)actual.getWrittenOutputPositions(), (long)30L);
        Assert.assertEquals((Object)actual.getWrittenOutputLogicalDataSize(), (Object)new DataSize(31.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getWrittenOutputPhysicalDataSize(), (Object)new DataSize(32.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getWrittenIntermediatePhysicalDataSize(), (Object)new DataSize(33.0, DataSize.Unit.BYTE));
        Assert.assertEquals((int)actual.getStageGcStatistics().size(), (int)1);
        StageGcStatistics gcStatistics = (StageGcStatistics)actual.getStageGcStatistics().get(0);
        Assert.assertEquals((int)gcStatistics.getStageId(), (int)101);
        Assert.assertEquals((int)gcStatistics.getStageExecutionId(), (int)1001);
        Assert.assertEquals((int)gcStatistics.getTasks(), (int)102);
        Assert.assertEquals((int)gcStatistics.getFullGcTasks(), (int)103);
        Assert.assertEquals((int)gcStatistics.getMinFullGcSec(), (int)104);
        Assert.assertEquals((int)gcStatistics.getMaxFullGcSec(), (int)105);
        Assert.assertEquals((int)gcStatistics.getTotalFullGcSec(), (int)106);
        Assert.assertEquals((int)gcStatistics.getAverageFullGcSec(), (int)107);
        TestQueryStats.assertRuntimeMetricEquals(actual.getRuntimeStats().getMetric(TEST_METRIC_NAME), RuntimeMetric.merge((RuntimeMetric)TEST_RUNTIME_METRIC_1, (RuntimeMetric)TEST_RUNTIME_METRIC_2));
    }

    private static void assertRuntimeMetricEquals(RuntimeMetric m1, RuntimeMetric m2) {
        Assert.assertEquals((String)m1.getName(), (String)m2.getName());
        Assert.assertEquals((Object)m1.getUnit(), (Object)m2.getUnit());
        Assert.assertEquals((long)m1.getSum(), (long)m2.getSum());
        Assert.assertEquals((long)m1.getCount(), (long)m2.getCount());
        Assert.assertEquals((long)m1.getMax(), (long)m2.getMax());
        Assert.assertEquals((long)m1.getMin(), (long)m2.getMin());
    }
}

