/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.airlift.concurrent.Threads;
import com.facebook.presto.Session;
import com.facebook.presto.common.transaction.TransactionId;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.execution.RollbackTask;
import com.facebook.presto.execution.TaskTestUtils;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.spi.security.AllowAllAccessControl;
import com.facebook.presto.sql.tree.Rollback;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.transaction.InMemoryTransactionManager;
import com.facebook.presto.transaction.TransactionManager;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestRollbackTask {
    private final MetadataManager metadata = MetadataManager.createTestMetadataManager();
    private final ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"stage-executor-%s"));

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
    }

    @Test
    public void testRollback() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        Session session = TestRollbackTask.sessionBuilder().setTransactionId(transactionManager.beginTransaction(false)).build();
        QueryStateMachine stateMachine = TaskTestUtils.createQueryStateMachine("ROLLBACK", session, true, transactionManager, this.executor, this.metadata);
        WarningCollector warningCollector = stateMachine.getWarningCollector();
        RollbackTask rollbackTask = new RollbackTask();
        Assert.assertTrue((boolean)stateMachine.getSession().getTransactionId().isPresent());
        Assert.assertEquals((int)transactionManager.getAllTransactionInfos().size(), (int)1);
        MoreFutures.getFutureValue((Future)rollbackTask.execute(new Rollback(), transactionManager, (Metadata)this.metadata, (AccessControl)new AllowAllAccessControl(), stateMachine, Collections.emptyList()));
        Assert.assertTrue((boolean)stateMachine.getQueryInfo(Optional.empty()).isClearTransactionId());
        Assert.assertFalse((boolean)stateMachine.getQueryInfo(Optional.empty()).getStartedTransactionId().isPresent());
        Assert.assertTrue((boolean)transactionManager.getAllTransactionInfos().isEmpty());
    }

    @Test
    public void testNoTransactionRollback() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        Session session = TestRollbackTask.sessionBuilder().build();
        QueryStateMachine stateMachine = TaskTestUtils.createQueryStateMachine("ROLLBACK", session, true, transactionManager, this.executor, this.metadata);
        RollbackTask rollbackTask = new RollbackTask();
        try {
            MoreFutures.getFutureValue((Future)rollbackTask.execute(new Rollback(), transactionManager, (Metadata)this.metadata, (AccessControl)new AllowAllAccessControl(), stateMachine, Collections.emptyList()));
            Assert.fail();
        }
        catch (PrestoException e) {
            Assert.assertEquals((Object)e.getErrorCode(), (Object)StandardErrorCode.NOT_IN_TRANSACTION.toErrorCode());
        }
        Assert.assertFalse((boolean)stateMachine.getQueryInfo(Optional.empty()).isClearTransactionId());
        Assert.assertFalse((boolean)stateMachine.getQueryInfo(Optional.empty()).getStartedTransactionId().isPresent());
        Assert.assertTrue((boolean)transactionManager.getAllTransactionInfos().isEmpty());
    }

    @Test
    public void testUnknownTransactionRollback() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        Session session = TestRollbackTask.sessionBuilder().setTransactionId(TransactionId.create()).build();
        QueryStateMachine stateMachine = TaskTestUtils.createQueryStateMachine("ROLLBACK", session, true, transactionManager, this.executor, this.metadata);
        RollbackTask rollbackTask = new RollbackTask();
        MoreFutures.getFutureValue((Future)rollbackTask.execute(new Rollback(), transactionManager, (Metadata)this.metadata, (AccessControl)new AllowAllAccessControl(), stateMachine, Collections.emptyList()));
        Assert.assertTrue((boolean)stateMachine.getQueryInfo(Optional.empty()).isClearTransactionId());
        Assert.assertFalse((boolean)stateMachine.getQueryInfo(Optional.empty()).getStartedTransactionId().isPresent());
        Assert.assertTrue((boolean)transactionManager.getAllTransactionInfos().isEmpty());
    }

    private static Session.SessionBuilder sessionBuilder() {
        return TestingSession.testSessionBuilder().setCatalog("tpch").setSchema("tiny");
    }
}

