/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.client.NodeVersion;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.cost.StatsAndCosts;
import com.facebook.presto.execution.MockRemoteTaskFactory;
import com.facebook.presto.execution.NodeTaskMap;
import com.facebook.presto.execution.RemoteTaskFactory;
import com.facebook.presto.execution.SqlStageExecution;
import com.facebook.presto.execution.StageExecutionId;
import com.facebook.presto.execution.StageExecutionInfo;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.buffer.OutputBuffers;
import com.facebook.presto.execution.scheduler.SplitSchedulerStats;
import com.facebook.presto.execution.scheduler.TableWriteInfo;
import com.facebook.presto.failureDetector.FailureDetector;
import com.facebook.presto.failureDetector.NoOpFailureDetector;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.operator.StageExecutionDescriptor;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.Partitioning;
import com.facebook.presto.sql.planner.PartitioningHandle;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.facebook.presto.util.FinalizerService;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.SettableFuture;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestSqlStageExecution {
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;

    @BeforeClass
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-executor-%s"));
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"test-scheduledExecutor-%s"));
    }

    @AfterClass
    public void tearDown() {
        this.executor.shutdownNow();
        this.executor = null;
        this.scheduledExecutor.shutdownNow();
        this.scheduledExecutor = null;
    }

    @Test(timeOut=180000L)
    public void testFinalStageInfo() throws Exception {
        for (int iteration = 0; iteration < 10; ++iteration) {
            this.testFinalStageInfoInternal();
        }
    }

    private void testFinalStageInfoInternal() throws Exception {
        NodeTaskMap nodeTaskMap = new NodeTaskMap(new FinalizerService());
        StageId stageId = new StageId(new QueryId("query"), 0);
        SqlStageExecution stage = SqlStageExecution.createSqlStageExecution((StageExecutionId)new StageExecutionId(stageId, 0), (PlanFragment)TestSqlStageExecution.createExchangePlanFragment(), (RemoteTaskFactory)new MockRemoteTaskFactory(this.executor, this.scheduledExecutor), (Session)SessionTestUtils.TEST_SESSION, (boolean)true, (NodeTaskMap)nodeTaskMap, (ExecutorService)this.executor, (FailureDetector)new NoOpFailureDetector(), (SplitSchedulerStats)new SplitSchedulerStats(), (TableWriteInfo)new TableWriteInfo(Optional.empty(), Optional.empty(), Optional.empty()));
        stage.setOutputBuffers(OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.ARBITRARY));
        SettableFuture finalStageInfo = SettableFuture.create();
        stage.addFinalStageInfoListener(arg_0 -> ((SettableFuture)finalStageInfo).set(arg_0));
        CountDownLatch latch = new CountDownLatch(1000);
        Future<?> addTasksTask = this.executor.submit(() -> {
            try {
                for (int i = 0; i < 1000000; ++i) {
                    if (Thread.interrupted()) {
                        return;
                    }
                    InternalNode node = new InternalNode("source" + i, URI.create("http://10.0.0." + i / 10000 + ":" + i % 10000), NodeVersion.UNKNOWN, false);
                    stage.scheduleTask(node, i);
                    latch.countDown();
                }
            }
            finally {
                while (latch.getCount() > 0L) {
                    latch.countDown();
                }
            }
        });
        latch.await(1L, TimeUnit.MINUTES);
        Assert.assertFalse((boolean)stage.getStageExecutionInfo().getTasks().isEmpty());
        stage.abort();
        StageExecutionInfo stageInfo = (StageExecutionInfo)finalStageInfo.get(1L, TimeUnit.MINUTES);
        Assert.assertFalse((boolean)stageInfo.getTasks().isEmpty());
        Assert.assertTrue((boolean)stageInfo.isFinal());
        Assert.assertSame((Object)stage.getStageExecutionInfo(), (Object)stageInfo);
        addTasksTask.cancel(true);
    }

    private static PlanFragment createExchangePlanFragment() {
        RemoteSourceNode planNode = new RemoteSourceNode(Optional.empty(), new PlanNodeId("exchange"), (List)ImmutableList.of((Object)new PlanFragmentId(0)), (List)ImmutableList.of((Object)new VariableReferenceExpression(Optional.empty(), "column", (Type)VarcharType.VARCHAR)), false, Optional.empty(), ExchangeNode.Type.REPARTITION);
        return new PlanFragment(new PlanFragmentId(0), (PlanNode)planNode, (Set)ImmutableSet.copyOf((Collection)planNode.getOutputVariables()), SystemPartitioningHandle.SOURCE_DISTRIBUTION, (List)ImmutableList.of((Object)planNode.getId()), new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (Collection)ImmutableList.of()), planNode.getOutputVariables()), StageExecutionDescriptor.ungroupedExecution(), false, StatsAndCosts.empty(), Optional.empty());
    }
}

