/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.cost.StatsAndCosts;
import com.facebook.presto.execution.scheduler.PhasedExecutionSchedule;
import com.facebook.presto.operator.StageExecutionDescriptor;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.plan.UnionNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.Partitioning;
import com.facebook.presto.sql.planner.PartitioningHandle;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.facebook.presto.testing.TestingMetadata;
import com.facebook.presto.testing.TestingTransactionHandle;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPhasedExecutionSchedule {
    private static final AtomicInteger nextPlanFragmentId = new AtomicInteger();

    @Test
    public void testExchange() {
        PlanFragment aFragment = TestPhasedExecutionSchedule.createTableScanPlanFragment("a");
        PlanFragment bFragment = TestPhasedExecutionSchedule.createTableScanPlanFragment("b");
        PlanFragment cFragment = TestPhasedExecutionSchedule.createTableScanPlanFragment("c");
        PlanFragment exchangeFragment = TestPhasedExecutionSchedule.createExchangePlanFragment("exchange", aFragment, bFragment, cFragment);
        List phases = PhasedExecutionSchedule.extractPhases((Collection)ImmutableList.of((Object)aFragment, (Object)bFragment, (Object)cFragment, (Object)exchangeFragment));
        Assert.assertEquals((Collection)phases, (Collection)ImmutableList.of((Object)ImmutableSet.of((Object)exchangeFragment.getId()), (Object)ImmutableSet.of((Object)aFragment.getId()), (Object)ImmutableSet.of((Object)bFragment.getId()), (Object)ImmutableSet.of((Object)cFragment.getId())));
    }

    @Test
    public void testUnion() {
        PlanFragment aFragment = TestPhasedExecutionSchedule.createTableScanPlanFragment("a");
        PlanFragment bFragment = TestPhasedExecutionSchedule.createTableScanPlanFragment("b");
        PlanFragment cFragment = TestPhasedExecutionSchedule.createTableScanPlanFragment("c");
        PlanFragment unionFragment = TestPhasedExecutionSchedule.createUnionPlanFragment("union", aFragment, bFragment, cFragment);
        List phases = PhasedExecutionSchedule.extractPhases((Collection)ImmutableList.of((Object)aFragment, (Object)bFragment, (Object)cFragment, (Object)unionFragment));
        Assert.assertEquals((Collection)phases, (Collection)ImmutableList.of((Object)ImmutableSet.of((Object)unionFragment.getId()), (Object)ImmutableSet.of((Object)aFragment.getId()), (Object)ImmutableSet.of((Object)bFragment.getId()), (Object)ImmutableSet.of((Object)cFragment.getId())));
    }

    @Test
    public void testJoin() {
        PlanFragment buildFragment = TestPhasedExecutionSchedule.createTableScanPlanFragment("build");
        PlanFragment probeFragment = TestPhasedExecutionSchedule.createTableScanPlanFragment("probe");
        PlanFragment joinFragment = TestPhasedExecutionSchedule.createJoinPlanFragment(JoinNode.Type.INNER, "join", buildFragment, probeFragment);
        List phases = PhasedExecutionSchedule.extractPhases((Collection)ImmutableList.of((Object)joinFragment, (Object)buildFragment, (Object)probeFragment));
        Assert.assertEquals((Collection)phases, (Collection)ImmutableList.of((Object)ImmutableSet.of((Object)joinFragment.getId()), (Object)ImmutableSet.of((Object)buildFragment.getId()), (Object)ImmutableSet.of((Object)probeFragment.getId())));
    }

    @Test
    public void testRightJoin() {
        PlanFragment buildFragment = TestPhasedExecutionSchedule.createTableScanPlanFragment("build");
        PlanFragment probeFragment = TestPhasedExecutionSchedule.createTableScanPlanFragment("probe");
        PlanFragment joinFragment = TestPhasedExecutionSchedule.createJoinPlanFragment(JoinNode.Type.RIGHT, "join", buildFragment, probeFragment);
        List phases = PhasedExecutionSchedule.extractPhases((Collection)ImmutableList.of((Object)joinFragment, (Object)buildFragment, (Object)probeFragment));
        Assert.assertEquals((Collection)phases, (Collection)ImmutableList.of((Object)ImmutableSet.of((Object)joinFragment.getId()), (Object)ImmutableSet.of((Object)buildFragment.getId()), (Object)ImmutableSet.of((Object)probeFragment.getId())));
    }

    @Test
    public void testBroadcastJoin() {
        PlanFragment buildFragment = TestPhasedExecutionSchedule.createTableScanPlanFragment("build");
        PlanFragment joinFragment = TestPhasedExecutionSchedule.createBroadcastJoinPlanFragment("join", buildFragment);
        List phases = PhasedExecutionSchedule.extractPhases((Collection)ImmutableList.of((Object)joinFragment, (Object)buildFragment));
        Assert.assertEquals((Collection)phases, (Collection)ImmutableList.of((Object)ImmutableSet.of((Object)joinFragment.getId(), (Object)buildFragment.getId())));
    }

    @Test
    public void testJoinWithDeepSources() {
        PlanFragment buildSourceFragment = TestPhasedExecutionSchedule.createTableScanPlanFragment("buildSource");
        PlanFragment buildMiddleFragment = TestPhasedExecutionSchedule.createExchangePlanFragment("buildMiddle", buildSourceFragment);
        PlanFragment buildTopFragment = TestPhasedExecutionSchedule.createExchangePlanFragment("buildTop", buildMiddleFragment);
        PlanFragment probeSourceFragment = TestPhasedExecutionSchedule.createTableScanPlanFragment("probeSource");
        PlanFragment probeMiddleFragment = TestPhasedExecutionSchedule.createExchangePlanFragment("probeMiddle", probeSourceFragment);
        PlanFragment probeTopFragment = TestPhasedExecutionSchedule.createExchangePlanFragment("probeTop", probeMiddleFragment);
        PlanFragment joinFragment = TestPhasedExecutionSchedule.createJoinPlanFragment(JoinNode.Type.INNER, "join", buildTopFragment, probeTopFragment);
        List phases = PhasedExecutionSchedule.extractPhases((Collection)ImmutableList.of((Object)joinFragment, (Object)buildTopFragment, (Object)buildMiddleFragment, (Object)buildSourceFragment, (Object)probeTopFragment, (Object)probeMiddleFragment, (Object)probeSourceFragment));
        Assert.assertEquals((Collection)phases, (Collection)ImmutableList.of((Object)ImmutableSet.of((Object)joinFragment.getId()), (Object)ImmutableSet.of((Object)buildTopFragment.getId()), (Object)ImmutableSet.of((Object)buildMiddleFragment.getId()), (Object)ImmutableSet.of((Object)buildSourceFragment.getId()), (Object)ImmutableSet.of((Object)probeTopFragment.getId()), (Object)ImmutableSet.of((Object)probeMiddleFragment.getId()), (Object)ImmutableSet.of((Object)probeSourceFragment.getId())));
    }

    private static PlanFragment createExchangePlanFragment(String name, PlanFragment ... fragments) {
        RemoteSourceNode planNode = new RemoteSourceNode(Optional.empty(), new PlanNodeId(name + "_id"), (List)Stream.of(fragments).map(PlanFragment::getId).collect(ImmutableList.toImmutableList()), fragments[0].getPartitioningScheme().getOutputLayout(), false, Optional.empty(), ExchangeNode.Type.REPARTITION);
        return TestPhasedExecutionSchedule.createFragment((PlanNode)planNode);
    }

    private static PlanFragment createUnionPlanFragment(String name, PlanFragment ... fragments) {
        UnionNode planNode = new UnionNode(Optional.empty(), new PlanNodeId(name + "_id"), (List)Stream.of(fragments).map(fragment -> new RemoteSourceNode(Optional.empty(), new PlanNodeId(fragment.getId().toString()), fragment.getId(), fragment.getPartitioningScheme().getOutputLayout(), false, Optional.empty(), ExchangeNode.Type.REPARTITION)).collect(ImmutableList.toImmutableList()), (List)ImmutableList.of(), (Map)ImmutableMap.of());
        return TestPhasedExecutionSchedule.createFragment((PlanNode)planNode);
    }

    private static PlanFragment createBroadcastJoinPlanFragment(String name, PlanFragment buildFragment) {
        VariableReferenceExpression variable = new VariableReferenceExpression(Optional.empty(), "column", (Type)BigintType.BIGINT);
        TableScanNode tableScan = new TableScanNode(Optional.empty(), new PlanNodeId(name), new TableHandle(new ConnectorId("test"), (ConnectorTableHandle)new TestingMetadata.TestingTableHandle(), (ConnectorTransactionHandle)TestingTransactionHandle.create(), Optional.empty()), (List)ImmutableList.of((Object)variable), (Map)ImmutableMap.of((Object)variable, (Object)new TestingMetadata.TestingColumnHandle("column")), TupleDomain.all(), TupleDomain.all());
        RemoteSourceNode remote = new RemoteSourceNode(Optional.empty(), new PlanNodeId("build_id"), buildFragment.getId(), (List)ImmutableList.of(), false, Optional.empty(), ExchangeNode.Type.REPLICATE);
        JoinNode join = new JoinNode(Optional.empty(), new PlanNodeId(name + "_id"), JoinNode.Type.INNER, (PlanNode)tableScan, (PlanNode)remote, (List)ImmutableList.of(), (List)ImmutableList.builder().addAll((Iterable)tableScan.getOutputVariables()).addAll((Iterable)remote.getOutputVariables()).build(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(JoinNode.DistributionType.REPLICATED), (Map)ImmutableMap.of());
        return TestPhasedExecutionSchedule.createFragment((PlanNode)join);
    }

    private static PlanFragment createJoinPlanFragment(JoinNode.Type joinType, String name, PlanFragment buildFragment, PlanFragment probeFragment) {
        RemoteSourceNode probe = new RemoteSourceNode(Optional.empty(), new PlanNodeId("probe_id"), probeFragment.getId(), (List)ImmutableList.of(), false, Optional.empty(), ExchangeNode.Type.REPARTITION);
        RemoteSourceNode build = new RemoteSourceNode(Optional.empty(), new PlanNodeId("build_id"), buildFragment.getId(), (List)ImmutableList.of(), false, Optional.empty(), ExchangeNode.Type.REPARTITION);
        JoinNode planNode = new JoinNode(Optional.empty(), new PlanNodeId(name + "_id"), joinType, (PlanNode)probe, (PlanNode)build, (List)ImmutableList.of(), (List)ImmutableList.builder().addAll((Iterable)probe.getOutputVariables()).addAll((Iterable)build.getOutputVariables()).build(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)ImmutableMap.of());
        return TestPhasedExecutionSchedule.createFragment((PlanNode)planNode);
    }

    private static PlanFragment createTableScanPlanFragment(String name) {
        VariableReferenceExpression variable = new VariableReferenceExpression(Optional.empty(), "column", (Type)BigintType.BIGINT);
        TableScanNode planNode = new TableScanNode(Optional.empty(), new PlanNodeId(name), new TableHandle(new ConnectorId("test"), (ConnectorTableHandle)new TestingMetadata.TestingTableHandle(), (ConnectorTransactionHandle)TestingTransactionHandle.create(), Optional.empty()), (List)ImmutableList.of((Object)variable), (Map)ImmutableMap.of((Object)variable, (Object)new TestingMetadata.TestingColumnHandle("column")), TupleDomain.all(), TupleDomain.all());
        return TestPhasedExecutionSchedule.createFragment((PlanNode)planNode);
    }

    private static PlanFragment createFragment(PlanNode planNode) {
        return new PlanFragment(new PlanFragmentId(nextPlanFragmentId.incrementAndGet()), planNode, (Set)ImmutableSet.copyOf((Collection)planNode.getOutputVariables()), SystemPartitioningHandle.SOURCE_DISTRIBUTION, (List)ImmutableList.of((Object)planNode.getId()), new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (Collection)ImmutableList.of()), planNode.getOutputVariables()), StageExecutionDescriptor.ungroupedExecution(), false, StatsAndCosts.empty(), Optional.empty());
    }
}

