/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.geospatial;

import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.Random;

public class GeometryBenchmarkUtils {
    private GeometryBenchmarkUtils() {
    }

    public static String loadPolygon(String path) throws IOException {
        URL resource = Objects.requireNonNull(GeometryBenchmarkUtils.class.getClassLoader().getResource(path), "resource not found: " + path);
        List lines = Resources.readLines((URL)resource, (Charset)StandardCharsets.UTF_8);
        String line = (String)lines.get(0);
        String[] parts = line.split("\\|");
        return parts[0];
    }

    static double[] createCircleCoordinates(int numVertices) {
        double[] coordinates = new double[2 * numVertices + 2];
        for (int i = 0; i < numVertices; ++i) {
            double angle = (double)i * Math.PI * 2.0 / (double)numVertices;
            coordinates[2 * i] = Math.cos(angle);
            coordinates[2 * i + 1] = Math.sin(angle);
        }
        coordinates[2 * numVertices] = 1.0;
        coordinates[2 * numVertices + 1] = 0.0;
        return coordinates;
    }

    static double[] createRandomCoordinates(int numPoints) {
        int seed = 133;
        double min = 0.0;
        double max = 5.0;
        return new Random(seed).doubles(2 * numPoints, min, max).toArray();
    }

    static double[] createAccordionCoordinates(int numPoints) {
        int seed = 4880;
        double min = 0.0;
        double max = 5.0;
        double[] coordinates = new double[2 * numPoints];
        Random random = new Random(seed);
        for (int i = 0; i < numPoints; ++i) {
            coordinates[2 * i] = random.nextDouble();
            coordinates[2 * i + 1] = (double)i * (max - min) / (double)numPoints + min;
        }
        return coordinates;
    }

    static String createCoordinateString(double ... coordinates) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        String separator = "";
        for (int i = 0; i < coordinates.length; ++i) {
            if (i % 2 == 0) {
                sb.append(separator);
                separator = ",";
            } else {
                sb.append(" ");
            }
            sb.append(coordinates[i]);
        }
        sb.append(")");
        return sb.toString();
    }

    static String createCirclePolygon(int numVertices) {
        StringBuilder sb = new StringBuilder();
        sb.append("POLYGON (");
        sb.append(GeometryBenchmarkUtils.createCoordinateString(GeometryBenchmarkUtils.createCircleCoordinates(numVertices)));
        sb.append(")");
        return sb.toString();
    }
}

