/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.geospatial;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.geospatial.KdbTree;
import com.facebook.presto.geospatial.KdbTreeUtils;
import com.facebook.presto.geospatial.Rectangle;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.testng.annotations.Test;

public class TestKdbTreeCasts
extends AbstractTestFunctions {
    @Test
    public void test() {
        String kdbTreeJson = this.makeKdbTreeJson();
        this.assertFunction(String.format("typeof(cast('%s' AS KdbTree))", kdbTreeJson), (Type)VarcharType.VARCHAR, "KdbTree");
        this.assertFunction(String.format("typeof(cast('%s' AS KDBTree))", kdbTreeJson), (Type)VarcharType.VARCHAR, "KdbTree");
        this.assertFunction(String.format("typeof(cast('%s' AS kdbTree))", kdbTreeJson), (Type)VarcharType.VARCHAR, "KdbTree");
        this.assertFunction(String.format("typeof(cast('%s' AS kdbtree))", kdbTreeJson), (Type)VarcharType.VARCHAR, "KdbTree");
        this.assertInvalidCast("typeof(cast('' AS KdbTree))", "Invalid JSON string for KDB tree");
    }

    private String makeKdbTreeJson() {
        ImmutableList.Builder rectangles = ImmutableList.builder();
        for (double x = 0.0; x < 10.0; x += 1.0) {
            for (double y = 0.0; y < 5.0; y += 1.0) {
                rectangles.add((Object)new Rectangle(x, y, x + 1.0, y + 2.0));
            }
        }
        return KdbTreeUtils.toJson((KdbTree)KdbTree.buildKdbTree((int)100, (List)rectangles.build()));
    }
}

