/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.geospatial;

import com.esri.core.geometry.Point;
import com.esri.core.geometry.ogc.OGCPoint;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.geospatial.GeoFunctions;
import com.facebook.presto.geospatial.SphericalGeoFunctions;
import com.facebook.presto.geospatial.SphericalGeographyType;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.util.ResourceFileUtils;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.stream.Collectors;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSphericalGeoFunctions
extends AbstractTestFunctions {
    @Test
    public void testGetObjectValue() {
        ImmutableList wktList = ImmutableList.of((Object)"POINT EMPTY", (Object)"MULTIPOINT EMPTY", (Object)"LINESTRING EMPTY", (Object)"MULTILINESTRING EMPTY", (Object)"POLYGON EMPTY", (Object)"MULTIPOLYGON EMPTY", (Object)"GEOMETRYCOLLECTION EMPTY", (Object)"POINT (-40.2 28.9)", (Object)"MULTIPOINT ((-40.2 28.9), (-40.2 31.9))", (Object)"LINESTRING (-40.2 28.9, -40.2 31.9, -37.2 31.9)", (Object)"MULTILINESTRING ((-40.2 28.9, -40.2 31.9), (-40.2 31.9, -37.2 31.9))", (Object)"POLYGON ((-40.2 28.9, -37.2 28.9, -37.2 31.9, -40.2 31.9, -40.2 28.9))", (Object[])new String[]{"POLYGON ((-40.2 28.9, -37.2 28.9, -37.2 31.9, -40.2 31.9, -40.2 28.9), (-39.2 29.9, -39.2 30.9, -38.2 30.9, -38.2 29.9, -39.2 29.9))", "MULTIPOLYGON (((-40.2 28.9, -37.2 28.9, -37.2 31.9, -40.2 31.9, -40.2 28.9)), ((-39.2 29.9, -38.2 29.9, -38.2 30.9, -39.2 30.9, -39.2 29.9)))", "GEOMETRYCOLLECTION (POINT (-40.2 28.9), LINESTRING (-40.2 28.9, -40.2 31.9, -37.2 31.9), POLYGON ((-40.2 28.9, -37.2 28.9, -37.2 31.9, -40.2 31.9, -40.2 28.9)))"});
        BlockBuilder builder = SphericalGeographyType.SPHERICAL_GEOGRAPHY.createBlockBuilder(null, wktList.size());
        for (String wkt : wktList) {
            SphericalGeographyType.SPHERICAL_GEOGRAPHY.writeSlice(builder, SphericalGeoFunctions.toSphericalGeography((Slice)GeoFunctions.stGeometryFromText((Slice)Slices.utf8Slice((String)wkt))));
        }
        Block block = builder.build();
        for (int i = 0; i < wktList.size(); ++i) {
            Assert.assertEquals(wktList.get(i), (Object)SphericalGeographyType.SPHERICAL_GEOGRAPHY.getObjectValue(null, block, i));
        }
    }

    @Test
    public void testToAndFromSphericalGeography() {
        this.assertToAndFromSphericalGeography("POINT EMPTY");
        this.assertToAndFromSphericalGeography("MULTIPOINT EMPTY");
        this.assertToAndFromSphericalGeography("LINESTRING EMPTY");
        this.assertToAndFromSphericalGeography("MULTILINESTRING EMPTY");
        this.assertToAndFromSphericalGeography("POLYGON EMPTY");
        this.assertToAndFromSphericalGeography("MULTIPOLYGON EMPTY");
        this.assertToAndFromSphericalGeography("GEOMETRYCOLLECTION EMPTY");
        this.assertToAndFromSphericalGeography("POINT (-40.2 28.9)");
        this.assertToAndFromSphericalGeography("MULTIPOINT ((-40.2 28.9), (-40.2 31.9))");
        this.assertToAndFromSphericalGeography("LINESTRING (-40.2 28.9, -40.2 31.9, -37.2 31.9)");
        this.assertToAndFromSphericalGeography("MULTILINESTRING ((-40.2 28.9, -40.2 31.9), (-40.2 31.9, -37.2 31.9))");
        this.assertToAndFromSphericalGeography("POLYGON ((-40.2 28.9, -40.2 31.9, -37.2 31.9, -37.2 28.9, -40.2 28.9))");
        this.assertToAndFromSphericalGeography("POLYGON ((-40.2 28.9, -40.2 31.9, -37.2 31.9, -37.2 28.9, -40.2 28.9), (-39.2 29.9, -38.2 29.9, -38.2 30.9, -39.2 30.9, -39.2 29.9))");
        this.assertToAndFromSphericalGeography("MULTIPOLYGON (((-40.2 28.9, -40.2 31.9, -37.2 31.9, -37.2 28.9, -40.2 28.9)), ((-39.2 29.9, -39.2 30.9, -38.2 30.9, -38.2 29.9, -39.2 29.9)))");
        this.assertToAndFromSphericalGeography("GEOMETRYCOLLECTION (POINT (-40.2 28.9), LINESTRING (-40.2 28.9, -40.2 31.9, -37.2 31.9), POLYGON ((-40.2 28.9, -40.2 31.9, -37.2 31.9, -37.2 28.9, -40.2 28.9)))");
        this.assertInvalidLongitude("POINT (-340.2 28.9)");
        this.assertInvalidLatitude("MULTIPOINT ((-40.2 128.9), (-40.2 31.9))");
        this.assertInvalidLongitude("LINESTRING (-40.2 28.9, -40.2 31.9, 237.2 31.9)");
        this.assertInvalidLatitude("MULTILINESTRING ((-40.2 28.9, -40.2 31.9), (-40.2 131.9, -37.2 31.9))");
        this.assertInvalidLongitude("POLYGON ((-40.2 28.9, -40.2 31.9, 237.2 31.9, -37.2 28.9, -40.2 28.9))");
        this.assertInvalidLatitude("POLYGON ((-40.2 28.9, -40.2 31.9, -37.2 131.9, -37.2 28.9, -40.2 28.9), (-39.2 29.9, -38.2 29.9, -38.2 30.9, -39.2 30.9, -39.2 29.9))");
        this.assertInvalidLongitude("MULTIPOLYGON (((-40.2 28.9, -40.2 31.9, -37.2 31.9, -37.2 28.9, -40.2 28.9)), ((-39.2 29.9, -39.2 30.9, 238.2 30.9, -38.2 29.9, -39.2 29.9)))");
        this.assertInvalidLatitude("GEOMETRYCOLLECTION (POINT (-40.2 28.9), LINESTRING (-40.2 28.9, -40.2 131.9, -37.2 31.9), POLYGON ((-40.2 28.9, -40.2 31.9, -37.2 31.9, -37.2 28.9, -40.2 28.9)))");
    }

    private void assertToAndFromSphericalGeography(String wkt) {
        this.assertFunction(String.format("ST_AsText(to_geometry(to_spherical_geography(ST_GeometryFromText('%s'))))", wkt), (Type)VarcharType.VARCHAR, wkt);
    }

    private void assertInvalidLongitude(String wkt) {
        this.assertInvalidFunction(String.format("to_spherical_geography(ST_GeometryFromText('%s'))", wkt), "Longitude must be between -180 and 180");
    }

    private void assertInvalidLatitude(String wkt) {
        this.assertInvalidFunction(String.format("to_spherical_geography(ST_GeometryFromText('%s'))", wkt), "Latitude must be between -90 and 90");
    }

    @Test
    public void testGreatCircleDistance() {
        this.assertFunction("great_circle_distance(36.12, -86.67, 33.94, -118.40)", (Type)DoubleType.DOUBLE, 2886.448973436703);
        this.assertFunction("great_circle_distance(33.94, -118.40, 36.12, -86.67)", (Type)DoubleType.DOUBLE, 2886.448973436703);
        this.assertFunction("great_circle_distance(42.3601, -71.0589, 42.4430, -71.2290)", (Type)DoubleType.DOUBLE, 16.73469743457461);
        this.assertFunction("great_circle_distance(36.12, -86.67, 36.12, -86.67)", (Type)DoubleType.DOUBLE, 0.0);
        this.assertInvalidFunction("great_circle_distance(100, 20, 30, 40)", "Latitude must be between -90 and 90");
        this.assertInvalidFunction("great_circle_distance(10, 20, 300, 40)", "Latitude must be between -90 and 90");
        this.assertInvalidFunction("great_circle_distance(10, 200, 30, 40)", "Longitude must be between -180 and 180");
        this.assertInvalidFunction("great_circle_distance(10, 20, 30, 400)", "Longitude must be between -180 and 180");
        this.assertInvalidFunction("great_circle_distance(nan(), -86.67, 33.94, -118.40)", "Latitude must be between -90 and 90");
        this.assertInvalidFunction("great_circle_distance(infinity(), -86.67, 33.94, -118.40)", "Latitude must be between -90 and 90");
        this.assertInvalidFunction("great_circle_distance(36.12, nan(), 33.94, -118.40)", "Longitude must be between -180 and 180");
        this.assertInvalidFunction("great_circle_distance(36.12, infinity(), 33.94, -118.40)", "Longitude must be between -180 and 180");
        this.assertInvalidFunction("great_circle_distance(36.12, -86.67, nan(), -118.40)", "Latitude must be between -90 and 90");
        this.assertInvalidFunction("great_circle_distance(36.12, -86.67, infinity(), -118.40)", "Latitude must be between -90 and 90");
        this.assertInvalidFunction("great_circle_distance(36.12, -86.67, 33.94, nan())", "Longitude must be between -180 and 180");
        this.assertInvalidFunction("great_circle_distance(36.12, -86.67, 33.94, infinity())", "Longitude must be between -180 and 180");
    }

    @Test
    public void testDistance() {
        this.assertDistance("POINT (-86.67 36.12)", "POINT (-118.40 33.94)", 2886448.973436703);
        this.assertDistance("POINT (-118.40 33.94)", "POINT (-86.67 36.12)", 2886448.973436703);
        this.assertDistance("POINT (-71.0589 42.3601)", "POINT (-71.2290 42.4430)", 16734.69743457461);
        this.assertDistance("POINT (-86.67 36.12)", "POINT (-86.67 36.12)", 0.0);
        this.assertDistance("POINT EMPTY", "POINT (40 30)", null);
        this.assertDistance("POINT (20 10)", "POINT EMPTY", null);
        this.assertDistance("POINT EMPTY", "POINT EMPTY", null);
    }

    private void assertDistance(String wkt, String otherWkt, Double expectedDistance) {
        this.assertFunction(String.format("ST_Distance(to_spherical_geography(ST_GeometryFromText('%s')), to_spherical_geography(ST_GeometryFromText('%s')))", wkt, otherWkt), (Type)DoubleType.DOUBLE, expectedDistance);
    }

    @Test
    public void testArea() throws IOException {
        this.assertFunction("ST_Area(to_spherical_geography(ST_GeometryFromText('POLYGON EMPTY')))", (Type)DoubleType.DOUBLE, null);
        this.assertInvalidFunction("ST_Area(to_spherical_geography(ST_GeometryFromText('POINT (0 1)')))", "When applied to SphericalGeography inputs, ST_Area only supports POLYGON or MULTI_POLYGON. Input type is: POINT");
        this.assertInvalidFunction("ST_Area(to_spherical_geography(ST_GeometryFromText('POLYGON((0 0, 0 1, 1 1, 1 1, 1 0, 0 0))')))", "Polygon is not valid: it has two identical consecutive vertices");
        this.assertArea("POLYGON((-135 85, -45 85, 45 85, 135 85, -135 85))", 6.19E11);
        this.assertArea("POLYGON((0 0, 0 1, 1 1, 1 0, 0 0))", 1.2364E10);
        this.assertArea("POLYGON((-122.150124 37.486095, -122.149201 37.486606,  -122.145725 37.486580, -122.145923 37.483961, -122.149324 37.482480,  -122.150837 37.483238,  -122.150901 37.485392, -122.150124 37.486095))", 163290.93943446054);
        double angleOfOneKm = 0.008993201943349;
        this.assertArea(String.format("POLYGON((0 0, %.15f 0, %.15f %.15f, 0 %.15f, 0 0))", angleOfOneKm, angleOfOneKm, angleOfOneKm, angleOfOneKm), 1000000.0);
        this.assertArea("POLYGON((90 0, 0 0, 0 90, 90 0))", 6.3758E13);
        this.assertArea("POLYGON((90 0, 0 0, 0 90, 90 0), (89 1, 1 1, 1 89, 89 1))", 3.4804E12);
        Path geometryPath = Paths.get(ResourceFileUtils.getResourceFile("us-states.tsv").getAbsolutePath(), new String[0]);
        Map<String, String> stateGeometries = Files.lines(geometryPath).map(line -> line.split("\t")).collect(Collectors.toMap(parts -> parts[0], parts -> parts[1]));
        Path areaPath = Paths.get(ResourceFileUtils.getResourceFile("us-state-areas.tsv").getAbsolutePath(), new String[0]);
        Map<String, Double> stateAreas = Files.lines(areaPath).map(line -> line.split("\t")).filter(parts -> ((String[])parts).length >= 2).collect(Collectors.toMap(parts -> parts[0], parts -> Double.valueOf(parts[1])));
        for (String state : stateGeometries.keySet()) {
            this.assertArea(stateGeometries.get(state), stateAreas.get(state));
        }
    }

    private void assertArea(String wkt, double expectedArea) {
        this.assertFunction(String.format("ABS(ROUND((ST_Area(to_spherical_geography(ST_GeometryFromText('%s'))) / %f - 1 ) * %d, 0))", wkt, expectedArea, 10000), (Type)DoubleType.DOUBLE, 0.0);
    }

    @Test
    public void testLength() {
        this.assertLength("LINESTRING EMPTY", null);
        double length = 4350866.6362;
        this.assertLength("LINESTRING (-71.05 42.36, -87.62 41.87, -122.41 37.77)", length);
        this.assertLength("LINESTRING (-122.41 37.77, -87.62 41.87, -71.05 42.36)", length);
        this.assertLength("LINESTRING (0.0 90.0, 0.0 -90.0, 0.0 90.0)", 4.003E7);
        this.assertLength("MULTILINESTRING (EMPTY)", null);
        this.assertLength("MULTILINESTRING ((-71.05 42.36, -87.62 41.87, -122.41 37.77))", length);
        this.assertLength("MULTILINESTRING ((-71.05 42.36, -87.62 41.87, -122.41 37.77), (-73.05 42.36, -89.62 41.87, -124.41 37.77))", 2.0 * length);
        this.assertLength("MULTILINESTRING ((-71.05 42.36, -87.62 41.87), (-87.62 41.87, -122.41 37.77))", length);
    }

    @Test
    public void testSTSphericalCentroid() {
        this.assertSphericalCentroid("POINT (3 5)", new Point(3.0, 5.0));
        this.assertSphericalCentroid("POINT EMPTY", null);
        this.assertSphericalCentroid("MULTIPOINT EMPTY", null);
        this.assertSphericalCentroid("MULTIPOINT (3 5)", new Point(3.0, 5.0));
        this.assertSphericalCentroid("MULTIPOINT (0 -45, 0 45)", new Point(0.0, 0.0));
        this.assertSphericalCentroid("MULTIPOINT (45 0, -45 0)", new Point(0.0, 0.0));
        this.assertSphericalCentroid("MULTIPOINT (0 0, -180 0)", new Point(-90.0, 45.0));
        this.assertSphericalCentroid("MULTIPOINT (0 -45, 0 45, 30 0)", new Point(12.36780515862267, 0.0));
        this.assertSphericalCentroid("MULTIPOINT (0 -45, 0 45, 30 0, -30 0)", new Point(0.0, 0.0));
    }

    private void assertSphericalCentroid(String wkt, Point centroid) {
        String projection = String.format("ST_Centroid(to_spherical_geography(ST_GeometryFromText('%s')))", wkt);
        if (centroid == null) {
            this.assertFunction(projection, (Type)SphericalGeographyType.SPHERICAL_GEOGRAPHY, null);
        } else {
            this.assertFunction(String.format("ST_AsText(%s)", projection), (Type)VarcharType.VARCHAR, new OGCPoint(centroid, null).asText());
        }
    }

    private void assertLength(String lineString, Double expectedLength) {
        String function = String.format("ST_Length(to_spherical_geography(ST_GeometryFromText('%s')))", lineString);
        if (expectedLength == null || expectedLength == 0.0) {
            this.assertFunction(function, (Type)DoubleType.DOUBLE, expectedLength);
        } else {
            this.assertFunction(String.format("ROUND(ABS((%s / %f) - 1.0) / %f, 0)", function, expectedLength, 1.0E-4), (Type)DoubleType.DOUBLE, 0.0);
        }
    }
}

