/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.airlift.discovery.client.ServiceDescriptor;
import com.facebook.airlift.discovery.client.ServiceSelector;
import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.http.client.HttpStatus;
import com.facebook.airlift.http.client.testing.TestingHttpClient;
import com.facebook.airlift.http.client.testing.TestingResponse;
import com.facebook.airlift.node.NodeInfo;
import com.facebook.airlift.testing.Assertions;
import com.facebook.presto.client.NodeVersion;
import com.facebook.presto.failureDetector.FailureDetector;
import com.facebook.presto.failureDetector.NoOpFailureDetector;
import com.facebook.presto.metadata.AllNodes;
import com.facebook.presto.metadata.DiscoveryNodeManager;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.operator.TestingDriftClient;
import com.facebook.presto.server.InternalCommunicationConfig;
import com.facebook.presto.spi.NodeState;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.util.concurrent.ListenableFuture;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import javax.annotation.concurrent.GuardedBy;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestDiscoveryNodeManager {
    private final NodeInfo workerNodeInfo = new NodeInfo("test");
    private final NodeInfo coordinatorNodeInfo = new NodeInfo("test");
    private final NodeInfo resourceManagerNodeInfo = new NodeInfo("test");
    private final NodeInfo catalogServerNodeInfo = new NodeInfo("test");
    private final InternalCommunicationConfig internalCommunicationConfig = new InternalCommunicationConfig();
    private NodeVersion expectedVersion;
    private Set<InternalNode> activeNodes;
    private Set<InternalNode> workerNodes;
    private Set<InternalNode> inactiveNodes;
    private InternalNode coordinator;
    private InternalNode inActiveCoordinator;
    private InternalNode inActiveResourceManager;
    private InternalNode resourceManager;
    private InternalNode catalogServer;
    private InternalNode inActiveCatalogServer;
    private InternalNode workerNode1;
    private final PrestoNodeServiceSelector selector = new PrestoNodeServiceSelector();
    private HttpClient testHttpClient;
    private InternalNode workerNode2;
    private InternalNode workerNode3;
    private InternalNode inActiveWorkerNode1;
    private InternalNode inActiveWorkerNode2;

    @BeforeMethod
    public void setup() {
        this.testHttpClient = new TestingHttpClient(input -> new TestingResponse(HttpStatus.OK, (ListMultimap)ArrayListMultimap.create(), NodeState.ACTIVE.name().getBytes()));
        this.expectedVersion = new NodeVersion("1");
        this.coordinator = new InternalNode(this.coordinatorNodeInfo.getNodeId(), URI.create("https://192.0.2.8"), this.expectedVersion, true);
        this.resourceManager = new InternalNode(this.resourceManagerNodeInfo.getNodeId(), URI.create("https://192.0.2.9"), this.expectedVersion, false, true, false);
        this.catalogServer = new InternalNode(this.catalogServerNodeInfo.getNodeId(), URI.create("https://192.0.3.1"), this.expectedVersion, false, false, true);
        this.workerNode1 = new InternalNode(this.workerNodeInfo.getNodeId(), URI.create("http://192.0.1.1"), this.expectedVersion, false);
        this.workerNode2 = new InternalNode(UUID.randomUUID().toString(), URI.create("http://192.0.2.1:8080"), this.expectedVersion, false);
        this.workerNode3 = new InternalNode(UUID.randomUUID().toString(), URI.create("http://192.0.2.3"), this.expectedVersion, false);
        this.inActiveResourceManager = new InternalNode(this.resourceManagerNodeInfo.getNodeId(), URI.create("https://192.0.2.9"), new NodeVersion("2"), false, true, false);
        this.inActiveCatalogServer = new InternalNode(this.catalogServerNodeInfo.getNodeId(), URI.create("https://192.0.3.2"), new NodeVersion("2"), false, false, true);
        this.inActiveCoordinator = new InternalNode(UUID.randomUUID().toString(), URI.create("https://192.0.3.1"), new NodeVersion("2"), true);
        this.inActiveWorkerNode1 = new InternalNode(UUID.randomUUID().toString(), URI.create("https://192.0.3.9"), NodeVersion.UNKNOWN, false);
        this.inActiveWorkerNode2 = new InternalNode(UUID.randomUUID().toString(), URI.create("https://192.0.4.9"), new NodeVersion("2"), false);
        this.workerNodes = ImmutableSet.of((Object)this.workerNode1, (Object)this.workerNode2, (Object)this.workerNode3);
        this.activeNodes = ImmutableSet.builder().addAll(this.workerNodes).add((Object)this.coordinator).add((Object)this.resourceManager).add((Object)this.catalogServer).build();
        this.inactiveNodes = ImmutableSet.of((Object)this.inActiveCoordinator, (Object)this.inActiveResourceManager, (Object)this.inActiveCatalogServer, (Object)this.inActiveWorkerNode1, (Object)this.inActiveWorkerNode2);
        this.selector.announceNodes(this.activeNodes, this.inactiveNodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetAllNodesForWorkerNode() {
        DiscoveryNodeManager manager = new DiscoveryNodeManager((ServiceSelector)this.selector, this.workerNodeInfo, (FailureDetector)new NoOpFailureDetector(), Optional.empty(), this.expectedVersion, this.testHttpClient, new TestingDriftClient(), this.internalCommunicationConfig);
        try {
            AllNodes allNodes = manager.getAllNodes();
            Set activeNodes = allNodes.getActiveNodes();
            Assertions.assertEqualsIgnoreOrder((Iterable)activeNodes, (Iterable)ImmutableSet.of((Object)this.resourceManager, (Object)this.catalogServer));
            for (InternalNode actual : activeNodes) {
                for (InternalNode expected : this.activeNodes) {
                    Assert.assertNotSame((Object)actual, (Object)expected);
                }
            }
            Assertions.assertEqualsIgnoreOrder((Iterable)activeNodes, (Iterable)manager.getNodes(NodeState.ACTIVE));
            Set inactiveNodes = allNodes.getInactiveNodes();
            Assertions.assertEqualsIgnoreOrder((Iterable)inactiveNodes, (Iterable)ImmutableSet.of((Object)this.inActiveResourceManager, (Object)this.inActiveCatalogServer));
            for (InternalNode actual : inactiveNodes) {
                for (InternalNode expected : this.inactiveNodes) {
                    Assert.assertNotSame((Object)actual, (Object)expected);
                }
            }
            Assertions.assertEqualsIgnoreOrder((Iterable)inactiveNodes, (Iterable)manager.getNodes(NodeState.INACTIVE));
        }
        finally {
            manager.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetAllNodesForCoordinator() {
        DiscoveryNodeManager manager = new DiscoveryNodeManager((ServiceSelector)this.selector, this.coordinatorNodeInfo, (FailureDetector)new NoOpFailureDetector(), Optional.empty(), this.expectedVersion, this.testHttpClient, new TestingDriftClient(), this.internalCommunicationConfig);
        try {
            AllNodes allNodes = manager.getAllNodes();
            Set activeNodes = allNodes.getActiveNodes();
            Assertions.assertEqualsIgnoreOrder((Iterable)activeNodes, this.activeNodes);
            for (InternalNode actual : activeNodes) {
                for (InternalNode expected : this.activeNodes) {
                    Assert.assertNotSame((Object)actual, (Object)expected);
                }
            }
            Assertions.assertEqualsIgnoreOrder((Iterable)activeNodes, (Iterable)manager.getNodes(NodeState.ACTIVE));
            Set inactiveNodes = allNodes.getInactiveNodes();
            Assertions.assertEqualsIgnoreOrder((Iterable)inactiveNodes, this.inactiveNodes);
            for (InternalNode actual : inactiveNodes) {
                for (InternalNode expected : this.inactiveNodes) {
                    Assert.assertNotSame((Object)actual, (Object)expected);
                }
            }
            Assertions.assertEqualsIgnoreOrder((Iterable)inactiveNodes, (Iterable)manager.getNodes(NodeState.INACTIVE));
        }
        finally {
            manager.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetAllNodesForResourceManager() {
        DiscoveryNodeManager manager = new DiscoveryNodeManager((ServiceSelector)this.selector, this.resourceManagerNodeInfo, (FailureDetector)new NoOpFailureDetector(), Optional.empty(), this.expectedVersion, this.testHttpClient, new TestingDriftClient(), this.internalCommunicationConfig);
        try {
            AllNodes allNodes = manager.getAllNodes();
            Set activeNodes = allNodes.getActiveNodes();
            Assertions.assertEqualsIgnoreOrder((Iterable)activeNodes, this.activeNodes);
            for (InternalNode actual : activeNodes) {
                for (InternalNode expected : this.activeNodes) {
                    Assert.assertNotSame((Object)actual, (Object)expected);
                }
            }
            Assertions.assertEqualsIgnoreOrder((Iterable)activeNodes, (Iterable)manager.getNodes(NodeState.ACTIVE));
            Set inactiveNodes = allNodes.getInactiveNodes();
            Assertions.assertEqualsIgnoreOrder((Iterable)inactiveNodes, this.inactiveNodes);
            for (InternalNode actual : inactiveNodes) {
                for (InternalNode expected : this.inactiveNodes) {
                    Assert.assertNotSame((Object)actual, (Object)expected);
                }
            }
            Assertions.assertEqualsIgnoreOrder((Iterable)inactiveNodes, (Iterable)manager.getNodes(NodeState.INACTIVE));
        }
        finally {
            manager.stop();
        }
    }

    @Test
    public void testGetCurrentNode() {
        DiscoveryNodeManager manager = new DiscoveryNodeManager((ServiceSelector)this.selector, this.workerNodeInfo, (FailureDetector)new NoOpFailureDetector(), Optional.empty(), this.expectedVersion, this.testHttpClient, new TestingDriftClient(), this.internalCommunicationConfig);
        try {
            Assert.assertEquals((Object)manager.getCurrentNode(), (Object)this.workerNode1);
        }
        finally {
            manager.stop();
        }
    }

    @Test
    public void testGetCoordinators() {
        DiscoveryNodeManager manager = new DiscoveryNodeManager((ServiceSelector)this.selector, this.resourceManagerNodeInfo, (FailureDetector)new NoOpFailureDetector(), Optional.empty(), this.expectedVersion, this.testHttpClient, new TestingDriftClient(), this.internalCommunicationConfig);
        try {
            Assert.assertEquals((Set)manager.getCoordinators(), (Set)ImmutableSet.of((Object)this.coordinator));
        }
        finally {
            manager.stop();
        }
    }

    @Test
    public void testGetResourceManagers() {
        DiscoveryNodeManager manager = new DiscoveryNodeManager((ServiceSelector)this.selector, this.workerNodeInfo, (FailureDetector)new NoOpFailureDetector(), Optional.of(host -> false), this.expectedVersion, this.testHttpClient, new TestingDriftClient(), this.internalCommunicationConfig);
        try {
            Assert.assertEquals((Set)manager.getResourceManagers(), (Set)ImmutableSet.of((Object)this.resourceManager));
        }
        finally {
            manager.stop();
        }
    }

    @Test
    public void testGetCatalogServers() {
        DiscoveryNodeManager manager = new DiscoveryNodeManager((ServiceSelector)this.selector, this.workerNodeInfo, (FailureDetector)new NoOpFailureDetector(), Optional.of(host -> false), this.expectedVersion, this.testHttpClient, new TestingDriftClient(), this.internalCommunicationConfig);
        try {
            Assert.assertEquals((Set)manager.getCatalogServers(), (Set)ImmutableSet.of((Object)this.catalogServer));
        }
        finally {
            manager.stop();
        }
    }

    @Test(expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp=".* current node not returned .*")
    public void testGetCurrentNodeRequired() {
        new DiscoveryNodeManager((ServiceSelector)this.selector, new NodeInfo("test"), (FailureDetector)new NoOpFailureDetector(), Optional.empty(), this.expectedVersion, this.testHttpClient, new TestingDriftClient(), this.internalCommunicationConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeOut=60000L)
    public void testNodeChangeListener() throws Exception {
        DiscoveryNodeManager manager = new DiscoveryNodeManager((ServiceSelector)this.selector, this.coordinatorNodeInfo, (FailureDetector)new NoOpFailureDetector(), Optional.empty(), this.expectedVersion, this.testHttpClient, new TestingDriftClient(), this.internalCommunicationConfig);
        try {
            manager.startPollingNodeStates();
            ArrayBlockingQueue notifications = new ArrayBlockingQueue(100);
            manager.addNodeChangeListener(notifications::add);
            AllNodes allNodes = (AllNodes)notifications.take();
            Assert.assertEquals((Set)allNodes.getActiveNodes(), this.activeNodes);
            Assert.assertEquals((Set)allNodes.getInactiveNodes(), this.inactiveNodes);
            this.selector.announceNodes((Set)ImmutableSet.of((Object)this.workerNode1), (Set)ImmutableSet.of((Object)this.coordinator));
            allNodes = (AllNodes)notifications.take();
            Assert.assertEquals((Set)allNodes.getActiveNodes(), (Set)ImmutableSet.of((Object)this.workerNode1, (Object)this.coordinator));
            Assert.assertEquals((Set)allNodes.getActiveCoordinators(), (Set)ImmutableSet.of((Object)this.coordinator));
            this.selector.announceNodes(this.activeNodes, this.inactiveNodes);
            allNodes = (AllNodes)notifications.take();
            Assert.assertEquals((Set)allNodes.getActiveNodes(), this.activeNodes);
            Assert.assertEquals((Set)allNodes.getInactiveNodes(), this.inactiveNodes);
        }
        finally {
            manager.stop();
        }
    }

    public static class PrestoNodeServiceSelector
    implements ServiceSelector {
        @GuardedBy(value="this")
        private List<ServiceDescriptor> descriptors = ImmutableList.of();

        private synchronized void announceNodes(Set<InternalNode> activeNodes, Set<InternalNode> inactiveNodes) {
            ImmutableList.Builder descriptors = ImmutableList.builder();
            for (InternalNode node : Iterables.concat(activeNodes, inactiveNodes)) {
                descriptors.add((Object)ServiceDescriptor.serviceDescriptor((String)"presto").setNodeId(node.getNodeIdentifier()).addProperty("http", node.getInternalUri().toString()).addProperty("node_version", node.getNodeVersion().toString()).addProperty("coordinator", String.valueOf(node.isCoordinator())).addProperty("resource_manager", String.valueOf(node.isResourceManager())).addProperty("catalog_server", String.valueOf(node.isCatalogServer())).build());
            }
            this.descriptors = descriptors.build();
        }

        public String getType() {
            return "presto";
        }

        public String getPool() {
            return "general";
        }

        public synchronized List<ServiceDescriptor> selectAllServices() {
            return this.descriptors;
        }

        public ListenableFuture<List<ServiceDescriptor>> refresh() {
            throw new UnsupportedOperationException();
        }
    }
}

