/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.airlift.json.JsonModule;
import com.facebook.airlift.testing.Assertions;
import com.facebook.presto.connector.informationSchema.InformationSchemaTableHandle;
import com.facebook.presto.metadata.HandleJsonModule;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestInformationSchemaTableHandle {
    private static final Map<String, Object> SCHEMA_AS_MAP = ImmutableMap.of((Object)"@type", (Object)"$info_schema", (Object)"catalogName", (Object)"information_schema_catalog", (Object)"schemaName", (Object)"information_schema_schema", (Object)"tableName", (Object)"information_schema_table");
    private ObjectMapper objectMapper;

    @BeforeMethod
    public void startUp() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new JsonModule(), new HandleJsonModule()});
        this.objectMapper = (ObjectMapper)injector.getInstance(ObjectMapper.class);
    }

    @Test
    public void testInformationSchemaSerialize() throws Exception {
        InformationSchemaTableHandle informationSchemaTableHandle = new InformationSchemaTableHandle("information_schema_catalog", "information_schema_schema", "information_schema_table");
        Assert.assertTrue((boolean)this.objectMapper.canSerialize(InformationSchemaTableHandle.class));
        String json = this.objectMapper.writeValueAsString((Object)informationSchemaTableHandle);
        this.testJsonEquals(json, SCHEMA_AS_MAP);
    }

    @Test
    public void testInformationSchemaDeserialize() throws Exception {
        String json = this.objectMapper.writeValueAsString(SCHEMA_AS_MAP);
        ConnectorTableHandle tableHandle = (ConnectorTableHandle)this.objectMapper.readValue(json, ConnectorTableHandle.class);
        Assert.assertEquals(tableHandle.getClass(), InformationSchemaTableHandle.class);
        InformationSchemaTableHandle informationSchemaHandle = (InformationSchemaTableHandle)tableHandle;
        Assert.assertEquals((String)informationSchemaHandle.getCatalogName(), (String)"information_schema_catalog");
        Assert.assertEquals((String)informationSchemaHandle.getSchemaName(), (String)"information_schema_schema");
        Assert.assertEquals((String)informationSchemaHandle.getTableName(), (String)"information_schema_table");
    }

    private void testJsonEquals(String json, Map<String, Object> expectedMap) throws Exception {
        Map jsonMap = (Map)this.objectMapper.readValue(json, (TypeReference)new TypeReference<Map<String, Object>>(){});
        Assertions.assertEqualsIgnoreOrder(jsonMap.entrySet(), expectedMap.entrySet());
    }
}

