/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.array.LongBigArray;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.LongArrayBlock;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.BigintGroupByHash;
import com.facebook.presto.operator.InterpretedHashGenerator;
import com.facebook.presto.operator.MultiChannelGroupByHash;
import com.facebook.presto.operator.UpdateMemory;
import com.facebook.presto.operator.Work;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.facebook.presto.type.BigintOperators;
import com.facebook.presto.type.VarcharOperators;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.slice.XxHash64;
import it.unimi.dsi.fastutil.HashCommon;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.profile.GCProfiler;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=2)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkGroupByHash {
    private static final int POSITIONS = 10000000;
    private static final String GROUP_COUNT_STRING = "3000000";
    private static final int GROUP_COUNT = Integer.parseInt("3000000");
    private static final int EXPECTED_SIZE = 10000;

    @Benchmark
    @OperationsPerInvocation(value=10000000)
    public Object groupByHashPreCompute(BenchmarkData data) {
        MultiChannelGroupByHash groupByHash = new MultiChannelGroupByHash(data.getTypes(), data.getChannels(), data.getHashChannel(), 10000, false, BenchmarkGroupByHash.getJoinCompiler(data.isGroupByUsesEqual()), UpdateMemory.NOOP);
        for (Page page : data.getPages()) {
            boolean finished;
            Work work = groupByHash.addPage(page);
            while (!(finished = work.process())) {
            }
        }
        ImmutableList.Builder pages = ImmutableList.builder();
        PageBuilder pageBuilder = new PageBuilder(groupByHash.getTypes());
        for (int groupId = 0; groupId < groupByHash.getGroupCount(); ++groupId) {
            pageBuilder.declarePosition();
            groupByHash.appendValuesTo(groupId, pageBuilder, 0);
            if (!pageBuilder.isFull()) continue;
            pages.add((Object)pageBuilder.build());
            pageBuilder.reset();
        }
        pages.add((Object)pageBuilder.build());
        return pageBuilder.build();
    }

    @Benchmark
    @OperationsPerInvocation(value=10000000)
    public List<Page> benchmarkHashPosition(BenchmarkData data) {
        InterpretedHashGenerator hashGenerator = new InterpretedHashGenerator(data.getTypes(), data.getChannels());
        ImmutableList.Builder results = ImmutableList.builderWithExpectedSize((int)data.getPages().size());
        for (Page page : data.getPages()) {
            long[] hashes = new long[page.getPositionCount()];
            for (int position = 0; position < page.getPositionCount(); ++position) {
                hashes[position] = hashGenerator.hashPosition(position, page);
            }
            results.add((Object)page.appendColumn((Block)new LongArrayBlock(page.getPositionCount(), Optional.empty(), hashes)));
        }
        return results.build();
    }

    @Benchmark
    @OperationsPerInvocation(value=10000000)
    public Object addPagePreCompute(BenchmarkData data) {
        MultiChannelGroupByHash groupByHash = new MultiChannelGroupByHash(data.getTypes(), data.getChannels(), data.getHashChannel(), 10000, false, BenchmarkGroupByHash.getJoinCompiler(data.isGroupByUsesEqual()), UpdateMemory.NOOP);
        for (Page page : data.getPages()) {
            boolean finished;
            Work work = groupByHash.addPage(page);
            while (!(finished = work.process())) {
            }
        }
        ImmutableList.Builder pages = ImmutableList.builder();
        PageBuilder pageBuilder = new PageBuilder(groupByHash.getTypes());
        for (int groupId = 0; groupId < groupByHash.getGroupCount(); ++groupId) {
            pageBuilder.declarePosition();
            groupByHash.appendValuesTo(groupId, pageBuilder, 0);
            if (!pageBuilder.isFull()) continue;
            pages.add((Object)pageBuilder.build());
            pageBuilder.reset();
        }
        pages.add((Object)pageBuilder.build());
        return pageBuilder.build();
    }

    @Benchmark
    @OperationsPerInvocation(value=10000000)
    public Object bigintGroupByHash(SingleChannelBenchmarkData data) {
        BigintGroupByHash groupByHash = new BigintGroupByHash(0, data.getHashEnabled(), 10000, UpdateMemory.NOOP);
        for (Page page : data.getPages()) {
            boolean finished;
            Work work = groupByHash.addPage(page);
            while (!(finished = work.process())) {
            }
        }
        ImmutableList.Builder pages = ImmutableList.builder();
        PageBuilder pageBuilder = new PageBuilder(groupByHash.getTypes());
        for (int groupId = 0; groupId < groupByHash.getGroupCount(); ++groupId) {
            pageBuilder.declarePosition();
            groupByHash.appendValuesTo(groupId, pageBuilder, 0);
            if (!pageBuilder.isFull()) continue;
            pages.add((Object)pageBuilder.build());
            pageBuilder.reset();
        }
        pages.add((Object)pageBuilder.build());
        return pageBuilder.build();
    }

    @Benchmark
    @OperationsPerInvocation(value=10000000)
    public long baseline(BaselinePagesData data) {
        int hashSize = HashCommon.arraySize((int)GROUP_COUNT, (float)0.9f);
        int mask = hashSize - 1;
        long[] table = new long[hashSize];
        Arrays.fill(table, -1L);
        long groupIds = 0L;
        for (Page page : data.getPages()) {
            Block block = page.getBlock(0);
            int positionCount = block.getPositionCount();
            for (int position = 0; position < positionCount; ++position) {
                long value = block.getLong(position);
                int tablePosition = (int)(value & (long)mask);
                while (table[tablePosition] != -1L && table[tablePosition] != value) {
                    ++tablePosition;
                }
                if (table[tablePosition] != -1L) continue;
                table[tablePosition] = value;
                ++groupIds;
            }
        }
        return groupIds;
    }

    @Benchmark
    @OperationsPerInvocation(value=10000000)
    public long baselineBigArray(BaselinePagesData data) {
        int hashSize = HashCommon.arraySize((int)GROUP_COUNT, (float)0.9f);
        int mask = hashSize - 1;
        LongBigArray table = new LongBigArray(-1L);
        table.ensureCapacity((long)hashSize);
        long groupIds = 0L;
        for (Page page : data.getPages()) {
            Block block = page.getBlock(0);
            int positionCount = block.getPositionCount();
            for (int position = 0; position < positionCount; ++position) {
                long value = BigintType.BIGINT.getLong(block, position);
                int tablePosition = (int)XxHash64.hash((long)value) & mask;
                while (table.get((long)tablePosition) != -1L && table.get((long)tablePosition) != value) {
                    ++tablePosition;
                }
                if (table.get((long)tablePosition) != -1L) continue;
                table.set((long)tablePosition, value);
                ++groupIds;
            }
        }
        return groupIds;
    }

    private static List<Page> createBigintPages(int positionCount, int groupCount, int channelCount, boolean hashEnabled) {
        ImmutableList types = Collections.nCopies(channelCount, BigintType.BIGINT);
        ImmutableList.Builder pages = ImmutableList.builder();
        if (hashEnabled) {
            types = ImmutableList.copyOf((Iterable)Iterables.concat(types, (Iterable)ImmutableList.of((Object)BigintType.BIGINT)));
        }
        PageBuilder pageBuilder = new PageBuilder(types);
        for (int position = 0; position < positionCount; ++position) {
            int rand = ThreadLocalRandom.current().nextInt(groupCount);
            pageBuilder.declarePosition();
            for (int numChannel = 0; numChannel < channelCount; ++numChannel) {
                BigintType.BIGINT.writeLong(pageBuilder.getBlockBuilder(numChannel), (long)rand);
            }
            if (hashEnabled) {
                BigintType.BIGINT.writeLong(pageBuilder.getBlockBuilder(channelCount), BigintOperators.hashCode((long)rand));
            }
            if (!pageBuilder.isFull()) continue;
            pages.add((Object)pageBuilder.build());
            pageBuilder.reset();
        }
        pages.add((Object)pageBuilder.build());
        return pages.build();
    }

    private static List<Page> createVarcharPages(int positionCount, int groupCount, int channelCount, boolean hashEnabled) {
        ImmutableList types = Collections.nCopies(channelCount, VarcharType.VARCHAR);
        ImmutableList.Builder pages = ImmutableList.builder();
        if (hashEnabled) {
            types = ImmutableList.copyOf((Iterable)Iterables.concat(types, (Iterable)ImmutableList.of((Object)BigintType.BIGINT)));
        }
        PageBuilder pageBuilder = new PageBuilder(types);
        for (int position = 0; position < positionCount; ++position) {
            int rand = ThreadLocalRandom.current().nextInt(groupCount);
            Slice value = Slices.wrappedBuffer((ByteBuffer)ByteBuffer.allocate(4).putInt(rand));
            pageBuilder.declarePosition();
            for (int channel = 0; channel < channelCount; ++channel) {
                VarcharType.VARCHAR.writeSlice(pageBuilder.getBlockBuilder(channel), value);
            }
            if (hashEnabled) {
                BigintType.BIGINT.writeLong(pageBuilder.getBlockBuilder(channelCount), VarcharOperators.hashCode((Slice)value));
            }
            if (!pageBuilder.isFull()) continue;
            pages.add((Object)pageBuilder.build());
            pageBuilder.reset();
        }
        pages.add((Object)pageBuilder.build());
        return pages.build();
    }

    private static JoinCompiler getJoinCompiler(boolean groupByUsesEqual) {
        return new JoinCompiler((Metadata)MetadataManager.createTestMetadataManager(), new FeaturesConfig().setGroupByUsesEqualTo(groupByUsesEqual));
    }

    public static void main(String[] args) throws RunnerException {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        new BenchmarkGroupByHash().groupByHashPreCompute(data);
        new BenchmarkGroupByHash().addPagePreCompute(data);
        SingleChannelBenchmarkData singleChannelBenchmarkData = new SingleChannelBenchmarkData();
        singleChannelBenchmarkData.setup();
        new BenchmarkGroupByHash().bigintGroupByHash(singleChannelBenchmarkData);
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkGroupByHash.class.getSimpleName() + ".*").addProfiler(GCProfiler.class).jvmArgs(new String[]{"-Xmx10g"}).build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        @Param(value={"1", "5", "10", "15", "20"})
        private int channelCount = 1;
        @Param(value={"3000000"})
        private int groupCount = BenchmarkGroupByHash.access$100();
        @Param(value={"true", "false"})
        private boolean hashEnabled;
        @Param(value={"equalTo", "notDistinct"})
        private String groupByType = "notDistinct";
        @Param(value={"VARCHAR", "BIGINT"})
        private String dataType = "VARCHAR";
        private List<Page> pages;
        private Optional<Integer> hashChannel;
        private List<Type> types;
        private int[] channels;

        @Setup
        public void setup() {
            switch (this.dataType) {
                case "VARCHAR": {
                    this.types = Collections.nCopies(this.channelCount, VarcharType.VARCHAR);
                    this.pages = BenchmarkGroupByHash.createVarcharPages(10000000, this.groupCount, this.channelCount, this.hashEnabled);
                    break;
                }
                case "BIGINT": {
                    this.types = Collections.nCopies(this.channelCount, BigintType.BIGINT);
                    this.pages = BenchmarkGroupByHash.createBigintPages(10000000, this.groupCount, this.channelCount, this.hashEnabled);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported dataType");
                }
            }
            this.hashChannel = this.hashEnabled ? Optional.of(this.channelCount) : Optional.empty();
            this.channels = new int[this.channelCount];
            for (int i = 0; i < this.channelCount; ++i) {
                this.channels[i] = i;
            }
        }

        public List<Page> getPages() {
            return this.pages;
        }

        public Optional<Integer> getHashChannel() {
            return this.hashChannel;
        }

        public List<Type> getTypes() {
            return this.types;
        }

        public int[] getChannels() {
            return this.channels;
        }

        public boolean isGroupByUsesEqual() {
            if (this.groupByType.equals("equalTo")) {
                return true;
            }
            if (this.groupByType.equals("notDistinct")) {
                return false;
            }
            throw new UnsupportedOperationException("Unsupported groupByType");
        }
    }

    @State(value=Scope.Thread)
    public static class SingleChannelBenchmarkData {
        @Param(value={"1"})
        private int channelCount = 1;
        @Param(value={"true", "false"})
        private boolean hashEnabled = true;
        @Param(value={"3000000"})
        private int groupCount = BenchmarkGroupByHash.access$100();
        private List<Page> pages;
        private List<Type> types;
        private int[] channels;

        @Setup
        public void setup() {
            this.pages = BenchmarkGroupByHash.createBigintPages(10000000, GROUP_COUNT, this.channelCount, this.hashEnabled);
            this.types = Collections.nCopies(1, BigintType.BIGINT);
            this.channels = new int[1];
            for (int i = 0; i < 1; ++i) {
                this.channels[i] = i;
            }
        }

        public List<Page> getPages() {
            return this.pages;
        }

        public List<Type> getTypes() {
            return this.types;
        }

        public boolean getHashEnabled() {
            return this.hashEnabled;
        }
    }

    @State(value=Scope.Thread)
    public static class BaselinePagesData {
        @Param(value={"1"})
        private int channelCount = 1;
        @Param(value={"false"})
        private boolean hashEnabled;
        @Param(value={"3000000"})
        private int groupCount;
        private List<Page> pages;

        @Setup
        public void setup() {
            this.pages = BenchmarkGroupByHash.createBigintPages(10000000, this.groupCount, this.channelCount, this.hashEnabled);
        }

        public List<Page> getPages() {
            return this.pages;
        }
    }
}

