/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.presto.RowPagesBuilder;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.HashAggregationOperator;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.operator.aggregation.GenericAccumulatorFactory;
import com.facebook.presto.spi.function.JavaAggregationFunctionImplementation;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spiller.SpillerFactory;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.facebook.presto.testing.TestingTaskContext;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.testng.Assert;
import org.testng.annotations.Test;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
@Fork(value=3)
@Warmup(iterations=5)
@Measurement(iterations=10, time=2, timeUnit=TimeUnit.SECONDS)
public class BenchmarkHashAndSegmentedAggregationOperators {
    private static final MetadataManager metadata = MetadataManager.createTestMetadataManager();
    private static final FunctionAndTypeManager FUNCTION_AND_TYPE_MANAGER = metadata.getFunctionAndTypeManager();
    private static final JavaAggregationFunctionImplementation LONG_SUM = FUNCTION_AND_TYPE_MANAGER.getJavaAggregateFunctionImplementation(FUNCTION_AND_TYPE_MANAGER.lookupFunction("sum", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT})));
    private static final JavaAggregationFunctionImplementation COUNT = FUNCTION_AND_TYPE_MANAGER.getJavaAggregateFunctionImplementation(FUNCTION_AND_TYPE_MANAGER.lookupFunction("count", (List)ImmutableList.of()));

    @Benchmark
    public List<Page> benchmark(Context context) {
        DriverContext driverContext = context.createTaskContext().addPipelineContext(0, true, true, false).addDriverContext();
        Operator operator = context.getOperatorFactory().createOperator(driverContext);
        Iterator<Page> input = context.getPages().iterator();
        ImmutableList.Builder outputPages = ImmutableList.builder();
        boolean finishing = false;
        for (int loops = 0; !operator.isFinished() && loops < 1000000; ++loops) {
            Page outputPage;
            if (operator.needsInput()) {
                if (input.hasNext()) {
                    Page inputPage = input.next();
                    operator.addInput(inputPage);
                } else if (!finishing) {
                    operator.finish();
                    finishing = true;
                }
            }
            if ((outputPage = operator.getOutput()) == null) continue;
            outputPages.add((Object)outputPage);
        }
        return outputPages.build();
    }

    @Test
    public void verifyHash() {
        this.verify(1, "hash");
        this.verify(10, "hash");
        this.verify(800, "hash");
        this.verify(100000, "hash");
    }

    @Test
    public void verifySegmented() {
        this.verify(1, "segmented");
        this.verify(10, "segmented");
        this.verify(800, "segmented");
        this.verify(100000, "segmented");
    }

    private void verify(int rowsPerSegment, String operatorType) {
        Context context = new Context();
        context.operatorType = operatorType;
        context.rowsPerSegment = rowsPerSegment;
        context.setup();
        Assert.assertEquals((int)100, (int)context.getPages().size());
        for (int i = 0; i < 100; ++i) {
            Assert.assertEquals((int)1000, (int)context.getPages().get(i).getPositionCount());
        }
        List<Page> outputPages = this.benchmark(context);
        Assert.assertEquals((int)context.outputRows, (int)outputPages.stream().mapToInt(Page::getPositionCount).sum());
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkHashAndSegmentedAggregationOperators.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class Context {
        public static final int TOTAL_PAGES = 100;
        public static final int ROWS_PER_PAGE = 1000;
        @Param(value={"1", "10", "800", "100000"})
        public int rowsPerSegment;
        @Param(value={"segmented", "hash"})
        public String operatorType;
        private ExecutorService executor;
        private ScheduledExecutorService scheduledExecutor;
        private OperatorFactory operatorFactory;
        private List<Page> pages;
        private int outputRows;

        @Setup
        public void setup() {
            this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-executor-%s"));
            this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"test-scheduledExecutor-%s"));
            this.outputRows = 0;
            boolean segmentedAggregation = this.operatorType.equalsIgnoreCase("segmented");
            RowPagesBuilder pagesBuilder = RowPagesBuilder.rowPagesBuilder(true, (List<Integer>)ImmutableList.of((Object)0, (Object)1), new Type[]{VarcharType.VARCHAR, BigintType.BIGINT, BigintType.BIGINT});
            for (int i = 0; i < 100; ++i) {
                BlockBuilder sortedBlockBuilder = VarcharType.VARCHAR.createBlockBuilder(null, 1000);
                for (int j = 0; j < 1000; ++j) {
                    int currentSegment = (i * 1000 + j) / this.rowsPerSegment;
                    VarcharType.VARCHAR.writeString(sortedBlockBuilder, String.valueOf(currentSegment));
                }
                this.outputRows += 999 / this.rowsPerSegment + 1;
                pagesBuilder.addBlocksPage(new Block[]{sortedBlockBuilder, BlockAssertions.createLongRepeatBlock(i, 1000), BlockAssertions.createLongSequenceBlock(0, 1000)});
            }
            this.pages = pagesBuilder.build();
            this.operatorFactory = this.createHashAggregationOperatorFactory(pagesBuilder.getHashChannel(), segmentedAggregation);
        }

        private OperatorFactory createHashAggregationOperatorFactory(Optional<Integer> hashChannel, boolean segmentedAggregation) {
            JoinCompiler joinCompiler = new JoinCompiler((Metadata)metadata, new FeaturesConfig());
            SpillerFactory spillerFactory = (types, localSpillContext, aggregatedMemoryContext) -> null;
            return new HashAggregationOperator.HashAggregationOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT), (List)ImmutableList.of((Object)0, (Object)1), (List)(segmentedAggregation ? ImmutableList.of((Object)0) : ImmutableList.of()), (List)ImmutableList.of(), AggregationNode.Step.SINGLE, false, (List)ImmutableList.of((Object)GenericAccumulatorFactory.generateAccumulatorFactory((JavaAggregationFunctionImplementation)COUNT, (List)ImmutableList.of((Object)2), Optional.empty()), (Object)GenericAccumulatorFactory.generateAccumulatorFactory((JavaAggregationFunctionImplementation)LONG_SUM, (List)ImmutableList.of((Object)2), Optional.empty())), hashChannel, Optional.empty(), 100000, Optional.of(new DataSize(16.0, DataSize.Unit.MEGABYTE)), false, DataSize.succinctBytes((long)8L), DataSize.succinctBytes((long)Integer.MAX_VALUE), spillerFactory, joinCompiler, false);
        }

        public TaskContext createTaskContext() {
            return TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION, (DataSize)new DataSize(2.0, DataSize.Unit.GIGABYTE));
        }

        public OperatorFactory getOperatorFactory() {
            return this.operatorFactory;
        }

        public List<Page> getPages() {
            return this.pages;
        }
    }
}

