/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.metadata.BuiltInTypeAndFunctionNamespaceManager;
import com.facebook.presto.operator.TestAnnotationEngine;
import com.facebook.presto.operator.scalar.annotations.SqlInvokedScalarFromAnnotationsParser;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlFunctionVisibility;
import com.facebook.presto.spi.function.SqlInvokedFunction;
import com.facebook.presto.spi.function.SqlInvokedScalarFunction;
import com.facebook.presto.spi.function.SqlParameter;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.spi.function.TypeVariableConstraint;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAnnotationEngineForSqlInvokedScalars
extends TestAnnotationEngine {
    @Test
    public void testParseFunctionDefinition() {
        Signature expectedSignature = new Signature(QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"sample_sql_invoked_scalar_function"), FunctionKind.SCALAR, new ArrayType((Type)BigintType.BIGINT).getTypeSignature(), (List)ImmutableList.of((Object)IntegerType.INTEGER.getTypeSignature()));
        List functions = SqlInvokedScalarFromAnnotationsParser.parseFunctionDefinitions(SingleImplementationSQLInvokedScalarFunction.class);
        Assert.assertEquals((int)functions.size(), (int)1);
        SqlInvokedFunction f = (SqlInvokedFunction)functions.get(0);
        Assert.assertEquals((Object)f.getSignature(), (Object)expectedSignature);
        Assert.assertTrue((boolean)f.isDeterministic());
        Assert.assertEquals((Object)f.getVisibility(), (Object)SqlFunctionVisibility.PUBLIC);
        Assert.assertEquals((String)f.getDescription(), (String)"Simple SQL invoked scalar function");
        Assert.assertEquals((String)f.getBody(), (String)"RETURN SEQUENCE(1, input)");
    }

    @Test
    public void testParseFunctionDefinitionWithTypeParameter() {
        Signature expectedSignature = new Signature(QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.DEFAULT_NAMESPACE, (String)"sample_sql_invoked_scalar_function_with_type_parameter"), FunctionKind.SCALAR, (List)ImmutableList.of((Object)new TypeVariableConstraint("T", false, false, null, false)), Collections.emptyList(), TypeSignature.parseTypeSignature((String)"array(T)"), (List)ImmutableList.of((Object)new TypeSignature("T", new TypeSignatureParameter[0])), false);
        List functions = SqlInvokedScalarFromAnnotationsParser.parseFunctionDefinitions(SingleImplementationSQLInvokedScalarFunctionWithTypeParameter.class);
        Assert.assertEquals((int)functions.size(), (int)1);
        SqlInvokedFunction f = (SqlInvokedFunction)functions.get(0);
        Assert.assertEquals((Object)f.getSignature(), (Object)expectedSignature);
        Assert.assertTrue((boolean)f.isDeterministic());
        Assert.assertEquals((Object)f.getVisibility(), (Object)SqlFunctionVisibility.PUBLIC);
        Assert.assertEquals((String)f.getDescription(), (String)"Simple SQL invoked scalar function with type parameter");
        Assert.assertEquals((String)f.getBody(), (String)"RETURN ARRAY[input]");
    }

    public static class SingleImplementationSQLInvokedScalarFunctionWithTypeParameter {
        @SqlInvokedScalarFunction(value="sample_sql_invoked_scalar_function_with_type_parameter", deterministic=true, calledOnNullInput=false)
        @Description(value="Simple SQL invoked scalar function with type parameter")
        @TypeParameter(value="T")
        @SqlParameter(name="input", type="T")
        @SqlType(value="array<T>")
        public static String fun() {
            return "RETURN ARRAY[input]";
        }
    }

    public static class SingleImplementationSQLInvokedScalarFunction {
        @SqlInvokedScalarFunction(value="sample_sql_invoked_scalar_function", deterministic=true, calledOnNullInput=false)
        @Description(value="Simple SQL invoked scalar function")
        @SqlParameter(name="input", type="integer")
        @SqlType(value="array<bigint>")
        public static String fun() {
            return "RETURN SEQUENCE(1, input)";
        }
    }
}

