/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.presto.RowPagesBuilder;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.GroupIdOperator;
import com.facebook.presto.operator.OperatorAssertion;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.TestingTaskContext;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestGroupIdOperator {
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;
    private DriverContext driverContext;

    @BeforeMethod
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-executor-%s"));
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"test-scheduledExecutor-%s"));
        this.driverContext = TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION).addPipelineContext(0, true, true, false).addDriverContext();
    }

    @AfterMethod
    public void tearDown() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    public void testGroupId() {
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(false, (List<Integer>)ImmutableList.of(), new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BooleanType.BOOLEAN, BigintType.BIGINT});
        List<Page> input = rowPagesBuilder.addSequencePage(3, 100, 400, 0, 1000).addSequencePage(3, 200, 500, 0, 1100).build();
        GroupIdOperator.GroupIdOperatorFactory operatorFactory = new GroupIdOperator.GroupIdOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BooleanType.BOOLEAN, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT), (List)ImmutableList.of((Object)ImmutableMap.of((Object)0, (Object)1, (Object)1, (Object)2, (Object)3, (Object)0), (Object)ImmutableMap.of((Object)2, (Object)3, (Object)3, (Object)0)));
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, BooleanType.BOOLEAN, BigintType.BIGINT, BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{"400", true, null, 100L, 0L}).row(new Object[]{"401", false, null, 101L, 0L}).row(new Object[]{"402", true, null, 102L, 0L}).row(new Object[]{"500", true, null, 200L, 0L}).row(new Object[]{"501", false, null, 201L, 0L}).row(new Object[]{"502", true, null, 202L, 0L}).row(new Object[]{null, null, 1000L, 100L, 1L}).row(new Object[]{null, null, 1001L, 101L, 1L}).row(new Object[]{null, null, 1002L, 102L, 1L}).row(new Object[]{null, null, 1100L, 200L, 1L}).row(new Object[]{null, null, 1101L, 201L, 1L}).row(new Object[]{null, null, 1102L, 202L, 1L}).build();
        OperatorAssertion.assertOperatorEqualsIgnoreOrder((OperatorFactory)operatorFactory, this.driverContext, input, expected);
    }
}

