/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.testing.Assertions;
import com.facebook.presto.RowPagesBuilder;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.GroupByHashYieldAssertion;
import com.facebook.presto.operator.MarkDistinctOperator;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorAssertion;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.TestingTaskContext;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestMarkDistinctOperator {
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;
    private DriverContext driverContext;
    private JoinCompiler joinCompiler = new JoinCompiler((Metadata)MetadataManager.createTestMetadataManager(), new FeaturesConfig());

    @BeforeMethod
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-executor-%s"));
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"test-scheduledExecutor-%s"));
        this.driverContext = TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION).addPipelineContext(0, true, true, false).addDriverContext();
    }

    @AfterMethod
    public void tearDown() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    @DataProvider
    public Object[][] dataType() {
        return new Object[][]{{VarcharType.VARCHAR}, {BigintType.BIGINT}};
    }

    @DataProvider(name="hashEnabledValues")
    public static Object[][] hashEnabledValuesProvider() {
        return new Object[][]{{true}, {false}};
    }

    @Test(dataProvider="hashEnabledValues")
    public void testMarkDistinct(boolean hashEnabled) {
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), new Type[]{BigintType.BIGINT});
        List<Page> input = rowPagesBuilder.addSequencePage(100, 0).addSequencePage(100, 0).build();
        MarkDistinctOperator.MarkDistinctOperatorFactory operatorFactory = new MarkDistinctOperator.MarkDistinctOperatorFactory(0, new PlanNodeId("test"), rowPagesBuilder.getTypes(), (Collection)ImmutableList.of((Object)0), rowPagesBuilder.getHashChannel(), this.joinCompiler);
        MaterializedResult.Builder expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT, BooleanType.BOOLEAN});
        for (long i = 0L; i < 100L; ++i) {
            expected.row(new Object[]{i, true});
            expected.row(new Object[]{i, false});
        }
        OperatorAssertion.assertOperatorEqualsIgnoreOrder((OperatorFactory)operatorFactory, this.driverContext, input, expected.build(), hashEnabled, Optional.of(1));
    }

    @Test(dataProvider="hashEnabledValues")
    public void testRleDistinctMask(boolean hashEnabled) {
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(hashEnabled, (List<Integer>)Ints.asList((int[])new int[]{0}), new Type[]{BigintType.BIGINT});
        List<Page> inputs = rowPagesBuilder.addSequencePage(100, 0).addSequencePage(100, 50).addSequencePage(1, 200).addSequencePage(1, 100).build();
        Page firstInput = inputs.get(0);
        Page secondInput = inputs.get(1);
        Page singleDistinctPage = inputs.get(2);
        Page singleNotDistinctPage = inputs.get(3);
        MarkDistinctOperator.MarkDistinctOperatorFactory operatorFactory = new MarkDistinctOperator.MarkDistinctOperatorFactory(0, new PlanNodeId("test"), rowPagesBuilder.getTypes(), (Collection)ImmutableList.of((Object)0), rowPagesBuilder.getHashChannel(), this.joinCompiler);
        int maskChannel = firstInput.getChannelCount();
        try (Operator operator = operatorFactory.createOperator(this.driverContext);){
            int position;
            operator.addInput(firstInput);
            Block allDistinctOutput = operator.getOutput().getBlock(maskChannel);
            operator.addInput(firstInput);
            Block noDistinctOutput = operator.getOutput().getBlock(maskChannel);
            Assertions.assertInstanceOf((Object)allDistinctOutput, RunLengthEncodedBlock.class);
            Assert.assertTrue((boolean)BooleanType.BOOLEAN.getBoolean(allDistinctOutput, 0));
            Assertions.assertInstanceOf((Object)noDistinctOutput, RunLengthEncodedBlock.class);
            Assert.assertFalse((boolean)BooleanType.BOOLEAN.getBoolean(noDistinctOutput, 0));
            operator.addInput(secondInput);
            Block halfDistinctOutput = operator.getOutput().getBlock(maskChannel);
            for (position = 0; position < 50; ++position) {
                Assert.assertFalse((boolean)BooleanType.BOOLEAN.getBoolean(halfDistinctOutput, position));
            }
            for (position = 50; position < 100; ++position) {
                Assert.assertTrue((boolean)BooleanType.BOOLEAN.getBoolean(halfDistinctOutput, position));
            }
            operator.addInput(singleDistinctPage);
            Block singleDistinctBlock = operator.getOutput().getBlock(maskChannel);
            Assert.assertFalse((boolean)(singleDistinctBlock instanceof RunLengthEncodedBlock), (String)"single position inputs should not be RLE");
            Assert.assertTrue((boolean)BooleanType.BOOLEAN.getBoolean(singleDistinctBlock, 0));
            operator.addInput(singleNotDistinctPage);
            Block singleNotDistinctBlock = operator.getOutput().getBlock(maskChannel);
            Assert.assertFalse((boolean)(singleNotDistinctBlock instanceof RunLengthEncodedBlock), (String)"single position inputs should not be RLE");
            Assert.assertFalse((boolean)BooleanType.BOOLEAN.getBoolean(singleNotDistinctBlock, 0));
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Test(dataProvider="dataType")
    public void testMemoryReservationYield(Type type) {
        List<Page> input = GroupByHashYieldAssertion.createPagesWithDistinctHashKeys(type, 6000, 600);
        MarkDistinctOperator.MarkDistinctOperatorFactory operatorFactory = new MarkDistinctOperator.MarkDistinctOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)type), (Collection)ImmutableList.of((Object)0), Optional.of(1), this.joinCompiler);
        GroupByHashYieldAssertion.GroupByHashYieldResult result = GroupByHashYieldAssertion.finishOperatorWithYieldingGroupByHash(input, type, (OperatorFactory)operatorFactory, operator -> ((MarkDistinctOperator)operator).getCapacity(), 1400000L);
        Assertions.assertGreaterThan((Comparable)Integer.valueOf(result.getYieldCount()), (Comparable)Integer.valueOf(5));
        Assertions.assertGreaterThan((Comparable)Long.valueOf(result.getMaxReservedBytes()), (Comparable)Long.valueOf(0x1400000L));
        int count = 0;
        for (Page page : result.getOutput()) {
            Assert.assertEquals((int)page.getChannelCount(), (int)3);
            for (int i = 0; i < page.getPositionCount(); ++i) {
                Assert.assertEquals((int)page.getBlock(2).getByte(i), (int)1);
                ++count;
            }
        }
        Assert.assertEquals((int)count, (int)3600000);
    }
}

