/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.OperationTimer;
import com.google.common.util.concurrent.Uninterruptibles;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.slice.XxHash64;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestOperationTimer {
    public static volatile long blackHole;

    @Test
    public void testOverallTiming() {
        this.testOverallTiming(false, false);
        this.testOverallTiming(true, true);
    }

    private void testOverallTiming(boolean trackCpuTime, boolean trackAllocation) {
        InternalTiming timing = new InternalTiming(trackCpuTime, trackAllocation);
        for (int i = 1; i <= 5; ++i) {
            OperationTimer timer = new OperationTimer(trackCpuTime, false, trackAllocation, false);
            TestOperationTimer.doSomething();
            timing.record(arg_0 -> ((OperationTimer)timer).end(arg_0));
        }
    }

    @Test
    public void testOperationTiming() {
        this.testOperationTiming(false, false);
        this.testOperationTiming(true, true);
    }

    private void testOperationTiming(boolean trackCpuTime, boolean trackAllocation) {
        InternalTiming overallTiming = new InternalTiming(true, true);
        InternalTiming operationTiming1 = new InternalTiming(trackCpuTime, trackAllocation);
        InternalTiming operationTiming2 = new InternalTiming(trackCpuTime, trackAllocation);
        InternalTiming operationTiming3 = new InternalTiming(trackCpuTime, trackAllocation);
        OperationTimer timer = new OperationTimer(true, trackCpuTime, true, trackAllocation);
        TestOperationTimer.doSomething();
        operationTiming1.record(arg_0 -> ((OperationTimer)timer).recordOperationComplete(arg_0));
        TestOperationTimer.doSomething();
        operationTiming1.record(arg_0 -> ((OperationTimer)timer).recordOperationComplete(arg_0));
        TestOperationTimer.doSomething();
        operationTiming2.record(arg_0 -> ((OperationTimer)timer).recordOperationComplete(arg_0));
        TestOperationTimer.doSomething();
        operationTiming1.record(arg_0 -> ((OperationTimer)timer).recordOperationComplete(arg_0));
        TestOperationTimer.doSomething();
        operationTiming2.record(arg_0 -> ((OperationTimer)timer).recordOperationComplete(arg_0));
        TestOperationTimer.doSomething();
        operationTiming3.record(arg_0 -> ((OperationTimer)timer).recordOperationComplete(arg_0));
        overallTiming.record(arg_0 -> ((OperationTimer)timer).end(arg_0));
        Assertions.assertThat((long)(operationTiming1.getTiming().getWallNanos() + operationTiming2.getTiming().getWallNanos() + operationTiming3.getTiming().getWallNanos())).isLessThanOrEqualTo(overallTiming.getTiming().getWallNanos());
        Assertions.assertThat((long)(operationTiming1.getTiming().getCpuNanos() + operationTiming2.getTiming().getCpuNanos() + operationTiming3.getTiming().getCpuNanos())).isLessThanOrEqualTo(overallTiming.getTiming().getCpuNanos());
        Assertions.assertThat((long)(operationTiming1.getTiming().getAllocationBytes() + operationTiming2.getTiming().getAllocationBytes() + operationTiming3.getTiming().getAllocationBytes())).isLessThanOrEqualTo(overallTiming.getTiming().getAllocationBytes());
    }

    @Test
    public void testOperationAfterEndAreNotAllowed() {
        OperationTimer.OperationTiming timing = new OperationTimer.OperationTiming();
        OperationTimer timer = new OperationTimer(true, false, true, false);
        timer.end(timing);
        Assertions.assertThatThrownBy(() -> timer.end(timing)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> timer.recordOperationComplete(timing)).isInstanceOf(IllegalStateException.class);
    }

    @Test
    public void testInvalidConstructorArguments() {
        Assertions.assertThatThrownBy(() -> new OperationTimer(false, true, false, false)).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> new OperationTimer(true, true, false, true)).isInstanceOf(IllegalArgumentException.class);
    }

    private static void doSomething() {
        byte[] data = new byte[10000];
        new Random(blackHole).nextBytes(data);
        blackHole = XxHash64.hash((Slice)Slices.wrappedBuffer((byte[])data));
        Uninterruptibles.sleepUninterruptibly((long)50L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    private static class InternalTiming {
        private final boolean trackCpuTime;
        private final boolean trackAllocation;
        private final OperationTimer.OperationTiming timing = new OperationTimer.OperationTiming();
        private long calls;
        private long previousWallNanos;
        private long previousCpuNanos;
        private long previousAllocationBytes;

        private InternalTiming(boolean trackCpuTime, boolean trackAllocation) {
            this.trackCpuTime = trackCpuTime;
            this.trackAllocation = trackAllocation;
        }

        public OperationTimer.OperationTiming getTiming() {
            return this.timing;
        }

        public void record(Consumer<OperationTimer.OperationTiming> timer) {
            this.previousWallNanos = this.timing.getWallNanos();
            this.previousCpuNanos = this.timing.getCpuNanos();
            this.previousAllocationBytes = this.timing.getAllocationBytes();
            Assert.assertEquals((long)this.timing.getCalls(), (long)this.calls);
            timer.accept(this.timing);
            ++this.calls;
            Assert.assertEquals((long)this.timing.getCalls(), (long)this.calls);
            Assertions.assertThat((long)this.timing.getWallNanos()).isGreaterThan(this.previousWallNanos);
            if (this.trackCpuTime) {
                Assertions.assertThat((long)this.timing.getCpuNanos()).isGreaterThan(this.previousCpuNanos);
                Assertions.assertThat((long)this.timing.getWallNanos()).isGreaterThan(this.timing.getCpuNanos());
            } else {
                Assert.assertEquals((long)this.timing.getCpuNanos(), (long)0L);
            }
            if (this.trackAllocation) {
                Assertions.assertThat((long)this.timing.getAllocationBytes()).isGreaterThan(this.previousAllocationBytes);
            } else {
                Assert.assertEquals((long)this.timing.getAllocationBytes(), (long)0L);
            }
        }
    }
}

