/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.drift.codec.ThriftCodec;
import com.facebook.drift.codec.ThriftCodecManager;
import com.facebook.drift.codec.internal.ThriftCodecFactory;
import com.facebook.drift.codec.internal.compiler.CompilerThriftCodecFactory;
import com.facebook.drift.codec.internal.reflection.ReflectionThriftCodecFactory;
import com.facebook.drift.protocol.TBinaryProtocol;
import com.facebook.drift.protocol.TCompactProtocol;
import com.facebook.drift.protocol.TFacebookCompactProtocol;
import com.facebook.drift.protocol.TMemoryBuffer;
import com.facebook.drift.protocol.TProtocol;
import com.facebook.drift.protocol.TProtocolReader;
import com.facebook.drift.protocol.TProtocolWriter;
import com.facebook.drift.protocol.TTransport;
import com.facebook.presto.operator.SplitOperatorInfo;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Function;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestSplitOperatorInfoSerde {
    private static final ThriftCodecManager COMPILER_READ_CODEC_MANAGER = new ThriftCodecManager((ThriftCodecFactory)new CompilerThriftCodecFactory(false), new ThriftCodec[0]);
    private static final ThriftCodecManager COMPILER_WRITE_CODEC_MANAGER = new ThriftCodecManager((ThriftCodecFactory)new CompilerThriftCodecFactory(false), new ThriftCodec[0]);
    private static final ThriftCodec<SplitOperatorInfo> COMPILER_READ_CODEC = COMPILER_READ_CODEC_MANAGER.getCodec(SplitOperatorInfo.class);
    private static final ThriftCodec<SplitOperatorInfo> COMPILER_WRITE_CODEC = COMPILER_WRITE_CODEC_MANAGER.getCodec(SplitOperatorInfo.class);
    private static final ThriftCodecManager REFLECTION_READ_CODEC_MANAGER = new ThriftCodecManager((ThriftCodecFactory)new ReflectionThriftCodecFactory(), new ThriftCodec[0]);
    private static final ThriftCodecManager REFLECTION_WRITE_CODEC_MANAGER = new ThriftCodecManager((ThriftCodecFactory)new ReflectionThriftCodecFactory(), new ThriftCodec[0]);
    private static final ThriftCodec<SplitOperatorInfo> REFLECTION_READ_CODEC = REFLECTION_READ_CODEC_MANAGER.getCodec(SplitOperatorInfo.class);
    private static final ThriftCodec<SplitOperatorInfo> REFLECTION_WRITE_CODEC = REFLECTION_WRITE_CODEC_MANAGER.getCodec(SplitOperatorInfo.class);
    private static final TMemoryBuffer transport = new TMemoryBuffer(102400);
    private SplitOperatorInfo splitOperatorInfo;

    @BeforeMethod
    public void setUp() {
        this.splitOperatorInfo = this.getSplitOperatorInfo();
    }

    @DataProvider
    public Object[][] codecCombinations() {
        return new Object[][]{{COMPILER_READ_CODEC, COMPILER_WRITE_CODEC}, {COMPILER_READ_CODEC, REFLECTION_WRITE_CODEC}, {REFLECTION_READ_CODEC, COMPILER_WRITE_CODEC}, {REFLECTION_READ_CODEC, REFLECTION_WRITE_CODEC}};
    }

    @Test(dataProvider="codecCombinations")
    public void testRoundTripSerializeBinaryProtocol(ThriftCodec<SplitOperatorInfo> readCodec, ThriftCodec<SplitOperatorInfo> writeCodec) throws Exception {
        SplitOperatorInfo splitOperatorInfo = this.getRoundTripSerialize(readCodec, writeCodec, TBinaryProtocol::new);
        this.assertSerde(splitOperatorInfo);
    }

    @Test(dataProvider="codecCombinations")
    public void testRoundTripSerializeTCompactProtocol(ThriftCodec<SplitOperatorInfo> readCodec, ThriftCodec<SplitOperatorInfo> writeCodec) throws Exception {
        SplitOperatorInfo splitOperatorInfo = this.getRoundTripSerialize(readCodec, writeCodec, TCompactProtocol::new);
        this.assertSerde(splitOperatorInfo);
    }

    @Test(dataProvider="codecCombinations")
    public void testRoundTripSerializeTFacebookCompactProtocol(ThriftCodec<SplitOperatorInfo> readCodec, ThriftCodec<SplitOperatorInfo> writeCodec) throws Exception {
        SplitOperatorInfo splitOperatorInfo = this.getRoundTripSerialize(readCodec, writeCodec, TFacebookCompactProtocol::new);
        this.assertSerde(splitOperatorInfo);
    }

    private SplitOperatorInfo getRoundTripSerialize(ThriftCodec<SplitOperatorInfo> readCodec, ThriftCodec<SplitOperatorInfo> writeCodec, Function<TTransport, TProtocol> protocolFactory) throws Exception {
        TProtocol protocol = protocolFactory.apply((TTransport)transport);
        writeCodec.write((Object)this.splitOperatorInfo, (TProtocolWriter)protocol);
        return (SplitOperatorInfo)readCodec.read((TProtocolReader)protocol);
    }

    private void assertSerde(SplitOperatorInfo splitOperatorInfo) {
        Assert.assertEquals((Map)splitOperatorInfo.getSplitInfoMap(), this.getInfoMap());
    }

    private SplitOperatorInfo getSplitOperatorInfo() {
        Map<String, String> infoMap = this.getInfoMap();
        return new SplitOperatorInfo(infoMap);
    }

    private Map<String, String> getInfoMap() {
        return ImmutableMap.builder().put((Object)"path", (Object)"path").put((Object)"start", (Object)Long.toString(100L)).put((Object)"length", (Object)Long.toString(200L)).put((Object)"fileSize", (Object)Long.toString(300L)).build();
    }
}

