/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.operator.aggregation.AbstractTestAggregationFunction;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.PriorityQueue;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDoubleMinNAggregation
extends AbstractTestAggregationFunction {
    @Override
    public Block[] getSequenceBlocks(int start, int length) {
        return new Block[]{BlockAssertions.createDoubleSequenceBlock(start, start + length), BlockAssertions.createLongRepeatBlock(2, length)};
    }

    @Override
    protected String getFunctionName() {
        return "min";
    }

    @Override
    protected List<String> getFunctionParameterTypes() {
        return ImmutableList.of((Object)"double", (Object)"bigint");
    }

    @Override
    public Object getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        if (length == 1) {
            return ImmutableList.of((Object)start);
        }
        return ImmutableList.of((Object)start, (Object)((double)start + 1.0));
    }

    @Test
    public void testMoreCornerCases() {
        this.testCustomAggregation(new Double[]{1.0, 2.0, null, 3.0}, 5);
        this.testInvalidAggregation(new Double[]{1.0, 2.0, 3.0}, 0);
        this.testInvalidAggregation(new Double[]{1.0, 2.0, 3.0}, -1);
    }

    private void testInvalidAggregation(Double[] x, int n) {
        try {
            this.testAggregation(new long[0], BlockAssertions.createDoublesBlock(x), BlockAssertions.createLongRepeatBlock(n, x.length));
        }
        catch (PrestoException e) {
            Assert.assertEquals((String)e.getErrorCode().getName(), (String)StandardErrorCode.INVALID_FUNCTION_ARGUMENT.name());
        }
    }

    private void testCustomAggregation(Double[] values, int n) {
        PriorityQueue heap = new PriorityQueue(n, (x, y) -> -Double.compare(x, y));
        Arrays.stream(values).filter(x -> x != null).forEach(heap::add);
        Double[] expected = new Double[heap.size()];
        for (int i = heap.size() - 1; i >= 0; --i) {
            expected[i] = (Double)heap.remove();
        }
        this.testAggregation(Arrays.asList(expected), BlockAssertions.createDoublesBlock(values), BlockAssertions.createLongRepeatBlock(n, values.length));
    }
}

