/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.differentialentropy;

import com.facebook.presto.operator.aggregation.differentialentropy.EntropyCalculations;
import java.util.Random;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestEntropyCalculations {
    @Test
    public void testUniformDistribution() {
        Random random = new Random(13L);
        double[] samples = new double[10000000];
        for (int i = 0; i < samples.length; ++i) {
            samples[i] = random.nextDouble();
        }
        Assert.assertEquals((double)EntropyCalculations.calculateFromSamplesUsingVasicek((double[])samples), (double)0.0, (double)0.02);
    }

    @Test
    public void testNormalDistribution() {
        Random random = new Random(13L);
        double[] samples = new double[10000000];
        double sigma = 0.5;
        for (int i = 0; i < samples.length; ++i) {
            samples[i] = 5.0 + sigma * random.nextGaussian();
        }
        double expected = 0.5 * Math.log(17.079468445347132 * sigma * sigma) / Math.log(2.0);
        Assert.assertEquals((double)EntropyCalculations.calculateFromSamplesUsingVasicek((double[])samples), (double)expected, (double)0.02);
    }
}

